//=============================================================================
// VisuStella MZ - Message Core
// VisuMZ_1_MessageCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_MessageCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.MessageCore = VisuMZ.MessageCore || {};
VisuMZ.MessageCore.version = 1.48;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.48] [MessageCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Message_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Message Core plugin extends and builds upon the message functionality of
 * RPG Maker MZ and allows you, the game dev, to customize the workflow for
 * your game's message system.
 *
 * Features include all (but not limited to) the following:
 *
 * * Control over general message settings.
 * * Auto-Color key words and/or database entries.
 * * Increases the text codes available to perform newer functions/effects.
 * * Ability for you to implement custom Text Code actions.
 * * Ability for you to implement custom Text code string replacements.
 * * Invoke a macro system to speed up the dev process.
 * * Add a Text Speed option to the Options menu.
 * * Add the ever so useful Word Wrap to your message system.
 * * Extend the choice selection process to your liking.
 * * The ability to enable/disable as well as show/hide certain choices.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 * 
 * Dim Background Extension
 * 
 * Before, when using the Dim Background as a part of a Show Text event, its
 * size is only the same as the message window's width itself. This looked
 * really ugly because it had hard edges cutting off while gradients are seen
 * elsewhere. To make it look better, we extended the dimmed background to span
 * the width of the screen instead.
 * 
 * ---
 * 
 * Extended Messages
 * 
 * If you decide to expand the size of the message window to allow for more
 * rows to be displayed, you can type in the data for them by chaining together
 * Show Message events. They will take data from each other and display them in
 * the same message window as long as there are enough rows.
 * 
 * ---
 *
 * Extended Choice Lists
 * 
 * Choice lists can be extended by just chaining one Choice List event after
 * the other in succession along the same indentation. They do not extend if
 * there is any event other than a Choice List option between them on the same
 * indentation level.
 *
 * ---
 *
 * ============================================================================
 * Text Language Information
 * ============================================================================
 *
 * As of Message Core version 1.46, Text Language has been added. 
 * 
 * The "Text Language" feature allows your players to switch between different
 * languages for your game to allow people from around the globe to enjoy what
 * story you have to tell.
 * 
 * Disclaimers: This is not an automatic translation tool. Translations made
 * through the "Text Language" feature of the VisuStella MZ Message Core
 * will require manual input by the game developer.
 *
 * ---
 * 
 * === How to Enable Switching ===
 * 
 * Text Language is NOT enabled by default. Here's what you have to do:
 * 
 * #1. Open up the Message Core's Plugin Parameters
 * #2. Plugin Parameters > Text Language Settings > Enable Switching?
 * #3. Change the "Enable Switching?" parameter setting to "true".
 * #4. Adjust any other settings as needed.
 * #5. Save the Plugin Parameter changes.
 * #6. Save your game.
 * 
 * Now, it's time to get the CSV file that will contain all of the text used to
 * translate your game's script.
 * 
 * #1. Play test your game. Make sure Play test mode is NOT disabled.
 * #2. A popup will appear asking to create a language CSV file.
 * #3. Click "OK" and let the plugin do its thing.
 * #4. The project's /data/ folder will appear with Language.csv made.
 * #5. The plugin will then ask you to restart your game.
 * 
 * ---
 * 
 * === How to Edit the Language CSV ===
 * 
 * The Language CSV is structured as a normal CSV file would be, which also
 * means it can be modified in programs like Microsoft Excel or Google Sheets.
 * We recommend using either of those programs to modify the text.
 * 
 * We do not recommend modifying the CSV file in programs like notepad directly
 * due to the way certain things like commas (,) are handled and how easy it is
 * to be error-prone.
 * 
 * The table will appear something like this at first:
 * 
 *     Key        English    Chinese    Japanese     Korean
 *     Greeting   Hello      你好       こんにちは    안녕하세요
 *     Farewell   Good-bye   再见       さようなら    안녕히
 *     Wow        Wow        哇         ワオ          와우
 * 
 * The "Key" column refers to the reference key used to determine which lines
 * will be inserted into the text. The columns with the languages will utilize
 * the respective phrases for that language.
 * 
 * You can remove columns containing languages that you aren't planning to
 * translate for your game.
 * 
 * ---
 * 
 * === Things to Keep in Mind ===
 * 
 * When adding text to the CSV file via the spreadsheet editor (Excel or Google
 * Sheets), there's a few things to keep in mind.
 * 
 * ---
 * 
 * ==== Line Breaks ====
 * 
 * When you want to insert line breaks into the translated phrases, use the
 * <br> text code. This is best used for text that is to be transferred into
 * the message window or help window.
 * 
 * ==== Text Codes ====
 * 
 * Text codes like \C[2] can be inserted normally. However, they only work in
 * windows that support text codes, such as the message window or help window.
 * Otherwise, the text codes will not transfer over properly.
 * 
 * ==== Semicolons ====
 * 
 * Due to the nature of the CSV file, we used the semicolon (;) as the
 * separator. As such, semicolons should not be used in the text entries.
 * Though some sentences will work with the semicolon, not all of them will. If
 * you do want to use a semicolon, use the text code <semicolon> instead.
 * 
 *   Example:
 * 
 *   "The pancakes were delicious<semicolon> they were fluffy and sweet."
 * 
 * Other variations of the semicolon text code are <semi> and <semi-colon>.
 * The <semicolon> text code and variants only work with the Language CSV and
 * are ignored otherwise when typed in a regular message box entry.
 * 
 * ---
 * 
 * ==== Macros and Language Switches ====
 * 
 * For those using both text macros and text language switches, macros will be
 * converted to text before language switches as it allows for better text
 * transitions that way.
 * 
 * ---
 * 
 * === How to Use the Reference Keys ===
 * 
 * Remember the "Key" column and the reference keys? Those are used to
 * determine which lines will be inserted into the text for the message window
 * and just about any other window. However, there's a specific way these keys
 * must be used in order for them to work.
 * 
 * The "text code" format works like this. Use any of the following:
 * 
 *   \tl{keyName}
 *   \translate{keyName}
 *   \loc{keyName}
 *   \locale{keyName}
 *   \localize{keyName}
 * 
 * or for those coming from different translation plugins but want to switch
 * over to the VisuStella MZ Message Core's translation system:
 * 
 *   ${keyName}
 * 
 * For example, to use one of the default keys made with the Language CSV:
 * 
 *   \tl{Greeting}
 * 
 * This will yield "Hello" in English, "你好" in Chinese, "こんにちは" in
 * Japanese, and "안녕하세요" in Korean.
 * 
 * Key names are not case sensitive and any trailing spaces will be removed
 * from them in order to make sure the CSV table is stable to reference any
 * translated text from.
 * 
 * You can insert these language "text codes" into item names, skill names,
 * etc. as well as system entries like for Attack, Defense, etc.
 * 
 * ---
 *
 * ============================================================================
 * Available Text Codes
 * ============================================================================
 *
 * The following are text codes that you may use with this plugin. Some of
 * these are original text codes provided by RPG Maker MZ, while others are
 * new text codes added through this plugin. You may even add your own text
 * codes through the plugin parameters.
 *
 * === RPG Maker MZ Text Codes ===
 *
 * The following are text codes that come with RPG Maker MZ. These text codes
 * cannot be edited through the Plugin Parameters.
 *
 * ---
 *
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Global)
 * ------------------   -------------------------------------------------------
 * \V[x]                Replaced by the value of variable 'x'.
 * \N[x]                Replaced by the name of actor 'x'.
 * \P[x]                Replaced by the name of party member 'x'.
 * \C[x]                Draw the subsequent text with window skin color 'x'.
 * \I[x]                Draw icon 'x'.
 *
 * \PX[x]               Moves text x position to 'x'.
 * \PY[x]               Moves text y position to 'y'.
 *
 * \G                   Replaced by the currency unit.
 *
 * \{                   Increase the text font size by one step.
 * \}                   Decrease the text font size by one step.
 * \FS[x]               Changes the text font size to 'x'.
 *
 * \\                   Replaced by the backslash character.
 *
 * ---
 *
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Message Window Only)
 * ------------------   -------------------------------------------------------
 * \$                   Opens the gold window.
 * \.                   Waits a 1/4 second.
 * \|                   Waits a full second.
 * \!                   Waits for button input.
 * \>                   Display remaining text on same line all at once.
 * \<                   Cancel the effect that displays text all at once.
 * \^                   Do not wait for input after displaying text to move on.
 *
 * ---
 *
 * === Message Core Hard-Coded Text Codes ===
 *
 * The following text codes are hard-coded into VisuStella MZ Message Core's
 * code. These text codes cannot be edited through the Plugin Parameters.
 * 
 * ---
 *
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Global)
 * ------------------   -------------------------------------------------------
 * <b>                  Makes subsequent text bold.
 * </b>                 Removes bold from subsequent text.
 * <i>                  Makes subsequent text italic.
 * </i>                 Removes italic from subsequent text.
 * 
 * <left>               Makes subsequent text left-aligned. *Note1*
 * </left>              Removes left-alignment for subsequent text.
 * <center>             Makes subsequent text center-aligned. *Note1*
 * </center>            Removes center-alignment for subsequent text.
 * <right>              Makes subsequent text right-aligned. *Note1*
 * </right>             Removes right-alignment for subsequent text.
 *
 * Note1: Use at line-start. Does not work with Word Wrap.
 *
 * <ColorLock>          Text codes can't change text color for subsequent text.
 * </ColorLock>         Removes Color Lock property.
 *
 * <WordWrap>           Enables Word Wrap for this window. *Note2*
 * </WordWrap>          Disables Word Wrap for this window. *Note2*
 * <br>                 Adds a line break. Requires Word Wrap enabled.
 * <line break>         Adds a line break. Requires Word Wrap enabled.
 *
 * Note2: Some windows cannot use Word Wrap such as the Choice Window.
 * Word Wrap also cannot be used together with <left>, <center>, or <right> and
 * will disable itself if text alignment text codes are detected.
 *
 * \picture<x>          Draws picture x (filename) at current text position.
 * \CenterPicture<x>    Draws picture x (filename) centered at the window.
 *
 * ---
 *
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Message Window Only)
 * ------------------   -------------------------------------------------------
 * \CommonEvent[x]      Runs common event x when text code is reached.
 * \Wait[x]             Makes the message wait x frames before continuing.
 * 
 * <Next Page>          Ends the current message page at this line. This is
 *                      used for messages when rows are at 5 or above and the
 *                      message lines don't match the amount. This is used to
 *                      prevent grabbing message windows from following message
 *                      events. Any lines following <Next Page> in the same
 *                      message event will be ignored.
 * 
 * <Auto>               Resizes message window dimensions to fit text. *Note3*
 * <Auto Width>         Resizes message window width to fit text. *Note3*
 * <Auto Height>        Resizes message window height to fit text. *Note3*
 * 
 * <Auto Actor: x>      Resizes message window and positions it over actor x
 *                      sprite's head. *Note3*
 * <Auto Party: x>      Resizes message window and positions it over party
 *                      member x sprite's head. *Note3*
 * <Auto Player>        Map-Only. Resizes message window and positions it over
 *                      the player sprite's head. *Note3*
 * <Auto Event: x>      Map-Only. Resizes message window and positions it over
 *                      event x sprite's head. *Note3*
 * <Auto Enemy: x>      Battle-Only. Resizes message window and positions it
 *                      over enemy x sprite's head. *Note3*
 *
 * Note3: Upon using these text codes, the message window's settings will be
 * reset for the upcoming message. These effects do not work with Word Wrap.
 *
 * ---
 *
 * ----------------------------   ---------------------------------------------
 * Text Code                      Effect (Battle Only)
 * ----------------------------   ---------------------------------------------
 * <Current Battle Target>        Replaces text code with the current target of
 *                                an action in battle.
 * <Current Battle User>          Replaces text code with the currently active
 *                                user in battle.
 * <Current Battle Action>        Replaces text code with the current battle
 *                                action's name with an icon in front.
 * <Current Battle Action Name>   Replaces text code with the current battle
 *                                action's name without an icon.
 * 
 * If there is no battle, no target, no user, or no action, then the text code
 * will just be replaced with no text.
 * 
 * These text codes are NOT recommended to be used inside of Help Descriptions.
 * They are best used with "Show Text" event commands.
 *
 * ---
 *
 * -----------------------------  ---------------------------------------------
 * Text Code                      Effect (Choice Window Only)
 * -----------------------------  ---------------------------------------------
 * <Show>                         Choice is always shown.
 * <Show Switch: x>               Choice shown if switch x is ON.
 * <Show Switches: x,x,x>         Choice shown if the x switches are all ON.
 * <Show All Switches: x,x,x>     Choice shown if the x switches are all ON.
 * <Show Any Switches: x,x,x>     Choice shown if any of x switches are ON.
 *
 * <Hide>                         Choice is always hidden.
 * <Hide Switch: x>               Choice hidden if switch x is ON.
 * <Hide Switches: x,x,x>         Choice hidden if the x switches are all ON.
 * <Hide All Switches: x,x,x>     Choice hidden if the x switches are all ON.
 * <Hide Any Switches: x,x,x>     Choice hidden if any of x switches are ON.
 *
 * <Enable>                       Choice is always enabled.
 * <Enable Switch: x>             Choice enabled if switch x is ON.
 * <Enable Switches: x,x,x>       Choice enabled if the x switches are all ON.
 * <Enable All Switches: x,x,x>   Choice enabled if the x switches are all ON.
 * <Enable Any Switches: x,x,x>   Choice enabled if any of x switches are ON.
 *
 * <Disable>                      Choice is always disabled.
 * <Disable Switch: x>            Choice disabled if switch x is ON.
 * <Disable Switches: x,x,x>      Choice disabled if the x switches are all ON.
 * <Disable All Switches: x,x,x>  Choice disabled if the x switches are all ON.
 * <Disable Any Switches: x,x,x>  Choice disabled if any of x switches are ON.
 * 
 * <Choice Width: x>              Sets the minimum text area width to x.
 *                                Applies to whole choice window.
 * <Choice Indent: x>             Sets the indent to x value. Applies to
 *                                current choice selection only.
 * 
 * <BgColor: x>                   Requires VisuMZ_0_CoreEngine! Sets background
 *                                color of this choice to 'x' text color. This
 *                                will be combined with a fading
 * <BgColor: x,y>                 Requires VisuMZ_0_CoreEngine! Sets background
 *                                color of this choice to 'x' to 'y' gradient
 *                                text color.
 * <BgColor: #rrggbb>             Requires VisuMZ_0_CoreEngine! Sets background
 *                                color of this choice to '#rrggbb' color using
 *                                hex color values.
 * <BgColor: #rrggbb, #rrggbb>    Requires VisuMZ_0_CoreEngine! Sets background
 *                                color of this choice to '#rrggbb' gradient
 *                                using hex color values.
 * 
 * <Help> text </Help>            Makes a help window appear and have it show
 *                                'text' in its contents. The help window will
 *                                disappear if no text is displayed.
 * 
 * <Shuffle>                      Shuffles the order of all choices. Any cancel
 *                                shortcuts other than "Branch" will be undone.
 * <Shuffle: x>                   Shuffles the order of all choices and only
 *                                x number of them will appear. Any cancel
 *                                shortcuts other than "Branch" will be undone.
 *                                Hidden choices do not count towards x number.
 *
 * ---
 *
 * -----------------------------  ---------------------------------------------
 * Text Code                      Background Effects (Choice Window Only)
 * -----------------------------  ---------------------------------------------
 * 
 * <BgImg: filename>              Creates a background image from img/pictures/
 *                                stretched across the choice rectangle.
 * <BgImg LowerLeft: filename>    Creates a background image from img/pictures/
 *                                scaled to the lower left of choice rect.
 * <BgImg LowerCenter: filename>  Creates a background image from img/pictures/
 *                                scaled to the lower center of choice rect.
 * <BgImg LowerRight: filename>   Creates a background image from img/pictures/
 *                                scaled to the lower right of choice rect.
 * <BgImg MidLeft: filename>      Creates a background image from img/pictures/
 *                                scaled to the middle left of choice rect.
 * <BgImg Center: filename>       Creates a background image from img/pictures/
 *                                scaled to the center of choice rect.
 * <BgImg MidRight: filename>     Creates a background image from img/pictures/
 *                                scaled to the middle right of choice rect.
 * <BgImg UpperLeft: filename>    Creates a background image from img/pictures/
 *                                scaled to the upper left of choice rect.
 * <BgImg UpperCenter: filename>  Creates a background image from img/pictures/
 *                                scaled to the upper center of choice rect.
 * <BgImg UpperRight: filename>   Creates a background image from img/pictures/
 *                                scaled to the upper right of choice rect.
 * 
 * *Note:* For the <BgImg: filename> text code variants, even if the background
 * image is smaller than the choice contents, it will overscale to match its
 * choice rectangle dimensions.
 * 
 * *Note:* Using a background image will clear the dimmed background rectangle
 * that is normally behind each selectable choice.
 * 
 * *Note:* Each choice can only have one background image but can use a
 * combination of one background and one foreground image.
 * 
 * *Note:* Images in the background will appear behind the select cursor.
 *
 * ---
 *
 * -----------------------------  ---------------------------------------------
 * Text Code                      Foreground Effects (Choice Window Only)
 * -----------------------------  ---------------------------------------------
 * 
 * <FgImg: filename>              Creates a foreground image from img/pictures/
 *                                stretched across the choice rectangle.
 * <FgImg LowerLeft: filename>    Creates a foreground image from img/pictures/
 *                                scaled to the lower left of choice rect.
 * <FgImg LowerCenter: filename>  Creates a foreground image from img/pictures/
 *                                scaled to the lower center of choice rect.
 * <FgImg LowerRight: filename>   Creates a foreground image from img/pictures/
 *                                scaled to the lower right of choice rect.
 * <FgImg MidLeft: filename>      Creates a foreground image from img/pictures/
 *                                scaled to the middle left of choice rect.
 * <FgImg Center: filename>       Creates a foreground image from img/pictures/
 *                                scaled to the center of choice rect.
 * <FgImg MidRight: filename>     Creates a foreground image from img/pictures/
 *                                scaled to the middle right of choice rect.
 * <FgImg UpperLeft: filename>    Creates a foreground image from img/pictures/
 *                                scaled to the upper left of choice rect.
 * <FgImg UpperCenter: filename>  Creates a foreground image from img/pictures/
 *                                scaled to the upper center of choice rect.
 * <FgImg UpperRight: filename>   Creates a foreground image from img/pictures/
 *                                scaled to the upper right of choice rect.
 * 
 * *Note:* For the <FgImg: filename> text code variants, unlike the background
 * variant, the foreground image will not overscale past its original size.
 * Instead, it will maintain its original size or be smaller, so long as it can
 * be scaled to exist within the choice rectangle unless it is intended to be
 * stretched by using the <FgImg: filename> variant.
 * 
 * *Note:* Text is then written on top of the foreground image.
 * 
 * *Note:* Each choice can only have one foreground image but can use a
 * combination of one background and one foreground image.
 * 
 * *Note:* Images in the foreground will appear behind the select cursor.
 *
 * ---
 *
 * -----------------  ---------------------------------------------------------
 * Text Code          Effect (Name Window Only)
 * -----------------  ---------------------------------------------------------
 * <Left>             Positions the name box window to the left.
 * <Center>           Positions the name box window to the center.
 * <Right>            Positions the name box window to the right.
 * <Position: x>      Replace 'x' with a number from 0 to 10. This positions
 *                    the name box window on the screen relative to the
 *                    position of the value 'x' represents.
 * \NormalBG          Changes background type of window to normal type.
 * \DimBG             Changes background type of window to dim type.
 * \TransparentBG     Changes background type of window to transparent type.
 *
 * ---
 * 
 * -------------------------------   ------------------------------------------
 * Text Code                         Effect (Message Window Only)
 * -------------------------------   ------------------------------------------
 * 
 * <Position: x, y, width, height>   Forces the message window to exact listed
 *                                   coordinates and dimensions. Replace each
 *                                   of the arguments with numbers. *Note*
 * 
 * <Coordinates: x, y>               Forces the message window to the exact
 *                                   listed coordinates. Replace each of the
 *                                   arguments with numbers. *Note*
 * 
 * <Dimensions: width, height>       Forces the message window size to the
 *                                   exact listed dimensions. Replace each of
 *                                   the arguments with numbers. *Note*
 * 
 * <Offset: +x, +y>                  Quickly adjust the message window offset
 * <Offset: -x, -y>                  values to the x and y amounts. The values
 * <Offset: +x, -y>                  will replace the previous offset settings
 * <Offset: -x, +y>                  if there were any.
 * 
 * *NOTE* These text codes do not work with Word Wrap.
 * 
 * ---
 * 
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Requires VisuMZ_0_CoreEngine)
 * ------------------   -------------------------------------------------------
 * <Up Button>          Display's VisuMZ_0_CoreEngine's button assist text.
 * <Left Button>        Display's VisuMZ_0_CoreEngine's button assist text.
 * <Right Button>       Display's VisuMZ_0_CoreEngine's button assist text.
 * <Down Button>        Display's VisuMZ_0_CoreEngine's button assist text.
 * 
 * <Ok Button>          Display's VisuMZ_0_CoreEngine's button assist text.
 * <Cancel Button>      Display's VisuMZ_0_CoreEngine's button assist text.
 * <Shift Button>       Display's VisuMZ_0_CoreEngine's button assist text.
 * <Menu Button>        Display's VisuMZ_0_CoreEngine's button assist text.
 * <Page Up Button>     Display's VisuMZ_0_CoreEngine's button assist text.
 * <Page Down Button>   Display's VisuMZ_0_CoreEngine's button assist text.
 * 
 * ---
 * 
 * === Random Text Pool ===
 * 
 * <RNG> text1 | text2 | text3 </RNG>
 * 
 * Using the above text code format in a Show Message entry, you can get a
 * random result out of the various inserted texts. Use "|" (without quotes) as
 * a separator between text entries. You can have unlimited entries. The result
 * will have any excess white space trimmed.
 * 
 * This text code cannot be inserted into a macro and parsed properly.
 * 
 * ---
 *
 * === Message Core Customizable Text Codes ===
 *
 * The following text codes can be altered through the Message Core's various
 * Plugin Parameters to adjust replacements and actions.
 *
 * ---
 *
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Global)
 * ------------------   -------------------------------------------------------
 * \Class[x]            Draws class x's icon (if have) and name.
 * \ClassName[x]        Draws class x's name only.
 *
 * \Skill[x]            Draws skill x's icon (if have) and name.
 * \SkillName[x]        Draws skill x's name only.
 *
 * \Item[x]             Draws item x's icon (if have) and name.
 * \ItemName[x]         Draws item x's name only.
 * \ItemQuantity[x]     Inserts the number of item x's owned by the party.
 *
 * \Weapon[x]           Draws weapon x's icon (if have) and name.
 * \WeaponName[x]       Draws weapon x's name only.
 * \WeaponQuantity[x]   Inserts the number of weapon x's owned by the party.
 *
 * \Armor[x]            Draws armor x's icon (if have) and name.
 * \ArmorName[x]        Draws armor x's name only.
 * \ArmorQuantity[x]    Inserts the number of armor x's owned by the party.
 *
 * \LastGainObj         Draws the icon + name of the last party-gained object.
 * \LastGainObjName     Draws the name of the last party-gained object.
 * \LastGainObjQuantity Inserts the quantity of the last party-gained object.
 *
 * \State[x]            Draws state x's icon (if have) and name.
 * \StateName[x]        Draws state x's name only.
 *
 * \Enemy[x]            Draws enemy x's icon (if have) and name.
 * \EnemyName[x]        Draws enemy x's name only.
 *
 * \Troop[x]            Draws troop x's icon (if have) and name.
 * \TroopName[x]        Draws troop x's name only.
 *
 * \TroopMember[x]      Draws troop member x's icon (if have) and name. *Note1*
 * \TroopNameMember[x]  Draws troop member x's name only. *Note1*
 * 
 * Note1: Only works in battle.
 *
 * \NormalBG            Changes background type of window to normal type.
 * \DimBG               Changes background type of window to dim type.
 * \TransparentBG       Changes background type of window to transparent type.
 *
 * \FontChange<x>       Changes font face to x font name.
 * \ResetFont           Resets font settings.
 *
 * \ResetColor          Resets color settings.
 * \HexColor<x>         Changes text color to x hex color (ie. #123abc).
 * \OutlineColor[x]     Changes outline color to text color x.
 * \OutlineHexColor<x>  Changes outline color to x hex color (ie. #123abc).
 * \OutlineWidth[x]     Changes outline width to x thickness.
 * 
 * \WindowMoveTo<?>     Moves window to exact coordinates. *Note2*
 * \WindowMoveBy<?>     Moves window by relative values. *Note2*
 * \WindowReset         Resets window position to original position.
 *
 * Note2: Replace '?' with the following format:
 *   targetX, targetY, targetWidth, targetHeight, duration, easingType
 *   Only targetX and targetY are required arguments. These will only alter the
 *   window dimensions when the text has arrived at that point. They will not
 *   alter the window preemptively. This is not used as a window positioner.
 *   Use the <Position: x, y, width, height> text code for that.
 *
 * ---
 *
 * ------------------   -------------------------------------------------------
 * Text Code            Effect (Message Window Only)
 * ------------------   -------------------------------------------------------
 * \ActorFace[x]        Inserts actor x's face into the Message Window.
 * \PartyFace[x]        Inserts party member x's face into the Message Window.
 * \ChangeFace<x,y>     Changes message face to x filename, y index.
 * \FaceIndex[x]        Changes message face index to x.
 *
 * \TextDelay[x]        Sets delay in frames between characters to x frames.
 * 
 * ---
 * 
 * As these text codes can be added, removed, and/or altered, their functions
 * may or may not be the same depending on how you've altered them. VisuStella
 * is not responsible for any errors caused by changes made to pre-made text
 * codes nor any new text codes they did not make.
 * 
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Message Plugin Commands ===
 * 
 * ---
 *
 * Message: Properties
 *   Change the various properties of the Message Window.
 *
 *   Rows:
 *   - Change the number of Message Window rows.
 *   - Leave at 0 to keep it unchanged.
 *
 *   Width: 
 *   - Change the Message Window width in pixels.
 *   - Leave at 0 to keep it unchanged.
 *
 *   Word Wrap:
 *   - Enable or disable Word Wrap for the Message Window?
 *
 * ---
 * 
 * Message: X/Y Offsets
 * - Change the X and Y Offsets of the Message Window.
 * - The offset value(s) will be saved and stored.
 * 
 *   Offset X:
 *   - Offset Message Window horizontally.
 *   - Negative: Left; Positive: Right
 *   - Message Window coordinates are still restricted via clamping.
 * 
 *   Offset Y:
 *   - Offset Message Window vertically.
 *   - Negative: Up; Positive: Down
 *   - Message Window coordinates are still restricted via clamping.
 * 
 * ---
 * 
 * === Choice Plugin Commands ===
 * 
 * ---
 * 
 * Choices: Distance
 * - Change the distance from choice window to the message window.
 * 
 *   Distance:
 *   - Change distance between the choice and message windows.
 *   - Default distance is 0.
 *   - Use negative to center align with remaining space.
 * 
 * ---
 *
 * Choices: Properties
 * - Change the properties found in the Show Choices event command.
 *
 *   Line Height:
 *   - Change the line height for the show choices.
 *   - Leave at 0 to keep this unchanged.
 * 
 *   Minimum Choice Width:
 *   - What is the minimum width size for each choice?
 *   - 96 is the default width.
 *
 *   Max Rows:
 *   - Maximum number of choice rows to be displayed.
 *   - Leave at 0 to keep this unchanged.
 *
 *   Max Columns:
 *   - Maximum number of choice columns to be displayed.
 *   - Leave at 0 to keep this unchanged.
 *
 *   Text Alignment:
 *   - Text alignment for Show Choice window.
 *
 * ---
 * 
 * === Select Plugin Commands ===
 * 
 * ---
 * 
 * Select: Weapon
 * - Opens the Event Select Item Window to let the player pick a weapon to
 *   choose from.
 * - Can be opened while the Message Window is open.
 * 
 *   Variable ID:
 *   - This variable will be used to record the ID of the selected weapon.
 *   - It will result in 0 otherwise.
 * 
 *   Weapon Type ID:
 *   - Reduce all the weapons to a specific weapon type.
 *   - Leave at 0 to not use filters.
 * 
 * ---
 * 
 * Select: Armor
 * - Opens the Event Select Item Window to let the player pick an armor to
 *   choose from.
 * - Can be opened while the Message Window is open.
 * 
 *   Variable ID:
 *   - This variable will be used to record the ID of the selected armor.
 *   - It will result in 0 otherwise.
 * 
 *   Armor Type ID:
 *   - Reduce all the armors to a specific armor type.
 *   - Leave at 0 to not use filters.
 * 
 *   Equip Type ID:
 *   - Reduce all the armors to a specific equip type.
 *   - Leave at 0 to not use filters.
 * 
 * ---
 * 
 * Select: Skill
 * - Opens the Event Select Item Window to let the player pick a skill to
 *   choose from.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * - Can be opened while the Message Window is open.
 * - Skills will not be listed if they are hidden by the actor.
 * - Skills will not be listed if the actor lacks access to their Skill Type.
 * 
 *   Variable ID:
 *   - This variable will be used to record the ID of the selected skill.
 *   - It will result in 0 otherwise.
 * 
 *   Actor ID:
 *   - Select an actor to get the skill list from.
 *   - Use 0 to select from the party leader.
 * 
 *   Skill Type ID:
 *   - Reduce all the skills to a specific skill type.
 *   - Leave at 0 to not use filters.
 * 
 * ---
 * 
 * === Picture Plugin Commands ===
 * 
 * ---
 * 
 * Picture: Change Text
 * - Change text for target picture(s) to show.
 * - You may use text codes.
 * - Text will adapt to picture's properties.
 * - Settings will be erased if picture is erased.
 * 
 *   Picture ID(s):
 *   - The ID(s) of the picture(s) to set text to.
 * 
 *   Padding:
 *   - How much padding from the sides should there be?
 * 
 *   Text:
 * 
 *     Upper Left:
 *     Upper Center:
 *     Upper Right:
 *     Middle Left:
 *     Middle Center:
 *     Middle Right:
 *     Lower Left:
 *     Lower Center:
 *     Lower Right:
 *     - The text that's aligned to this picture's side.
 *     - You may use text codes.
 * 
 * ---
 * 
 * Picture: Erase Text
 * - Erase all text for target picture(s).
 * 
 *   Picture ID(s):
 *   - The ID(s) of the picture(s) to erase text for.
 * 
 * ---
 * 
 * Picture: Refresh Text
 * - Refreshes the text used for all on-screen pictures.
 * - To be used if any dynamic text codes are updated like \n[x].
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: General Settings
 * ============================================================================
 *
 * General settings involving the message system. These settings range from
 * adjust how the Message Window looks to more intricate settings like how
 * some of the default text codes work.
 *
 * ---
 *
 * Message Window
 *
 *   Default Rows:
 *   - Default number of rows to display for the Message Window.
 *
 *   Default Width:
 *   - Default Message Window width in pixels.
 *
 *   Fast Forward Key:
 *   - This is the key used for fast forwarding messages.
 *   - WARNING: If this key is the same as the dash button, this will clear out
 *     any held down inputs upon triggering an event  to prevent players from
 *     skipping potentially useful information stored in messages. If you do
 *     not want the input to be cleared, use a different key.
 *
 *   Text Delay:
 *   - How many frames to wait between characters drawn?
 *   - Use 0 for instant.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Offset Message Window horizontally or vertically.
 *   - Horizontal: Left; Positive: Right
 *   - Veritcal: Negative: Up; Positive: Down
 * 
 *   Stretch Dimmed BG:
 *   - Stretch dimmed window background to fit the whole screen.
 * 
 *   Default Outline Width:
 *   - Changes the default outline width to this many pixels thick.
 * 
 *   Each Message Start:
 *   Each Message End:
 *   - This is text that is added at the start/end of each message.
 *   - You may use text codes.
 *   - Keep in mind that if a message extends to a different page (due to word
 *     wrap, excess lines, etc), that does not mean the starting text will
 *     be added to where the next page begins or the ending text will be added
 *     where the previous page ends.
 *   - Can be used for things like adding "<center>" to the start of each 
 *     message without having to type it every time.
 *
 * ---
 *
 * Name Box Window
 *
 *   Default Color:
 *   - Default color for the Name Box Window's text.
 *
 *   Offset X:
 *   - How much to offset the name box window X by
 *     (as long as it doesn't go offscreen).
 *
 *   Offset Y:
 *   - How much to offset the name box window Y by
 *     (as long as it doesn't go offscreen).
 *
 * ---
 *
 * Choice List Window
 *
 *   Line Height:
 *   - What is the default line height for Show Choices?
 * 
 *   Minimum Choice Width:
 *   - What is the minimum choice width for each choice?
 *   - 96 is the default width.
 *
 *   Max Rows:
 *   - Maximum number of rows to visibly display?
 *
 *   Max Columns:
 *   - Maximum number of columns to visibly display?
 *
 *   Text Alignment:
 *   - Default alignment for Show Choice window.
 *
 * ---
 *
 * Default Text Codes
 *
 *   Relative \PX \PY:
 *   - Make \PX[x] and \PY[x] adjust relative starting position than
 *     exact coordinates.
 *
 *   \{ Maximum:
 *   - Determine the maximum size that \{ can reach.
 *
 *   \} Minimum:
 *   - Determine the minimum size that \} can reach.
 *
 *   \{ Change \}
 *   - How much does \{ and \} change font size by?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto-Color Settings
 * ============================================================================
 *
 * For certain windows such as the Message Window, Help Window, and Choice
 * Window, Auto-Color is enabled to automatically highlight and color certain
 * database entries, keywords, and just about anything you, the game dev, wants
 * to be automatically colored. This is done to avoid typing out \C[6]Jack\C[0]
 * every time Jack's name is written out as it will be automatically colored in
 * those specific windows.
 *
 * The Plugin Parameters will give you full reign over which database entries
 * and keywords you want to be automatically colored as long as they follow a
 * few rules:
 * 
 * -----------------
 * Auto-Color Rules:
 * -----------------
 *
 * 1. Database names and keywords are case sensitive.
 *    This means if "Potion" is a marked keyword, typing out "potion" will not
 *    prompt the auto-color to highlight "potion". You must add the lowercase
 *    version of the word into the keyword list if you want it to count.
 *
 * 2. Database names and keywords are exact size (for Roman languages)
 *    This means if "Potion" is a marked keyword, typing out "potions" will not
 *    prompt the auto-color to highlight "potions". You must type out all of
 *    the variations of the words you want affected into the keyword list to
 *    prompt the auto-color highlight.
 * 
 *    This does not apply to Japanese, Korean, or Chinese languages.
 *
 * 3. Possessive cases and other language symbols aren't counted.
 *    Symbols such as periods, commas, quotes, parentheses, and similar symbols
 *    do no count towards Rule 2. This means if "Potion" is a marked keyword,
 *    the typing out "(Potion)" will still highlight the "Potion" part of the
 *    word according to the auto-color.
 * 
 * 4. Names with special characters like !, ?, [, ], etc. will be ignored.
 *    These cause conflicts with how auto-colors are detected.
 *
 * ---
 *
 * Database Highlighting
 *
 *   Actors:
 *   Classes:
 *   Skills:
 *   Items:
 *   Weapons:
 *   Armors:
 *   Enemies:
 *   States:
 *   - Any usage of a the selected database entry's name is auto-colored with
 *     the text code number.
 *   - Use 0 to not auto-color.
 *
 * ---
 *
 * Word Highlighting
 *
 *   \C[x]: Color
 *   - These are lists of all the words that will be automatically colored with
 *     the x text color.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Custom Font Manager
 * ============================================================================
 *
 * Custom fonts that aren't the message or number fonts cannot be used without
 * registration. If you try to use custom fonts in RPG Maker MZ without
 * registering their font family first, you will find out that they will not
 * work. These plugin parameters allow you to register your game's custom fonts
 * here.
 * 
 * ---
 * 
 * Settings:
 * 
 *   Font Family:
 *   - This will be what's used by RPG Maker MZ and plugins to reference this
 *     specific font.
 *   - NO filename extensions!
 * 
 *   Filename:
 *   - What is the filename of the custom font you would like to use?
 *   - Located inside the project's "fonts" folder.
 * 
 * ---
 * 
 * Examples:
 * 
 *   Font Family: WildWords
 *   Filename: WildWords-Regular.ttf
 * 
 * How you would use this in other plugins as a preface to the font face or
 * font family would be to use "WildWords" as the font face/family name. Then
 * RPG Maker MZ will use its own innate FontManager to refer that to the
 * "WildWords-Regular.ttf" file found in the game's "fonts" folder.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Text Code Actions
 * ============================================================================
 *
 * Text codes are used for one of two things: performing actions or replacing
 * themselves with text data. This Plugin Parameter will focus on the aspect of
 * performing actions. These actions can be done through each JavaScript or by
 * a common event (if it is used in the Message Window). Adequate knowledge of
 * both is recommended before attempting to modify and/or add new Text Code
 * Actions to the Plugin Parameters.
 *
 * Each of the Text Code Actions are formatted in such a way:
 *
 * ---
 *
 * Text Code Action
 *
 *   Match:
 *   - This is what needs to be matched in order for this text code to work.
 *   - This is the primary text marker after the \ in a text code.
 *   - In \N[x], this would be the 'N'.
 *
 *   Type:
 *   - The type of parameter to obtain (none, number, or string).
 *   - This is the way the text code determines the condition type.
 *   - In \N[x], this would be the '[x]'.
 *
 *   Common Event:
 *   - Select a common event to run when this text code is used in a message.
 *
 *   JS: Action:
 *   - JavaScript code used to perform an action when this text code appears.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Text Code Replacements
 * ============================================================================
 *
 * Text codes are used for one of two things: performing actions or replacing
 * themselves with text data. This Plugin Parameter will focus on the aspect of
 * replacing the text codes with text data. Text data can be replaced with
 * an exact exchange of text or dynamically through JavaScript. Adding a new
 * Text Code Replacement is done through the Plugin Parameters.
 *
 * Each of the Text Code Replacements are formatted in such a way:
 *
 * ---
 *
 * Text Code Replacement
 *
 *   Match:
 *   - This is what needs to be matched in order for this text code to work.
 *   - This is the primary text marker after the \ in a text code.
 *   - In \N[x], this would be the 'N'.
 *
 *   Type:
 *   - The type of parameter to obtain (none, number, or string).
 *   - This is the way the text code determines the condition type.
 *   - In \N[x], this would be the '[x]'.
 *
 *   STR: Text:
 *   - The text that will appear if this match appears.
 *     If this has a value, ignore the JS: Text version.
 *
 *   JS: Text:
 *   - JavaScript code used to determine the text that will appear if this
 *     match appears.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Text Macros
 * ============================================================================
 *
 * Text macros are used in similar fashion to text codes replacements to
 * replace themselves with text data. The primary difference is that macros are
 * made in a different format with no conditional argument modifiers (ie the
 * [x] that follows a text code).
 *
 * To use a text macro, type in the matching keyword between two [brackets] and
 * it will be replaced by the string data or run the JavaScript code found in
 * the Plugin Parameter settings.
 *
 * For example, if you have the text macro "Leader", made to return the party
 * leader's name, you can type in [Leader] in the Message Window and it will be
 * replaced with the party leader's name. The output can also output text codes
 * into the resulting text.
 * 
 * This does NOT work with \MacroName as it did with Yanfly Engine Plugins.
 * Use the method stated before with the brackets to [MacroName] instead.
 *
 * Each of the Text Macros are formatted in such a way:
 *
 * ---
 *
 * Text Macro
 *
 *   Match:
 *   - This is what needs to be matched in order for this macro to work.
 *   - In [Leader], this would be the 'Leader' text.
 *
 *   STR: Text:
 *   - The replacement text that will appear from the macro.
 *   - If this has a value, ignore the JS: Text version.
 *
 *   JS: Text:
 *   - JavaScript code used to determine the text that will appear if this
 *     macro appears.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Text Language Settings
 * ============================================================================
 *
 * The "Text Language" feature allows your players to switch between different
 * languages for your game to allow people from around the globe to enjoy what
 * story you have to tell.
 * 
 * Disclaimers: This is not an automatic translation tool. Translations made
 * through the "Text Language" feature of the VisuStella MZ Message Core
 * will require manual input by the game developer.
 * 
 * See the "Text Language Information" for more information.
 *
 * ---
 * 
 * Main Settings:
 * 
 *   Enable Switching?:
 *   - Enable language switching settings for this plugin?
 * 
 *   CSV Filename:
 *   - What is the filename of the CSV file to read from?
 *   - Located within the project's /data/ folder.
 * 
 * ---
 * 
 * Options:
 * 
 *   Add Option?:
 *   - Add the 'Text Language' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 * 
 * ---
 * 
 * Languages:
 * 
 *   Default Language:
 *   - What is the default language used for this game?
 * 
 *   Supported Languages:
 *   - What are all the supported languages supported by this game's
 *     script?
 *   - Remove any that aren't translated.
 * 
 * ---
 * 
 * Language Names:
 * 
 *   Bengali:
 *   Chinese (Simplified):
 *   Chinese (Traditional):
 *   Czech:
 *   Danish:
 *   Dutch:
 *   English:
 *   Finnish:
 *   French:
 *   German:
 *   Greek:
 *   Hindi:
 *   Hungarian:
 *   Indonesian:
 *   Italian:
 *   Japanese:
 *   Korean:
 *   Norwegian:
 *   Polish:
 *   Portuguese:
 *   Romanian:
 *   Russian:
 *   Slovak:
 *   Spanish:
 *   Swedish:
 *   Tamil:
 *   Thai:
 *   Turkish:
 *   - How does this language appear in the in-game options?
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Text Speed Option Settings
 * ============================================================================
 *
 * Modern RPG's on the market have the option to adjust the message speed rate
 * for players. These Plugin Parameters allow you to add that option to the
 * Options Menu as well.
 *
 * ---
 *
 * Text Speed Option Settings
 *
 *   Add Option?:
 *   - Add the 'Text Speed' option to the Options menu?
 *
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 *
 *   Option Name:
 *   - Command name of the option.
 *
 *   Default Value:
 *   - 1 - 10, slowest to fastest.
 *   - 11 is instant value.
 *
 *   Instant Speed:
 *   - Text to show "instant" text.
 *
 * ---
 * 
 * ============================================================================
 * Plugin Parameters: Word Wrap Settings
 * ============================================================================
 *
 * Word wrap is a property that will cause any overflowing text to wrap around
 * and move into the next line. This property can only be enabled inside text
 * that accept text codes, such as the Message Window and Help Window. However,
 * word wrap is disabled for the Choice Window due to the nature of the Choice
 * Window's base properties.
 *
 * Word wrap can be enabled or disabled in three ways. One is by using the text
 * code <WordWrap> to enable it or </WordWrap> to disable it. The second method
 * is by enabling it with the Plugin Command: 'Message: Properties'. The third
 * method is by enabling it by default with the Plugin Parameters.
 * 
 * Word wrap only supports left-to-right alphabetical languages that utilize
 * spaces.
 * 
 * Word Wrap also cannot be used together with <left>, <center>, or <right> and
 * will disable itself if text alignment text codes are detected.
 * 
 * As of the v1.44 update, some Asian languages such as Chinese and Japanese
 * are now supported for word wrap. Korean language is only supported if spaces
 * are used.
 * 
 * ---
 *
 * Enable Word Wrap
 *
 *   Message Window:
 *   - Automatically enable Word Wrap for this window?
 *
 *   Help Window:
 *   - Automatically enable Word Wrap for this window?
 *
 * ---
 *
 * Rules
 *
 *   Link Break -> Space:
 *   - Convert manually placed (non tagged) line breaks with spaces?
 *   - Line breaks must be inserted using the <br> text code.
 *
 *   Tight Wrap:
 *   - If a face graphic is present in a message, word wrap will be tighter.
 * 
 *   End Padding:
 *   - Add extra padding to your window to make text wrap further away from the
 *     end of the window.
 *   - This will default to 0.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.48: April 18, 2024
 * * Bug Fixes!
 * ** Added fail safe for help description checks parsing from objects without
 *    help descriptions normally. Fix made by Irina.
 * 
 * Version 1.47: February 15, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Custom Font Manager
 * **** Register custom fonts here.
 * **** Custom fonts that aren't the message or number fonts cannot be used
 *      without registration.
 * **** See help file for more information.
 * 
 * Version 1.46: January 18, 2024
 * * Bug Fixes!
 * ** Fixed a bug where script calls used to create message choices would not
 *    work properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** Text Language Switching added by Irina:
 * *** Plugin Parameters > Text Language Settings
 * **** The "Text Language" feature allows your players to switch between
 *      different languages for your game to allow people from around the globe
 *      to enjoy what story you have to tell.
 * **** Disclaimers: This is not an automatic translation tool. Translations
 *      made through the "Text Language" feature of the VisuStella MZ Message
 *      Core will require manual input by the game developer.
 * **** Read more about it in detail within the "Text Language Information"
 *      section in the help file.
 * ** New Plugin Parameter added by Irina:
 * *** Choices: Distance
 * **** Change the distance from choice window to the message window.
 * ** New parameter added to Plugin Command "Choices: Properties" by Irina:
 * *** Minimum Choice Width
 * **** What is the minimum width size for each choice?
 * ** New Plugin Parameter for "Message Window" added by Irina:
 * *** Parameters > Message Window: Choice List Window> Minimum Choice Width
 * **** What is the minimum width size for each choice?
 * ** New Text Codes for Choice Window added by Irina:
 * *** <BgImg: filename> and variants
 * *** <FgImg: filename> and variants
 * **** These text codes allow adding a background or foreground image to a
 *      choice rectangle in stretched/scaled size.
 * 
 * Version 1.45: December 14, 2023
 * * Bug Fixes!
 * ** Punctuation was, for some reason, excluded when using Wordwrap with
 *    Japanese and Chinese languages. This should be fixed now. Fixed by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added clarity to the <left>, <center>, and <right> being unable to be
 *    used together with word wrap.
 * *** Word Wrap also cannot be used together with <left>, <center>, or <right>
 *     and will disable itself if text alignment text codes are detected.
 * * Feature Update!
 * ** Wordwrap <br> now works properly with Japanese and Chinese languages.
 * * New Features!
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > General Settings > Each Message Start
 * *** Plugin Parameters > General Settings > Each Message End
 * **** This is text that is added at the start/end of each message.
 * **** Keep in mind that if a message extends to a different page (due to word
 *      wrap, excess lines, etc), that does not mean the starting text will
 *      be added to where the next page begins or the ending text will be added
 *      where the previous page ends.
 * **** Can be used for things like adding "<center>" to the start of each 
 *      message without having to type it every time.
 * 
 * Version 1.44: October 12, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Updated "Plugin Parameters: Word Wrap Settings" section:
 * *** As of the v1.44 update, some Asian languages such as Chinese and
 *     Japanese are now supported for word wrap. Korean language is only
 *     supported if spaces are used.
 * * Feature Update!
 * ** Word Wrap is now supported for Japanese and Chinese languages.
 * ** Feature updated by Irina and sponsored by AndyL.
 * * New Features!
 * ** New text codes added by Irina for "Show Choices" event command.
 * *** <Shuffle>
 * **** Shuffles the order of all choices. Any cancel shortcuts other than
 *      "Branch" will be undone.
 * *** <Shuffle: x>
 * **** Shuffles the order of all choices and only x number of them appear. Any
 *      cancel shortcuts other than "Branch" will be undone. Hidden choices do
 *      not count towards x number.
 * 
 * Version 1.43: April 13, 2023
 * * Compatibility Update!
 * ** Fixed incompatibilities with auto message positioning with the Map Zoom
 *    plugin. Update made by Irina.
 * 
 * Version 1.42: March 16, 2023
 * * Bug Fixes!
 * ** Fixed some text codes that would capture way too much data than intended.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New text code added by Irina for Show Choice Window only:
 * *** <Help> text </Help>
 * **** Makes a help window appear and have it show 'text' in its contents.
 * **** The help window will disappear if no text is displayed.
 * ** New Plugin Commands added by Arisu:
 * *** Select: Weapon
 * *** Select: Armor
 * *** Select: Skill
 * **** Opens the Event Select Item Window to let the player pick a weapon,
 *      armor, or skill to choose from. The selected object will have its ID
 *      recorded in a variable. These can be opened while the Message Window is
 *      opened just like the event "Select Item".
 * 
 * Version 1.41: December 15, 2022
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New text codes added by Irina!
 * *** For the Choice Window Only text codes:
 * **** <BgColor: x>
 * **** <BgColor: x, y>
 * **** <BgColor: #rrggbb>
 * **** <BgColor: #rrggbb, #rrggbb>
 * ***** Requires VisuMZ_0_CoreEngine! Sets the background color of this choice
 *       to 'x' text color, 'x' to 'y' gradient text color, or using '#rrggbb'
 *       hex color values.
 * 
 * Version 1.40: November 3, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New text code added by Irina:
 * *** <RNG> text1 | text2 | text3 </RNG>
 * **** Using the above text code format in a Show Message entry, you can get a
 *      random result out of the various inserted texts. Use "|" (without
 *      quotes) as a separator between text entries. You can have unlimited
 *      entries. The result will have any excess white space trimmed.
 * **** This text code cannot be inserted into a macro and parsed properly.
 * 
 * Version 1.39: September 22, 2022
 * * Bug Fixes!
 * ** Macros now support quotes (' and ") in the STR: Text. Fix made by Irina.
 * 
 * Version 1.38: July 21, 2022
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.37: June 9, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Picture texts with \v[x] text codes are now updated automatically.
 * ** This is the only dynamic text code that updates this way for optimization
 *    purposes and to prevent overabundant CPU usage.
 * ** Everything else will require the new Plugin Command.
 * * New Features!
 * ** New Plugin Command added by Irina:
 * *** Picture: Refresh Text
 * **** Refreshes the text used for all on-screen pictures.
 * **** To be used if any dynamic text codes are updated like \n[x].
 * * New Features!
 * ** New text codes added by Arisu and sponsored by
 *    ImGonnaPutMyGameOnXboxAndYouCantStopMe:
 * *** <Up Button>, <Left Button>, <Right Button>, <Down Button>
 * *** <Ok Button>, <Cancel Button>, <Shift Button>, <Menu Button>
 * *** <Page Up Button>, <Page Down Button>
 * **** Display's VisuMZ_0_CoreEngine's button assist text.
 * 
 * Version 1.36: April 7, 2022
 * * Feature Update!
 * ** Auto size related text codes should now automatically disable word wrap
 *    effects as they should have before. Update made by Irina.
 * 
 * Version 1.35: March 31, 2022
 * * Bug Fixes!
 * ** Bug fixed where if autosizing is used and it goes from a message that is
 *    shorter to longer, an extra key press is needed. This should no longer be
 *    the case. Fix made by Irina.
 * 
 * Version 1.34: February 24, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Choice Window Text Codes made by Irina and sponsored by AndyL:
 * *** <Choice Width: x>
 * **** Sets the minimum text area width to x. Applies to whole choice window.
 * *** <Choice Indent: x>
 * **** Sets the indent to x value. Applies to current choice selection only.
 * 
 * Version 1.33: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Irina:
 * *** Picture: Change Text
 * **** This new plugin command allows you to place text on top of pictures
 *      (usually in the form of empty pages or cards) to function as stationary
 *      or other uses. Text codes are allowed.
 * **** Text codes are supported.
 * *** Picture: Erase Text
 * **** Removes text from target picture(s).
 * 
 * Version 1.32: January 20, 2022
 * * Bug Fixes!
 * ** Extra Show Choice notetags will now be properly hidden. Fix by Irina.
 * * Compatibility Update!
 * ** Self Switches are now made compatible with work with Show Choices. Update
 *    made by Irina.
 * 
 * Version 1.31: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New hard-coded message-only text code added by Irina:
 * *** <Next Page>
 * **** Ends the current message page at this line. This is used for messages
 *      when rows are at 5 or above and the message lines don't match the
 *      amount. This is used to prevent grabbing message windows from following
 *      message events. Any lines following <Next Page> in the same message
 *      event will be ignored.
 * 
 * Version 1.30: November 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for removed "Center Window X" bit.
 * * Feature Update!
 * ** Message: Properties now has "Center Window X?" removed
 * *** Changes will now be automatically centered.
 * *** This change is made for the new Plugin Command added for offsets which
 *     more or less replaces them.
 * * New Features!
 * ** New Plugin Command added by Irina and sponsored by Puddor:
 * *** Message: X/Y Offsets
 * **** Change the X and Y Offsets of the Message Window.
 * **** The offset value(s) will be saved and stored.
 * ** New Plugin Parameters added by Irina and sponsored by Puddor:
 * *** Plugin Parameters > General Settings > Message Window > Offset X
 * *** Plugin Parameters > General Settings > Message Window > Offset Y
 * **** Allows you to offset the horizontal and/or vertical positions of the
 *      message window accordingly.
 * ** New Text Codes added by Irina and sponsored by Puddor:
 * *** <Offset: +x, +y>
 * *** <Offset: -x, -y>
 * *** <Offset: +x, -y>
 * *** <Offset: -x, +y>
 * **** Quickly adjust the message window offset values to the x and y amounts.
 *      The values will replace the previous offset settings if there were any.
 * 
 * Version 1.29: October 21, 2021
 * * Feature Update
 * ** Word Wrap flags are now properly adjusted when converting macros and
 *    adding bypasses towards regular messages. Update by Irina.
 * 
 * Version 1.28: October 14, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.27: October 7, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.26: September 3, 2021
 * * Bug Fixes!
 * ** Macros should now work properly with any \x<n> based text codes.
 *    Fix made by Irina.
 * 
 * Version 1.25: August 27, 2021
 * * Feature Update!
 * ** Macros should now work with the <WordWrap> text code. Update by Irina.
 * 
 * Version 1.24: August 20, 2021
 * * Feature Update!
 * ** Macros should now work with window placement and resize options.
 *    Update made by Irina.
 * ** Macros should now work with choice-related enable and visibility options.
 *    Update made by Irina.
 * 
 * Version 1.23: July 16, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Irina:
 * *** Plugin Parameters > Word Wrap Settings > End Padding
 * **** Add extra padding to your window to make text wrap further away from
 *      the end of the window. This will default to 0.
 * 
 * Version 1.22: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Text Codes added by Irina and sponsored by AndyL:
 * *** <Current Battle Target>
 * *** <Current Battle User>
 * **** Replaces the text code with the current target or current user's name
 *      in-battle. Otherwise, returns nothing.
 * **** Not recommended to be used inside of Help Descriptions. They are best
 *      used with "Show Text" event commands.
 * *** <Current Battle Action>
 * *** <Current Battle Action Name>
 * **** Replaces the text code with the current battle action's name with the
 *      icon or without it respectively. Otherwise, returns nothing.
 * **** Not recommended to be used inside of Help Descriptions. They are best
 *      used with "Show Text" event commands.
 * 
 * Version 1.21: June 4, 2021
 * * Documentation Update!
 * ** Added extra note to the new <Position: x, y, width, height> text codes
 *    that they do not work with Word Wrap.
 * * Feature Update!
 * ** Added fail safe for preventing Common Events that don't exist from being
 *    ran at all by the Message Window. Added by Arisu.
 * 
 * Version 1.20: May 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added additional clarity for \WindowMoveTo<?> and \WindowMoveBy<?> and
 *    \WindowReset text codes with "Note 2".
 * *** Replace '?' with the following format: targetX, targetY, targetWidth,
 *     targetHeight, duration, easingType. Only targetX and targetY are
 *     required arguments. These will only alter the window dimensions when the
 *     text has arrived at that point. They will not alter the window
 *     preemptively. This is not used as a window positioner. Use the
 *     <Position: x, y, width, height> text code for that.
 * * New Features!
 * ** New hard-coded text codes added for Message Window Only. Added by Irina.
 * *** <Position: x, y, width, height>
 * *** <Coordinates: x, y>
 * *** <Dimensions: width, height>
 * 
 * Version 1.19: May 14, 2021
 * * Feature Updates!
 * ** <br> line breaks can now be used by Show Choices. Make sure that there is
 *    enough room to contain the text through Plugin Commands. Update by Irina.
 * 
 * Version 1.18: April 30, 2021
 * * Bug Fixes!
 * ** Moving windows with 0 duration via text code should now instantly move
 *    the windows to the desired location with no delay. Fix made by Olivia.
 * 
 * Version 1.17: April 9, 2021
 * * Feature Update!
 * ** <Auto> text codes for message windows will round up calculations for the
 *    message width to the nearest even number for better calculations.
 * 
 * Version 1.16: April 2, 2021
 * * Bug Fixes!
 * ** \CommonEvent[x] text code will no longer run upon message window size
 *    calculation. Fix made by Arisu.
 * * Documentation Update!
 * ** Added further clarification for "Text Macros" section.
 * *** This does NOT work with \MacroName as it did with Yanfly Engine Plugins.
 *     Use the method stated before with the brackets to [MacroName] instead.
 * 
 * Version 1.15: March 5, 2021
 * * Bug Fixes!
 * ** Hidden choices by switches will no longer count towards the maximum line
 *    count for Show Choice options. Fix made by Irina.
 * 
 * Version 1.14: February 12, 2021
 * * Bug Fixes!
 * ** Auto positioned messages in battle will no longer cover the battler in
 *    question. Fix made by Irina.
 * 
 * Version 1.13: February 5, 2021
 * * Bug Fixes!
 * ** Choice List Window with a dimmed background should now have a more
 *    consistent sized dim sprite. Fix made by Irina.
 * 
 * Version 1.12: January 22, 2021
 * * Feature Update!
 * ** Name Box Window Default Color is now disabled by default to 0 because
 *    users do not understand why their names are showing up yellow and did not
 *    bother reading the documentation. If users want this feature turned on,
 *    they will have to do it manually from now on. Update made by Irina.
 * 
 * Version 1.11: January 15, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.10: January 8, 2021
 * * Bug Fixes!
 * ** <Auto Actor: x> and <Auto Party: x> text codes should now work properly.
 *    Fix made by Irina.
 * * Feature Update!
 * ** Auto Color Plugin Parameters now have their default settings set to 0.
 *    This is due to an influx of "bug reports" from users who do not
 *    understand how this feature works, and the VisuStella team has decided it
 *    is better for the feature to default to an inactive state until users
 *    decide to search and utilize it themselves. Update made by Irina.
 * 
 * Version 1.09: January 1, 2021
 * * Feature Update!
 * ** Auto-color no longer applies to database names that are only numbers.
 *    Auto-color entries that are only numbers will also be ignored. This is to
 *    prevent breaking the text code parsing. Update made by Yanfly.
 * 
 * Version 1.08: November 15, 2020
 * * Documentation Update!
 * ** Some text codes left for the Name Box Window have been accidentally left
 *    out. These text codes allow for the positioning of the Name Box Window.
 *    Also, added to this section are the \NormalBG, \DimBG, and \TransparentBG
 *    text codes since people have been asking for how to change the name box
 *    window's background, but have skimmed over those text codes in different
 *    sections of the help file.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.07: November 8, 2020
 * * Bug Fixes!
 * ** When using auto size functions, the message pause symbol will no longer
 *    appear semi-transparent the whole time. Fix made by Irina.
 * 
 * Version 1.06: October 25, 2020
 * * Documentation Update!
 * ** Added a warning message to the Fast Forward Key plugin parameter:
 * *** WARNING: If this key is the same as the dash button, this will clear out
 *     any held down inputs upon triggering an event  to prevent players from
 *     skipping potentially useful information stored in messages. If you do
 *     not want the input to be cleared, use a different key.
 * ** Updated help file for new features.
 * * Feature Update!
 * ** The default Fast Forward Key setting has now been changed from "Shift" to
 *    "Page Down". Change made by Yanfly
 * * New Feature!
 * ** New Plugin Parameter added by Irina.
 * *** Plugin Parameters > General > Default Outline Width
 * **** Changes the default outline width to this many pixels thick.
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Setting an actor's autocolor will now disable it from \N[x] and \P[x]
 *    text codes. Fix made by Irina.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Auto Position text codes not place positions properly if the screen width
 *    and height differ from the box width and box height. Fix made by Irina.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Word wrap no longer affects specific battle messages. Fix made by Irina.
 * ** Word wrap now updates properly after using the 'Message: Properties'
 *    Plugin Command. Fix made by Arisu.
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Autoplacement of the name box window now takes its offset Y setting into
 *    account before sending it to the bottom of the message window. Fix made
 *    by Yanfly.
 * ** Added automatic feature setting to turn off word wrap when using the
 *    auto-size and auto-position text codes. This is because the auto-size and
 *    auto-position effects don't work properly with Word Wrap based on how
 *    they both clash when adjusting the window settings. Fix made by Irina.
 * ** New message pages after auto-sizing no longer put out empty messages.
 *    Fix made by Irina and Shiro.
 * * Documentation Update!
 * ** Extended the note for auto-size and auto-position text codes to include
 *    that they do not work with Word Wrap. Added by Irina.
 * 
 * Version 1.02: August 30, 2020
 * * New Features!
 * ** Added new hard-coded text codes for auto-sizing and auto-positioning:
 * *** <Auto>, <Auto Width>, <Auto Height>
 * *** <Auto Actor: x>, <Auto Party: x>, <Auto Enemy: x>
 * *** <Auto Player>, <Auto Actor: x>, <Auto Party: x>, <Auto Event: x>
 * **** New features added by Irina.
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** </Wordwrap> now works.
 * ** \ActorFace[x] text code now fixed.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Text Code Replacements > ActorFace >
 *     JS: Text > and changing "$gameActors.actor(1)" to
 *     "$gameActors.actor(actorId)"
 * ** Actors with empty names would cause auto hightlight problems. Fixed!
 * ** Auto-colors now ignore names with special characters like !, ?, [, ], and
 *    so on.
 * ** Line break spacing fixed.
 * * New Features!
 * ** Wordwrap now works with <left>, <center> and <right> alignment tags.
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MessageWindowProperties
 * @text Message: Properties
 * @desc Change the various properties of the Message Window.
 *
 * @arg Rows:num
 * @text Rows
 * @type number
 * @min 0
 * @desc Change the number of Message Window rows.
 * Leave at 0 to keep it unchanged.
 * @default 4
 *
 * @arg Width:num
 * @text Width
 * @type number
 * @min 0
 * @desc Change the Message Window width in pixels.
 * Leave at 0 to keep it unchanged.
 * @default 816
 *
 * @arg WordWrap:str
 * @text Word Wrap
 * @type select
 * @option No Change
 * @value No Change
 * @option Enable
 * @value true
 * @option Disable
 * @value false
 * @desc Enable or disable Word Wrap for the Message Window?
 * @default No Change
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MessageWindowXyOffsets
 * @text Message: X/Y Offsets
 * @desc Change the X and Y Offsets of the Message Window.
 * The offset value(s) will be saved and stored.
 *
 * @arg OffsetX:eval
 * @text Offset X
 * @desc Offset Message Window horizontally.
 * Negative: Left; Positive: Right
 * @default +0
 *
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc Offset Message Window vertically.
 * Negative: Up; Positive: Down
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Choice
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ChoiceWindowDistance
 * @text Choices: Distance
 * @desc Change the distance from choice window to the message window.
 *
 * @arg Distance:eval
 * @text Distance
 * @desc Change distance between the choice and message windows.
 * Default distance is 0. Use negative to center align.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ChoiceWindowProperties
 * @text Choices: Properties
 * @desc Change the properties found in the Show Choices event command.
 *
 * @arg LineHeight:num
 * @text Choice Line Height
 * @type number
 * @min 0
 * @desc Change the line height for the show choices.
 * Leave at 0 to keep this unchanged.
 * @default 36
 *
 * @arg MinWidth:num
 * @text Minimum Choice Width
 * @type number
 * @min 0
 * @desc What is the minimum width size for each choice?
 * 96 is the default width.
 * @default 96
 *
 * @arg MaxRows:num
 * @text Max Rows
 * @type number
 * @min 0
 * @desc Maximum number of choice rows to be displayed.
 * Leave at 0 to keep this unchanged.
 * @default 8
 *
 * @arg MaxCols:num
 * @text Max Columns
 * @type number
 * @min 0
 * @desc Maximum number of choice columns to be displayed.
 * Leave at 0 to keep this unchanged.
 * @default 1
 *
 * @arg TextAlign:str
 * @text Text Alignment
 * @type select
 * @option Default
 * @value default
 * @option Left
 * @value left
 * @option Center
 * @value center
 * @option Right
 * @value right
 * @desc Text alignment for Show Choice window.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Select
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SelectWeapon
 * @text Select: Weapon
 * @desc Opens the Event Select Item Window to let the player
 * pick a weapon to choose from.
 *
 * @arg VariableID:num
 * @text Variable ID
 * @type number
 * @min 0
 * @desc This variable will be used to record the ID of the
 * selected weapon. It will result in 0 otherwise.
 * @default 1
 *
 * @arg WeaponTypeID:num
 * @text Weapon Type ID
 * @type number
 * @min 0
 * @max 100
 * @desc Reduce all the weapons to a specific weapon type.
 * Leave at 0 to not use filters.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SelectArmor
 * @text Select: Armor
 * @desc Opens the Event Select Item Window to let the player
 * pick an armor to choose from.
 *
 * @arg VariableID:num
 * @text Variable ID
 * @type number
 * @min 0
 * @desc This variable will be used to record the ID of the
 * selected armor. It will result in 0 otherwise.
 * @default 1
 *
 * @arg ArmorTypeID:num
 * @text Armor Type ID
 * @type number
 * @min 0
 * @max 100
 * @desc Reduce all the armors to a specific armor type.
 * Leave at 0 to not use filters.
 * @default 0
 *
 * @arg EquipTypeID:num
 * @text Equip Type ID
 * @type number
 * @min 0
 * @max 100
 * @desc Reduce all the armors to a specific equip type.
 * Leave at 0 to not use filters.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SelectSkill
 * @text Select: Skill
 * @desc Opens the Event Select Item Window to let the player
 * pick a skill to choose from. Requires VisuMZ_1_SkillsStatesCore!
 *
 * @arg VariableID:num
 * @text Variable ID
 * @type number
 * @min 0
 * @desc This variable will be used to record the ID of the
 * selected skill. It will result in 0 otherwise.
 * @default 1
 *
 * @arg ActorID:num
 * @text Actor ID
 * @type actor
 * @desc Select an actor to get the skill list from.
 * Use 0 to select from the party leader.
 * @default 0
 *
 * @arg SkillTypeID:num
 * @text Skill Type ID
 * @type number
 * @min 0
 * @max 100
 * @desc Reduce all the skills to a specific skill type.
 * Leave at 0 to not use filters.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Picture
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureTextChange
 * @text Picture: Change Text
 * @desc Change text for target picture(s) to show.
 * You may use text codes.
 *
 * @arg PictureIDs:arraynum
 * @text Picture ID(s)
 * @type number[]
 * @min 1
 * @max 100
 * @desc The ID(s) of the picture(s) to set text to.
 * @default ["1"]
 *
 * @arg Padding:eval
 * @text Padding
 * @parent PictureIDs:arraynum
 * @desc How much padding from the sides should there be?
 * @default $gameSystem.windowPadding()
 * 
 * @arg Text
 *
 * @arg upperleft:json
 * @text Upper Left
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg up:json
 * @text Upper Center
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg upperright:json
 * @text Upper Right
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg left:json
 * @text Middle Left
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg center:json
 * @text Middle Center
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg right:json
 * @text Middle Right
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg lowerleft:json
 * @text Lower Left
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg down:json
 * @text Lower Center
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @arg lowerright:json
 * @text Lower Right
 * @parent Text
 * @type note
 * @desc The text that's aligned to this picture's side.
 * You may use text codes.
 * @default ""
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureTextErase
 * @text Picture: Erase Text
 * @desc Erase all text for target picture(s).
 *
 * @arg PictureIDs:arraynum
 * @text Picture ID(s)
 * @type number[]
 * @min 1
 * @max 100
 * @desc The ID(s) of the picture(s) to erase text for.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureTextRefresh
 * @text Picture: Refresh Text
 * @desc Refreshes the text used for all on-screen pictures.
 * To be used if any dynamic text codes are updated like \n[x].
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param MessageCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param General:struct
 * @text General Settings
 * @type struct<General>
 * @desc General settings involving the message system.
 * @default {"MessageWindow":"","MessageRows:num":"4","MessageWidth:num":"816","FastForwardKey:str":"pagedown","MessageTextDelay:num":"1","StretchDimmedBg:eval":"true","DefaultOutlineWidth:num":"3","NameBoxWindow":"","NameBoxWindowDefaultColor:num":"0","NameBoxWindowOffsetX:num":"0","NameBoxWindowOffsetY:num":"0","ChoiceListWindow":"","ChoiceWindowLineHeight:num":"36","ChoiceWindowMaxRows:num":"8","ChoiceWindowMaxCols:num":"1","ChoiceWindowTextAlign:str":"default","DefaultTextCodes":"","RelativePXPY:eval":"true","FontBiggerCap:eval":"108","FontSmallerCap:eval":"12","FontChangeValue:eval":"12"}
 *
 * @param AutoColor:struct
 * @text Auto-Color Settings
 * @type struct<AutoColor>
 * @desc Automatically color certain keywords a specific way.
 * @default {"DatabaseHighlighting":"","Actors:str":"0","Classes:str":"0","Skills:str":"0","Items:str":"0","Weapons:str":"0","Armors:str":"0","Enemies:str":"0","States:str":"0","WordHighlighting":"","TextColor1:arraystr":"[]","TextColor2:arraystr":"[]","TextColor3:arraystr":"[]","TextColor4:arraystr":"[]","TextColor5:arraystr":"[]","TextColor6:arraystr":"[]","TextColor7:arraystr":"[]","TextColor8:arraystr":"[]","TextColor9:arraystr":"[]","TextColor10:arraystr":"[]","TextColor11:arraystr":"[]","TextColor12:arraystr":"[]","TextColor13:arraystr":"[]","TextColor14:arraystr":"[]","TextColor15:arraystr":"[]","TextColor16:arraystr":"[]","TextColor17:arraystr":"[]","TextColor18:arraystr":"[]","TextColor19:arraystr":"[]","TextColor20:arraystr":"[]","TextColor21:arraystr":"[]","TextColor22:arraystr":"[]","TextColor23:arraystr":"[]","TextColor24:arraystr":"[]","TextColor25:arraystr":"[]","TextColor26:arraystr":"[]","TextColor27:arraystr":"[]","TextColor28:arraystr":"[]","TextColor29:arraystr":"[]","TextColor30:arraystr":"[]","TextColor31:arraystr":"[]"}
 *
 * @param CustomFonts:arraystruct
 * @text Custom Font Manager
 * @type struct<CustomFont>[]
 * @desc Register custom fonts here. Custom fonts that aren't the
 * message or number fonts cannot be used without this.
 * @default []
 *
 * @param TextCodeActions:arraystruct
 * @text Text Code Actions
 * @type struct<TextCodeAction>[]
 * @desc Text codes that perform actions.
 * @default ["{\"Match:str\":\"ChangeFace\",\"Type:str\":\"\\\\<(.*?)\\\\>\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst data = this.obtainEscapeString(textState).split(',');\\\\nif (textState.drawing) {\\\\n    const filename = data[0].trim();\\\\n    const index = parseInt(data[1] || '0');\\\\n    $gameMessage.setFaceImage(filename, index);\\\\n    this.loadMessageFace();\\\\n    const rtl = $gameMessage.isRTL();\\\\n    const width = ImageManager.faceWidth;\\\\n    const height = this.innerHeight;\\\\n    const x = rtl ? this.innerWidth - width - 4 : 4;\\\\n    this.contents.clearRect(x, 0, width, height);\\\\n    this._faceBitmap.addLoadListener(this.drawMessageFace.bind(this));\\\\n}\\\"\"}","{\"Match:str\":\"FaceIndex\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst index = this.obtainEscapeParam(textState);\\\\nif (textState.drawing) {\\\\n    const filename = $gameMessage.faceName();\\\\n    $gameMessage.setFaceImage(filename, index);\\\\n    this.loadMessageFace();\\\\n    const rtl = $gameMessage.isRTL();\\\\n    const width = ImageManager.faceWidth;\\\\n    const height = this.innerHeight;\\\\n    const x = rtl ? this.innerWidth - width - 4 : 4;\\\\n    this.contents.clearRect(x, 0, width, height);\\\\n    this._faceBitmap.addLoadListener(this.drawMessageFace.bind(this));\\\\n}\\\"\"}","{\"Match:str\":\"TextDelay\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst delay = this.obtainEscapeParam(textState);\\\\nif (textState.drawing && this.constructor === Window_Message) {\\\\n    this.setTextDelay(delay);\\\\n}\\\"\"}","{\"Match:str\":\"NormalBG\",\"Type:str\":\"\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nif (textState.drawing) {\\\\n    this.setBackgroundType(0);\\\\n}\\\"\"}","{\"Match:str\":\"DimBG\",\"Type:str\":\"\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nif (textState.drawing) {\\\\n    this.setBackgroundType(1);\\\\n}\\\"\"}","{\"Match:str\":\"TransparentBG\",\"Type:str\":\"\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nif (textState.drawing) {\\\\n    this.setBackgroundType(2);\\\\n}\\\"\"}","{\"Match:str\":\"FontChange\",\"Type:str\":\"\\\\<(.*?)\\\\>\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst fontName = this.obtainEscapeString(textState);\\\\nthis.contents.fontFace = fontName;\\\"\"}","{\"Match:str\":\"ResetFont\",\"Type:str\":\"\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"this.resetFontSettings();\\\"\"}","{\"Match:str\":\"ResetColor\",\"Type:str\":\"\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"this.resetTextColor();\\\"\"}","{\"Match:str\":\"HexColor\",\"Type:str\":\"\\\\<(.*?)\\\\>\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst hexColor = this.obtainEscapeString(textState);\\\\nif (!this.isColorLocked() && textState.drawing) {\\\\n    this.changeTextColor(hexColor);\\\\n}\\\"\"}","{\"Match:str\":\"OutlineColor\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst colorIndex = this.obtainEscapeParam(textState);\\\\nif (!this.isColorLocked() && textState.drawing) {\\\\n    this.changeOutlineColor(ColorManager.textColor(colorIndex));\\\\n}\\\"\"}","{\"Match:str\":\"OutlineHexColor\",\"Type:str\":\"\\\\<(.*?)\\\\>\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst hexColor = this.obtainEscapeString(textState);\\\\nif (!this.isColorLocked() && textState.drawing) {\\\\n    this.changeOutlineColor(hexColor);\\\\n}\\\"\"}","{\"Match:str\":\"OutlineWidth\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst width = this.obtainEscapeParam(textState);\\\\nif (textState.drawing) {\\\\n    this.contents.outlineWidth = width;\\\\n}\\\"\"}","{\"Match:str\":\"WindowMoveTo\",\"Type:str\":\"\\\\<(.*?)\\\\>\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst data = this.obtainEscapeString(textState).split(',');\\\\nif (textState.drawing) {\\\\n    const x = !!data[0] ? Number(data[0].trim()) : this.x;\\\\n    const y = !!data[1] ? Number(data[1].trim()) : this.y;\\\\n    const width = !!data[2] ? Number(data[2].trim()) : this.width;\\\\n    const height = !!data[3] ? Number(data[3].trim()) : this.height;\\\\n    const duration = !!data[4] ? Number(data[4].trim()) : 20;\\\\n    const easingType = !!data[5] ? data[5].trim() : 0;\\\\n    this.moveTo(x, y, width, height, duration, easingType);\\\\n}\\\"\"}","{\"Match:str\":\"WindowMoveBy\",\"Type:str\":\"\\\\<(.*?)\\\\>\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nconst data = this.obtainEscapeString(textState).split(',');\\\\nif (textState.drawing) {\\\\n    const x = !!data[0] ? Number(data[0].trim()) : 0;\\\\n    const y = !!data[1] ? Number(data[1].trim()) : 0;\\\\n    const width = !!data[2] ? Number(data[2].trim()) : 0;\\\\n    const height = !!data[3] ? Number(data[3].trim()) : 0;\\\\n    const duration = !!data[4] ? Number(data[4].trim()) : 20;\\\\n    const easingType = !!data[5] ? data[5].trim() : 0;\\\\n    this.moveBy(x, y, width, height, duration, easingType);\\\\n}\\\"\"}","{\"Match:str\":\"WindowReset\",\"Type:str\":\"\",\"CommonEvent:num\":\"0\",\"ActionJS:func\":\"\\\"const textState = arguments[0];\\\\nif (textState.drawing) {\\\\n    const frames = 20;\\\\n    const easingType = 0;\\\\n    this.resetRect(frames, easingType);\\\\n}\\\"\"}"]
 *
 * @param TextCodeReplace:arraystruct
 * @text Text Code Replacements
 * @type struct<TextCodeReplace>[]
 * @desc Text codes that replace themselves with text.
 * @default ["{\"Match:str\":\"ActorFace\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const actorId = parseInt(arguments[1]);\\\\nconst actor = $gameActors.actor(actorId);\\\\nif (this.constructor === Window_Message && actor) {\\\\n    $gameMessage.setFaceImage(\\\\n        actor.faceName(),\\\\n        actor.faceIndex()\\\\n    );\\\\n}\\\\nreturn '';\\\"\"}","{\"Match:str\":\"PartyFace\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const index = parseInt(arguments[1]) - 1;\\\\nconst actor = $gameParty.members()[index];\\\\nif (this.constructor === Window_Message && actor) {\\\\n    $gameMessage.setFaceImage(\\\\n        actor.faceName(),\\\\n        actor.faceIndex()\\\\n    );\\\\n}\\\\nreturn '';\\\"\"}","{\"Match:str\":\"Class\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataClasses;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"ClassIcon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataClasses;\\\\nconst id = parseInt(arguments[1]);\\\\nconst obj = database[id];\\\\nconst icon = obj ? (obj.iconIndex || 0) : 0;\\\\nreturn icon ? '\\\\\\\\x1bI[%1]'.format(icon) : '';\\\"\"}","{\"Match:str\":\"ClassName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataClasses;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"Skill\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataSkills;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"SkillIcon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataSkills;\\\\nconst id = parseInt(arguments[1]);\\\\nconst obj = database[id];\\\\nconst icon = obj ? (obj.iconIndex || 0) : 0;\\\\nreturn icon ? '\\\\\\\\x1bI[%1]'.format(icon) : '';\\\"\"}","{\"Match:str\":\"SkillName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataSkills;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"Item\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataItems;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"ItemIcon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataItems;\\\\nconst id = parseInt(arguments[1]);\\\\nconst obj = database[id];\\\\nconst icon = obj ? (obj.iconIndex || 0) : 0;\\\\nreturn icon ? '\\\\\\\\x1bI[%1]'.format(icon) : '';\\\"\"}","{\"Match:str\":\"ItemName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataItems;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"ItemQuantity\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataItems;\\\\nconst id = parseInt(arguments[1]);\\\\nreturn $gameParty.numItems(database[id]);\\\"\"}","{\"Match:str\":\"Weapon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataWeapons;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"WeaponIcon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataWeapons;\\\\nconst id = parseInt(arguments[1]);\\\\nconst obj = database[id];\\\\nconst icon = obj ? (obj.iconIndex || 0) : 0;\\\\nreturn icon ? '\\\\\\\\x1bI[%1]'.format(icon) : '';\\\"\"}","{\"Match:str\":\"WeaponName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataWeapons;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"WeaponQuantity\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataWeapons;\\\\nconst id = parseInt(arguments[1]);\\\\nreturn $gameParty.numItems(database[id]);\\\"\"}","{\"Match:str\":\"Armor\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataArmors;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"ArmorIcon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataArmors;\\\\nconst id = parseInt(arguments[1]);\\\\nconst obj = database[id];\\\\nconst icon = obj ? (obj.iconIndex || 0) : 0;\\\\nreturn icon ? '\\\\\\\\x1bI[%1]'.format(icon) : '';\\\"\"}","{\"Match:str\":\"ArmorName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataArmors;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"ArmorQuantity\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataArmors;\\\\nconst id = parseInt(arguments[1]);\\\\nreturn $gameParty.numItems(database[id]);\\\"\"}","{\"Match:str\":\"State\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataStates;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"StateIcon\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataStates;\\\\nconst id = parseInt(arguments[1]);\\\\nconst obj = database[id];\\\\nconst icon = obj ? (obj.iconIndex || 0) : 0;\\\\nreturn icon ? '\\\\\\\\x1bI[%1]'.format(icon) : '';\\\"\"}","{\"Match:str\":\"StateName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataStates;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"LastGainObj\",\"Type:str\":\"\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const icon = true;\\\\nreturn this.lastGainedObjectName(icon);\\\"\"}","{\"Match:str\":\"LastGainObjIcon\",\"Type:str\":\"\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"return this.lastGainedObjectIcon();\\\"\"}","{\"Match:str\":\"LastGainObjName\",\"Type:str\":\"\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const icon = false;\\\\nreturn this.lastGainedObjectName(icon);\\\"\"}","{\"Match:str\":\"LastGainObjQuantity\",\"Type:str\":\"\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"return this.lastGainedObjectQuantity();\\\"\"}","{\"Match:str\":\"Enemy\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataEnemies;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"EnemyName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataEnemies;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"Troop\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataTroops;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"TroopName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"const database = $dataTroops;\\\\nconst id = parseInt(arguments[1]);\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"TroopMember\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"if (!$gameParty.inBattle()) return \\\\\\\"\\\\\\\";\\\\nconst index = (parseInt(arguments[1]) - 1) || 0;\\\\nconst member = $gameTroop.members()[index];\\\\nconst database = $dataEnemies;\\\\nconst id = member ? member.enemyId() : 0;\\\\nconst icon = true;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}","{\"Match:str\":\"TroopMemberName\",\"Type:str\":\"\\\\[(\\\\d+)\\\\]\",\"TextStr:str\":\"Undefined\",\"TextJS:func\":\"\\\"if (!$gameParty.inBattle()) return \\\\\\\"\\\\\\\";\\\\nconst index = (parseInt(arguments[1]) - 1) || 0;\\\\nconst member = $gameTroop.members()[index];\\\\nconst database = $dataEnemies;\\\\nconst id = member ? member.enemyId() : 0;\\\\nconst icon = false;\\\\nreturn this.databaseObjectName(database, id, icon);\\\"\"}"]
 *
 * @param TextMacros:arraystruct
 * @text Text Code Macros
 * @type struct<TextMacro>[]
 * @desc Macros that are used to quickly write batches of text.
 * Format style: [MacroName]
 * @default ["{\"Match:str\":\"Example Macro\",\"TextStr:str\":\"This is the text that will be displayed when you type [Example Macro].\",\"TextJS:func\":\"\\\"return 'Text';\\\"\"}","{\"Match:str\":\"Leader\",\"TextStr:str\":\"\\\\P[1]\",\"TextJS:func\":\"\\\"return 'Text';\\\"\"}"]
 *
 * @param Localization:struct
 * @text Text Language Settings
 * @type struct<Localization>
 * @desc Text Language settings for this plugin.
 * @default {"Main":"","Enable:eval":"false","CsvFilename:str":"Languages.csv","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","Name:str":"Text Language","Localized":"","DefaultLocale:str":"English","Languages:arraystr":"[\"Bengali\",\"Chinese(Simplified)\",\"Chinese(Traditional)\",\"Czech\",\"Danish\",\"Dutch\",\"English\",\"Finnish\",\"French\",\"German\",\"Greek\",\"Hindi\",\"Hungarian\",\"Indonesian\",\"Italian\",\"Japanese\",\"Korean\",\"Norwegian\",\"Polish\",\"Portuguese\",\"Romanian\",\"Russian\",\"Slovak\",\"Spanish\",\"Swedish\",\"Tamil\",\"Thai\",\"Turkish\"]","LangNames":"","Bengali:str":"বাংলা","Chinese(Simplified):str":"简体中文","Chinese(Traditional):str":"繁體中文","Czech:str":"Čeština","Danish:str":"Dansk","Dutch:str":"Nederlands","English:str":"English","Finnish:str":"Suomi","French:str":"Français","German:str":"Deutsch","Greek:str":"Ελληνικά","Hindi:str":"हिन्दी","Hungarian:str":"Magyar","Indonesian:str":"Bahasa Indo","Italian:str":"Italiano","Japanese:str":"日本語","Korean:str":"한국어","Norwegian:str":"Norsk","Polish:str":"Polski","Portuguese:str":"Português","Romanian:str":"Română","Russian:str":"Русский","Slovak:str":"Slovenčina","Spanish:str":"Español","Swedish:str":"Svenska","Tamil:str":"தமிழ்","Thai:str":"ไทย","Turkish:str":"Türkçe"}
 *
 * @param TextSpeed:struct
 * @text Text Speed Option Settings
 * @type struct<TextSpeed>
 * @desc Text Speed Options Menu settings.
 * @default {"AddOption:eval":"true","AdjustRect:eval":"true","Name:str":"Text Speed","Default:num":"10","Instant:str":"Instant"}
 *
 * @param WordWrap:struct
 * @text Word Wrap Settings
 * @type struct<WordWrap>
 * @desc Settings involving Word Wrap.
 * @default {"EnableWordWrap":"","MessageWindow:eval":"false","HelpWindow:eval":"false","Rules":"","LineBreakSpace:eval":"true","TightWrap:eval":"false","EndPadding:num":"0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * General Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~General:
 *
 * @param MessageWindow
 * @text Message Window
 *
 * @param MessageRows:num
 * @text Default Rows
 * @parent MessageWindow
 * @type num
 * @min 1
 * @desc Default number of rows to display for the Message Window.
 * @default 4
 *
 * @param MessageWidth:num
 * @text Default Width
 * @parent MessageWindow
 * @type num
 * @min 1
 * @desc Default Message Window width in pixels.
 * @default 816
 *
 * @param FastForwardKey:str
 * @text Fast Forward Key
 * @parent MessageWindow
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for fast forwarding messages.
 * @default pagedown
 *
 * @param MessageTextDelay:num
 * @text Text Delay
 * @parent MessageWindow
 * @type number
 * @min 0
 * @desc How many frames to wait between characters drawn?
 * Use 0 for instant.
 * @default 1
 *
 * @param MsgWindowOffsetX:num
 * @text Offset X
 * @parent MessageWindow
 * @desc Offset Message Window horizontally.
 * Negative: Left; Positive: Right
 * @default +0
 *
 * @param MsgWindowOffsetY:num
 * @text Offset Y
 * @parent MessageWindow
 * @desc Offset Message Window vertically.
 * Negative: Up; Positive: Down
 * @default +0
 *
 * @param StretchDimmedBg:eval
 * @text Stretch Dimmed BG
 * @parent MessageWindow
 * @type boolean
 * @on Stretch
 * @off Don't
 * @desc Stretch dimmed window background to fit the whole screen.
 * @default true
 *
 * @param DefaultOutlineWidth:num
 * @text Default Outline Width
 * @parent MessageWindow
 * @type number
 * @min 0
 * @desc Changes the default outline width to this many pixels thick.
 * @default 3
 *
 * @param EachMessageStart:json
 * @text Each Message Start
 * @parent MessageWindow
 * @type note
 * @desc This is text that is added at the start of each message.
 * You may use text codes.
 * @default ""
 *
 * @param EachMessageEnd:json
 * @text Each Message End
 * @parent MessageWindow
 * @type note
 * @desc This is text that is added at the end of each message.
 * You may use text codes.
 * @default ""
 *
 * @param NameBoxWindow
 * @text Name Box Window
 *
 * @param NameBoxWindowDefaultColor:num
 * @text Default Color
 * @parent NameBoxWindow
 * @min 0
 * @max 31
 * @desc Default color for the Name Box Window's text.
 * @default 0
 *
 * @param NameBoxWindowOffsetX:num
 * @text Offset X
 * @parent NameBoxWindow
 * @desc How much to offset the name box window X by (as long as it doesn't go offscreen).
 * @default +0
 *
 * @param NameBoxWindowOffsetY:num
 * @text Offset Y
 * @parent NameBoxWindow
 * @desc How much to offset the name box window Y by (as long as it doesn't go offscreen).
 * @default +0
 *
 * @param ChoiceListWindow
 * @text Choice List Window
 *
 * @param ChoiceWindowLineHeight:num
 * @text Line Height
 * @parent ChoiceListWindow
 * @type number
 * @min 1
 * @desc What is the default line height for Show Choices?
 * @default 36
 *
 * @param ChoiceWindowMinWidth:num
 * @text Minimum Choice Width
 * @parent ChoiceListWindow
 * @type number
 * @min 0
 * @desc What is the minimum choice width for each choice?
 * 96 is the default width.
 * @default 96
 *
 * @param ChoiceWindowMaxRows:num
 * @text Max Rows
 * @parent ChoiceListWindow
 * @type number
 * @min 1
 * @desc Maximum number of rows to visibly display?
 * @default 8
 *
 * @param ChoiceWindowMaxCols:num
 * @text Max Columns
 * @parent ChoiceListWindow
 * @type number
 * @min 1
 * @desc Maximum number of columns to visibly display?
 * @default 1
 *
 * @param ChoiceWindowTextAlign:str
 * @text Text Alignment
 * @parent ChoiceListWindow
 * @type select
 * @option Default
 * @value default
 * @option Left
 * @value left
 * @option Center
 * @value center
 * @option Right
 * @value right
 * @desc Default alignment for Show Choice window.
 * @default default
 *
 * @param DefaultTextCodes
 * @text Default Text Codes
 *
 * @param RelativePXPY:eval
 * @text Relative \PX \PY
 * @parent DefaultTextCodes
 * @type boolean
 * @on Better
 * @off Normal
 * @desc Make \PX[x] and \PY[x] adjust relative starting position than exact coordinates.
 * @default true
 *
 * @param FontBiggerCap:eval
 * @text \{ Maximum
 * @parent DefaultTextCodes
 * @type number
 * @min 1
 * @desc Determine the maximum size that \{ can reach.
 * @default 108
 *
 * @param FontSmallerCap:eval
 * @text \} Minimum
 * @parent DefaultTextCodes
 * @type number
 * @min 1
 * @desc Determine the minimum size that \} can reach.
 * @default 12
 *
 * @param FontChangeValue:eval
 * @text \{ Change \}
 * @parent DefaultTextCodes
 * @type number
 * @min 1
 * @desc How much does \{ and \} change font size by?
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Color Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoColor:
 *
 * @param DatabaseHighlighting
 * @text Database Highlighting
 *
 * @param Actors:str
 * @text Actors
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of an Actor's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param Classes:str
 * @text Classes
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of a Class's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param Skills:str
 * @text Skills
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of a Skill's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param Items:str
 * @text Items
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of an Item's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param Weapons:str
 * @text Weapons
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of a Weapon's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param Armors:str
 * @text Armors
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of an Armor's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param Enemies:str
 * @text Enemies
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of an Enemy's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param States:str
 * @text States
 * @parent DatabaseHighlighting
 * @type number
 * @min 0
 * @max 31
 * @desc Any usage of a State's name is given this text color.
 * Use 0 to not auto-color.
 * @default 0
 *
 * @param WordHighlighting
 * @text Word Highlighting
 *
 * @param TextColor1:arraystr
 * @text \C[1]: Blue
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor2:arraystr
 * @text \C[2]: Red
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor3:arraystr
 * @text \C[3]: Green
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor4:arraystr
 * @text \C[4]: Sky Blue
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor5:arraystr
 * @text \C[5]: Purple
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor6:arraystr
 * @text \C[6]: Yellow
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor7:arraystr
 * @text \C[7]: Gray
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor8:arraystr
 * @text \C[8]: Light Gray
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor9:arraystr
 * @text \C[9]: Dark Blue
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor10:arraystr
 * @text \C[10]: Dark Red
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor11:arraystr
 * @text \C[11]: Dark Green
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor12:arraystr
 * @text \C[12]: Dark Sky Blue
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor13:arraystr
 * @text \C[13]: Dark Purple
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor14:arraystr
 * @text \C[14]: Solid Yellow
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor15:arraystr
 * @text \C[15]: Black
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor16:arraystr
 * @text \C[16]: System Blue
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor17:arraystr
 * @text \C[17]: Crisis Yellow
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor18:arraystr
 * @text \C[18]: Dead Red
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor19:arraystr
 * @text \C[19]: Outline Black
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor20:arraystr
 * @text \C[20]: HP Orange 1
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor21:arraystr
 * @text \C[21]: HP Orange 2
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor22:arraystr
 * @text \C[22]: MP Blue 1
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor23:arraystr
 * @text \C[23]: MP Blue 2
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor24:arraystr
 * @text \C[24]: Param Up Green
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor25:arraystr
 * @text \C[25]: Param Down Red
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor26:arraystr
 * @text \C[26]: System Purple
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor27:arraystr
 * @text \C[27]: System Pink
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor28:arraystr
 * @text \C[28]: TP Green 1
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor29:arraystr
 * @text \C[29]: TP Green 2
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor30:arraystr
 * @text \C[30]: EXP Purple 1
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 * @param TextColor31:arraystr
 * @text \C[31]: EXP Purple 2
 * @parent WordHighlighting
 * @type string[]
 * @desc A list of all the words that will be automatically colored with this text color.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Custom Font Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~CustomFont:
 *
 * @param FontFamily:str
 * @text Font Family
 * @desc This will be what's used by RPG Maker MZ and plugins to
 * reference this specific font. NO filename extensions!
 * @default Unnamed
 *
 * @param Filename:str
 * @text Filename
 * @desc What is the filename of the custom font you would like to use?
 * Located inside the project's "fonts" folder.
 * @default Unnamed.ttf
 *
 */
/* ----------------------------------------------------------------------------
 * Text Code Actions
 * ----------------------------------------------------------------------------
 */
/*~struct~TextCodeAction:
 *
 * @param Match:str
 * @text Match
 * @desc This is what needs to be matched in order for this text code to work.
 * @default Key
 *
 * @param Type:str
 * @text Type
 * @type select
 * @option none
 * @value 
 * @option [x] (number)
 * @value \[(\d+)\]
 * @option <x> (string)
 * @value \<(.*?)\>
 * @desc The type of parameter to obtain (none, number, or string).
 * @default 
 *
 * @param CommonEvent:num
 * @text Common Event
 * @type common_event
 * @desc Select a common event to run when this text code is used in a message.
 * @default 0
 *
 * @param ActionJS:func
 * @text JS: Action
 * @type note
 * @desc JavaScript code used to perform an action when this text code appears.
 * @default "const textState = arguments[0];"
 *
 */
/* ----------------------------------------------------------------------------
 * Text Code Replacements
 * ----------------------------------------------------------------------------
 */
/*~struct~TextCodeReplace:
 *
 * @param Match:str
 * @text Match
 * @desc This is what needs to be matched in order for this text code to work.
 * @default Key
 *
 * @param Type:str
 * @text Type
 * @type select
 * @option none
 * @value 
 * @option [x] (number)
 * @value \[(\d+)\]
 * @option <x> (string)
 * @value \<(.*?)\>
 * @desc The type of parameter to obtain (none, number, or string).
 * @default 
 *
 * @param TextStr:str
 * @text STR: Text
 * @desc The text that will appear if this match appears.
 * If this has a value, ignore the JS: Text version.
 * @default Undefined
 *
 * @param TextJS:func
 * @text JS: Text
 * @type note
 * @desc JavaScript code used to determine the text that will appear if this match appears.
 * @default "return 'Text';"
 *
 */
/* ----------------------------------------------------------------------------
 * Text Macro
 * ----------------------------------------------------------------------------
 */
/*~struct~TextMacro:
 *
 * @param Match:str
 * @text Match
 * @desc This is what needs to be matched in order for this macro to work.
 * @default Key
 *
 * @param TextStr:str
 * @text STR: Text
 * @desc The replacement text that will appear from the macro.
 * If this has a value, ignore the JS: Text version.
 * @default Undefined
 *
 * @param TextJS:func
 * @text JS: Text
 * @type note
 * @desc JavaScript code used to determine the text that will appear if this macro appears.
 * @default "return 'Text';"
 *
 */
/* ----------------------------------------------------------------------------
 * Localization Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Localization:
 *
 * @param Main
 * @text Main Settings
 *
 * @param Enable:eval
 * @text Enable Switching?
 * @parent Main
 * @type boolean
 * @on Enable
 * @off Don't
 * @desc Enable language switching settings for this plugin?
 * @default false
 *
 * @param CsvFilename:str
 * @text CSV Filename
 * @parent Main
 * @desc What is the filename of the CSV file to read from?
 * Located within the project's /data/ folder.
 * @default Languages.csv
 *
 * @param Options
 * @text Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Language' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Text Language
 *
 * @param Localized
 * @text Languages
 *
 * @param DefaultLocale:str
 * @text Default Language
 * @parent Localized
 * @type select
 * @option Bengali
 * @option Chinese(Simplified)
 * @option Chinese(Traditional)
 * @option Czech
 * @option Danish
 * @option Dutch
 * @option English
 * @option Finnish
 * @option French
 * @option German
 * @option Greek
 * @option Hindi
 * @option Hungarian
 * @option Indonesian
 * @option Italian
 * @option Japanese
 * @option Korean
 * @option Norwegian
 * @option Polish
 * @option Portuguese
 * @option Romanian
 * @option Russian
 * @option Slovak
 * @option Spanish
 * @option Swedish
 * @option Tamil
 * @option Thai
 * @option Turkish
 * @desc What is the default language used for this game?
 * @default English
 *
 * @param Languages:arraystr
 * @text Supported Languages
 * @parent Localized
 * @type select[]
 * @option Bengali
 * @option Chinese(Simplified)
 * @option Chinese(Traditional)
 * @option Czech
 * @option Danish
 * @option Dutch
 * @option English
 * @option Finnish
 * @option French
 * @option German
 * @option Greek
 * @option Hindi
 * @option Hungarian
 * @option Indonesian
 * @option Italian
 * @option Japanese
 * @option Korean
 * @option Norwegian
 * @option Polish
 * @option Portuguese
 * @option Romanian
 * @option Russian
 * @option Slovak
 * @option Spanish
 * @option Swedish
 * @option Tamil
 * @option Thai
 * @option Turkish
 * @desc What are all the supported languages supported by this
 * game's script? Remove any that aren't translated.
 * @default ["Bengali","Chinese(Simplified)","Chinese(Traditional)","Czech","Danish","Dutch","English","Finnish","French","German","Greek","Hindi","Hungarian","Indonesian","Italian","Japanese","Korean","Norwegian","Polish","Portuguese","Romanian","Russian","Slovak","Spanish","Swedish","Tamil","Thai","Turkish"]
 *
 * @param LangNames
 * @text Language Names
 *
 * @param Bengali:str
 * @text Bengali
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default বাংলা
 * 
 * @param Chinese(Simplified):str
 * @text Chinese (Simplified)
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default 简体中文
 * 
 * @param Chinese(Traditional):str
 * @text Chinese (Traditional)
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default 繁體中文
 * 
 * @param Czech:str
 * @text Czech
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Čeština
 * 
 * @param Danish:str
 * @text Danish
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Dansk
 * 
 * @param Dutch:str
 * @text Dutch
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Nederlands
 * 
 * @param English:str
 * @text English
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default English
 * 
 * @param Finnish:str
 * @text Finnish
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Suomi
 * 
 * @param French:str
 * @text French
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Français
 * 
 * @param German:str
 * @text German
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Deutsch
 * 
 * @param Greek:str
 * @text Greek
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Ελληνικά
 * 
 * @param Hindi:str
 * @text Hindi
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default हिन्दी
 * 
 * @param Hungarian:str
 * @text Hungarian
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Magyar
 * 
 * @param Indonesian:str
 * @text Indonesian
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Bahasa Indo
 * 
 * @param Italian:str
 * @text Italian
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Italiano
 * 
 * @param Japanese:str
 * @text Japanese
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default 日本語
 * 
 * @param Korean:str
 * @text Korean
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default 한국어
 * 
 * @param Norwegian:str
 * @text Norwegian
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Norsk
 * 
 * @param Polish:str
 * @text Polish
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Polski
 * 
 * @param Portuguese:str
 * @text Portuguese
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Português
 * 
 * @param Romanian:str
 * @text Romanian
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Română
 * 
 * @param Russian:str
 * @text Russian
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Русский
 * 
 * @param Slovak:str
 * @text Slovak
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Slovenčina
 * 
 * @param Spanish:str
 * @text Spanish
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Español
 * 
 * @param Swedish:str
 * @text Swedish
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Svenska
 * 
 * @param Tamil:str
 * @text Tamil
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default தமிழ்
 * 
 * @param Thai:str
 * @text Thai
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default ไทย
 * 
 * @param Turkish:str
 * @text Turkish
 * @parent LangNames
 * @desc How does this language appear in the in-game options?
 * @default Türkçe
 *
 */
/* ----------------------------------------------------------------------------
 * Text Speed Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~TextSpeed:
 *
 * @param AddOption:eval
 * @text Add Option?
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Text Speed' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @desc Command name of the option.
 * @default Text Speed
 *
 * @param Default:num
 * @text Default Value
 * @type number
 * @min 1
 * @max 11
 * @desc 1 - 10, slowest to fastest.
 * 11 is instant value.
 * @default 10
 *
 * @param Instant:str
 * @text Instant Speed
 * @desc Text to show "instant" text.
 * @default Instant
 *
 */
/* ----------------------------------------------------------------------------
 * Word Wrap Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~WordWrap:
 *
 * @param EnableWordWrap
 * @text Enable Word Wrap
 *
 * @param MessageWindow:eval
 * @text Message Window
 * @parent EnableWordWrap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Automatically enable Word Wrap for this window?
 * @default false
 *
 * @param HelpWindow:eval
 * @text Help Window
 * @parent EnableWordWrap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Automatically enable Word Wrap for this window?
 * @default false
 *
 * @param Rules
 * @text Rules
 *
 * @param LineBreakSpace:eval
 * @text Link Break -> Space
 * @parent Rules
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Convert manually placed (non tagged) line breaks with spaces?
 * @default true
 *
 * @param TightWrap:eval
 * @text Tight Wrap
 * @parent Rules
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc If a face graphic is present in a message, word wrap will be tighter.
 * @default false
 *
 * @param EndPadding:num
 * @text End Padding
 * @parent Rules
 * @type number
 * @desc Add extra padding to your window to make text wrap further away from the end of the window.
 * @default 0
 *
 */
//=============================================================================

const _0x571fe1=_0x3605;(function(_0x3c1890,_0x2b6f38){const _0x2a3d01=_0x3605,_0xe5b574=_0x3c1890();while(!![]){try{const _0x20209c=parseInt(_0x2a3d01(0x181))/0x1+-parseInt(_0x2a3d01(0x164))/0x2*(parseInt(_0x2a3d01(0x1e1))/0x3)+-parseInt(_0x2a3d01(0x227))/0x4*(-parseInt(_0x2a3d01(0x37e))/0x5)+-parseInt(_0x2a3d01(0x410))/0x6+parseInt(_0x2a3d01(0x44a))/0x7*(parseInt(_0x2a3d01(0x4e3))/0x8)+-parseInt(_0x2a3d01(0x268))/0x9+parseInt(_0x2a3d01(0x1c6))/0xa;if(_0x20209c===_0x2b6f38)break;else _0xe5b574['push'](_0xe5b574['shift']());}catch(_0xb1a4ad){_0xe5b574['push'](_0xe5b574['shift']());}}}(_0x3c55,0xec3dc));var label=_0x571fe1(0x3f9),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x571fe1(0x256)](function(_0x76d7d5){const _0x54d4b7=_0x571fe1;return _0x76d7d5[_0x54d4b7(0x488)]&&_0x76d7d5[_0x54d4b7(0x2fb)][_0x54d4b7(0x297)]('['+label+']');})[0x0];VisuMZ[label][_0x571fe1(0x49b)]=VisuMZ[label][_0x571fe1(0x49b)]||{},VisuMZ['ConvertParams']=function(_0x3fb6e9,_0x153886){const _0x399377=_0x571fe1;for(const _0x6a0016 in _0x153886){if(_0x6a0016[_0x399377(0xf6)](/(.*):(.*)/i)){const _0x5872aa=String(RegExp['$1']),_0x49e7cb=String(RegExp['$2'])[_0x399377(0x3b8)]()['trim']();let _0x363b4e,_0x176a04,_0x6a9d69;switch(_0x49e7cb){case _0x399377(0x520):_0x363b4e=_0x153886[_0x6a0016]!==''?Number(_0x153886[_0x6a0016]):0x0;break;case'ARRAYNUM':_0x176a04=_0x153886[_0x6a0016]!==''?JSON[_0x399377(0x47f)](_0x153886[_0x6a0016]):[],_0x363b4e=_0x176a04['map'](_0x5ca4b4=>Number(_0x5ca4b4));break;case _0x399377(0x459):_0x363b4e=_0x153886[_0x6a0016]!==''?eval(_0x153886[_0x6a0016]):null;break;case _0x399377(0x478):_0x176a04=_0x153886[_0x6a0016]!==''?JSON[_0x399377(0x47f)](_0x153886[_0x6a0016]):[],_0x363b4e=_0x176a04[_0x399377(0x328)](_0xc52e28=>eval(_0xc52e28));break;case _0x399377(0x342):_0x363b4e=_0x153886[_0x6a0016]!==''?JSON[_0x399377(0x47f)](_0x153886[_0x6a0016]):'';break;case'ARRAYJSON':_0x176a04=_0x153886[_0x6a0016]!==''?JSON[_0x399377(0x47f)](_0x153886[_0x6a0016]):[],_0x363b4e=_0x176a04[_0x399377(0x328)](_0x1526e0=>JSON[_0x399377(0x47f)](_0x1526e0));break;case'FUNC':_0x363b4e=_0x153886[_0x6a0016]!==''?new Function(JSON[_0x399377(0x47f)](_0x153886[_0x6a0016])):new Function('return\x200');break;case _0x399377(0xe2):_0x176a04=_0x153886[_0x6a0016]!==''?JSON['parse'](_0x153886[_0x6a0016]):[],_0x363b4e=_0x176a04[_0x399377(0x328)](_0x47cd16=>new Function(JSON[_0x399377(0x47f)](_0x47cd16)));break;case _0x399377(0x46e):_0x363b4e=_0x153886[_0x6a0016]!==''?String(_0x153886[_0x6a0016]):'';break;case _0x399377(0x340):_0x176a04=_0x153886[_0x6a0016]!==''?JSON[_0x399377(0x47f)](_0x153886[_0x6a0016]):[],_0x363b4e=_0x176a04[_0x399377(0x328)](_0x2c0bb0=>String(_0x2c0bb0));break;case'STRUCT':_0x6a9d69=_0x153886[_0x6a0016]!==''?JSON[_0x399377(0x47f)](_0x153886[_0x6a0016]):{},_0x3fb6e9[_0x5872aa]={},VisuMZ[_0x399377(0x50d)](_0x3fb6e9[_0x5872aa],_0x6a9d69);continue;case'ARRAYSTRUCT':_0x176a04=_0x153886[_0x6a0016]!==''?JSON['parse'](_0x153886[_0x6a0016]):[],_0x363b4e=_0x176a04['map'](_0x460cb3=>VisuMZ[_0x399377(0x50d)]({},JSON['parse'](_0x460cb3)));break;default:continue;}_0x3fb6e9[_0x5872aa]=_0x363b4e;}}return _0x3fb6e9;},(_0x15901e=>{const _0x3a3144=_0x571fe1,_0x4236d8=_0x15901e[_0x3a3144(0x2cd)];for(const _0x2a5d61 of dependencies){if(!Imported[_0x2a5d61]){alert(_0x3a3144(0x2b2)['format'](_0x4236d8,_0x2a5d61)),SceneManager[_0x3a3144(0x48c)]();break;}}const _0x2407bc=_0x15901e[_0x3a3144(0x2fb)];if(_0x2407bc['match'](/\[Version[ ](.*?)\]/i)){const _0x595ace=Number(RegExp['$1']);_0x595ace!==VisuMZ[label]['version']&&(alert(_0x3a3144(0x139)[_0x3a3144(0x3dd)](_0x4236d8,_0x595ace)),SceneManager[_0x3a3144(0x48c)]());}if(_0x2407bc[_0x3a3144(0xf6)](/\[Tier[ ](\d+)\]/i)){if(_0x3a3144(0x353)!==_0x3a3144(0x32d)){const _0x5aa7c5=Number(RegExp['$1']);if(_0x5aa7c5<tier){if(_0x3a3144(0x1d8)!==_0x3a3144(0x1a1))alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x3a3144(0x3dd)](_0x4236d8,_0x5aa7c5,tier)),SceneManager['exit']();else return this[_0x3a3144(0x3e1)]()===0x65&&_0x2f2572['getMessageWindowRows']()>0x4?!![]:this[_0x3a3144(0x3e1)]()===0x191;}else _0x3a3144(0x4a4)!==_0x3a3144(0x2cf)?tier=Math[_0x3a3144(0x3f5)](_0x5aa7c5,tier):(_0x456159['MessageCore'][_0x3a3144(0x418)][_0x3a3144(0x323)](this),this[_0x3a3144(0x44c)]());}else _0x70e8eb['y']=this[_0x3a3144(0x163)](_0x148e64),_0x594aed[_0x3a3144(0x3f9)][_0x3a3144(0x49b)]['General']['RelativePXPY']&&(_0xe54b19['y']+=_0x2b6b1e[_0x3a3144(0x432)]);}VisuMZ['ConvertParams'](VisuMZ[label][_0x3a3144(0x49b)],_0x15901e['parameters']);})(pluginData),PluginManager[_0x571fe1(0xd8)](pluginData['name'],_0x571fe1(0x1df),_0x41c70e=>{const _0x148da1=_0x571fe1;VisuMZ[_0x148da1(0x50d)](_0x41c70e,_0x41c70e);const _0x2c0cca=Number(_0x41c70e[_0x148da1(0x2cb)])||0x0;$gameSystem['setChoiceMessageDistance'](_0x2c0cca);}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x2e2),_0x176d54=>{const _0x3e5859=_0x571fe1;VisuMZ[_0x3e5859(0x50d)](_0x176d54,_0x176d54);const _0x300b8d=_0x176d54['LineHeight']||$gameSystem[_0x3e5859(0x4df)]()||0x1,_0x2ad317=_0x176d54[_0x3e5859(0x26b)]??0x60,_0x9d7e2a=_0x176d54[_0x3e5859(0x2fa)]||$gameSystem[_0x3e5859(0x1dc)]()||0x1,_0x578425=_0x176d54['MaxCols']||$gameSystem['getChoiceListMaxColumns']()||0x1,_0x5c3806=_0x176d54[_0x3e5859(0x245)]['toLowerCase']()||_0x3e5859(0x2ed);$gameSystem[_0x3e5859(0x1dd)](_0x300b8d),$gameSystem[_0x3e5859(0x39f)](_0x2ad317),$gameSystem[_0x3e5859(0xd2)](_0x9d7e2a),$gameSystem[_0x3e5859(0x11f)](_0x578425),$gameSystem['setChoiceListTextAlign'](_0x5c3806);}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x1bf),_0x5c1ae5=>{const _0x1dabbf=_0x571fe1;VisuMZ['ConvertParams'](_0x5c1ae5,_0x5c1ae5);const _0xe6bdb2=_0x5c1ae5[_0x1dabbf(0x182)]||$gameSystem[_0x1dabbf(0x11a)]()||0x1,_0x1fcae6=_0x5c1ae5[_0x1dabbf(0x343)]||$gameSystem[_0x1dabbf(0xfb)]()||0x1;$gameTemp['_centerMessageWindow']=!![];const _0x3ddd36=_0x5c1ae5['WordWrap'][_0x1dabbf(0x366)]();$gameSystem[_0x1dabbf(0x1db)](_0xe6bdb2),$gameSystem[_0x1dabbf(0x507)](_0x1fcae6);[_0x1dabbf(0x1f7),_0x1dabbf(0x3b0)]['includes'](_0x3ddd36)&&$gameSystem[_0x1dabbf(0x462)](eval(_0x3ddd36));const _0x5d3531=SceneManager[_0x1dabbf(0x45c)]['_messageWindow'];_0x5d3531&&(_0x5d3531[_0x1dabbf(0x3c2)](),_0x5d3531[_0x1dabbf(0x3b2)](),_0x5d3531[_0x1dabbf(0x22a)]());}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x51d),_0x2aa9ea=>{const _0x24345e=_0x571fe1;VisuMZ[_0x24345e(0x50d)](_0x2aa9ea,_0x2aa9ea),$gameSystem[_0x24345e(0x112)](_0x2aa9ea[_0x24345e(0xd5)],_0x2aa9ea[_0x24345e(0x373)]);const _0xd205a6=SceneManager[_0x24345e(0x45c)][_0x24345e(0x3d7)];if(_0xd205a6){if(_0x24345e(0x523)!=='UKVsP'){if(!_0x40dcd6[_0x24345e(0x3fa)](_0x4fc080))return![];const _0x46d824=_0x41f1bc[_0x24345e(0x42d)]();if(_0x46d824>0x0){if(_0x4ada0d[_0x24345e(0xe0)]!==_0x46d824)return![];}return!![];}else _0xd205a6[_0x24345e(0x3c2)](),_0xd205a6[_0x24345e(0x3b2)](),_0xd205a6[_0x24345e(0x22a)]();}}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x1eb),_0x3d0346=>{const _0x2709f0=_0x571fe1;VisuMZ[_0x2709f0(0x50d)](_0x3d0346,_0x3d0346),$gameMessage[_0x2709f0(0x2f9)](_0x3d0346[_0x2709f0(0x2ce)]||0x0,_0x3d0346['WeaponTypeID']||0x0);const _0x44ce44=$gameTemp[_0x2709f0(0x31a)]();if(_0x44ce44)_0x44ce44['setWaitMode']('message');}),PluginManager[_0x571fe1(0xd8)](pluginData['name'],_0x571fe1(0x48a),_0x53f2bb=>{const _0x144e86=_0x571fe1;VisuMZ[_0x144e86(0x50d)](_0x53f2bb,_0x53f2bb),$gameMessage[_0x144e86(0x4a6)](_0x53f2bb[_0x144e86(0x2ce)]||0x0,_0x53f2bb[_0x144e86(0x108)]||0x0,_0x53f2bb[_0x144e86(0x516)]||0x0);const _0x24ee5d=$gameTemp[_0x144e86(0x31a)]();if(_0x24ee5d)_0x24ee5d[_0x144e86(0x31f)]('message');}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x180),_0x12b171=>{const _0x4653eb=_0x571fe1;VisuMZ[_0x4653eb(0x50d)](_0x12b171,_0x12b171),$gameMessage[_0x4653eb(0x3cb)](_0x12b171[_0x4653eb(0x2ce)]||0x0,_0x12b171[_0x4653eb(0x34c)]||0x0,_0x12b171['SkillTypeID']||0x0);const _0x5ce7d0=$gameTemp[_0x4653eb(0x31a)]();if(_0x5ce7d0)_0x5ce7d0[_0x4653eb(0x31f)](_0x4653eb(0x3b5));}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x199),_0x519245=>{const _0x4fab0f=_0x571fe1;VisuMZ[_0x4fab0f(0x50d)](_0x519245,_0x519245);const _0x58b970=_0x519245['PictureIDs']||[],_0x445951=_0x519245[_0x4fab0f(0x386)]||0x0,_0x41e670=['upperleft','up','upperright',_0x4fab0f(0x402),_0x4fab0f(0x3ce),_0x4fab0f(0x236),_0x4fab0f(0x3d6),_0x4fab0f(0x10d),'lowerright'];for(const _0x4b00f6 of _0x58b970){if(_0x4fab0f(0x314)==='EsJhn'){const _0x2253bf=this[_0x4fab0f(0xe7)](_0x3ff6de),_0x18ca94=this[_0x4fab0f(0x1de)](),_0x3d250f=_0x18ca94+this['commandName'](_0x23a656);this[_0x4fab0f(0x142)](this[_0x4fab0f(0x41e)](_0x5cdfa2));const _0x1c68ec=this[_0x4fab0f(0x2ff)](_0x3d250f)['height'],_0x2429da=_0x2253bf['x']+this['getChoiceIndent'](_0x3d250f),_0x43acd2=_0x1f116b[_0x4fab0f(0x3f5)](_0x2253bf['y'],_0x2253bf['y']+_0xa9b7b4[_0x4fab0f(0xd4)]((_0x2253bf[_0x4fab0f(0x3e0)]-_0x1c68ec)/0x2));this[_0x4fab0f(0x3bc)](_0x3d250f,_0x2429da,_0x43acd2,_0x2253bf[_0x4fab0f(0x481)]),this['changeChoiceBackgroundColor'](_0x4ba942),this[_0x4fab0f(0x4f9)](_0x1c96a0,_0x3d250f,_0x2253bf);}else{$gameScreen[_0x4fab0f(0x2e4)](_0x4b00f6,_0x445951);for(const _0x4b7937 of _0x41e670){if(_0x519245[_0x4b7937]===undefined)continue;$gameScreen[_0x4fab0f(0x177)](_0x4b00f6,_0x519245[_0x4b7937],_0x4b7937);}}}}),PluginManager['registerCommand'](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x3fe),_0x4a43c3=>{const _0x461503=_0x571fe1;VisuMZ[_0x461503(0x50d)](_0x4a43c3,_0x4a43c3);const _0xa9f1=_0x4a43c3['PictureIDs']||[];for(const _0x3d5d92 of _0xa9f1){_0x461503(0x4ec)!==_0x461503(0x50f)?($gameScreen[_0x461503(0x448)](_0x3d5d92),$gameScreen['erasePictureTextBuffer'](_0x3d5d92)):_0x45eec1=_0x4040bb[_0x461503(0x3f5)](_0x4b1937,_0x307de9(_0x4da4cb['$1']));}}),PluginManager[_0x571fe1(0xd8)](pluginData[_0x571fe1(0x2cd)],_0x571fe1(0x28c),_0x3da536=>{const _0x2e0496=_0x571fe1;$gameScreen[_0x2e0496(0x440)]();}),VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2db)]=Scene_Boot['prototype'][_0x571fe1(0x111)],Scene_Boot[_0x571fe1(0x252)]['onDatabaseLoaded']=function(){const _0xe1bbbc=_0x571fe1;VisuMZ[_0xe1bbbc(0x3f9)][_0xe1bbbc(0x2db)][_0xe1bbbc(0x323)](this),VisuMZ[_0xe1bbbc(0x3f9)][_0xe1bbbc(0x526)](),this[_0xe1bbbc(0xfd)](),this[_0xe1bbbc(0x3fb)](),this[_0xe1bbbc(0x4b4)](),this['process_VisuMZ_MessageCore_AutoColor']();},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x526)]=function(){const _0x14c3c7=_0x571fe1;if(Imported['VisuMZ_4_ExtraEnemyDrops']&&VisuMZ['ExtraEnemyDrops'][_0x14c3c7(0x30a)]<1.09){if(_0x14c3c7(0x46c)!==_0x14c3c7(0x514)){let _0x553c7d='';_0x553c7d+=_0x14c3c7(0x3b3),_0x553c7d+='in\x20order\x20for\x20VisuMZ_1_MessageCore\x20to\x20work.',alert(_0x553c7d),SceneManager[_0x14c3c7(0x48c)]();}else{_0x3355ba[_0x14c3c7(0x3f9)]['ParseArmorNotetags'][_0x14c3c7(0x323)](this,_0x2442d4);const _0x583f0b=_0x16d8c8['MessageCore'][_0x14c3c7(0x49b)]['AutoColor'];_0x49d6ba[_0x14c3c7(0x3f9)][_0x14c3c7(0x52b)](_0x31897e,_0x583f0b[_0x14c3c7(0x467)]);}}},VisuMZ['MessageCore'][_0x571fe1(0x352)]=function(_0x3795ea){const _0x4c606a=_0x571fe1,_0x5cddea=VisuMZ[_0x4c606a(0x3f9)][_0x4c606a(0x49b)][_0x3795ea];_0x5cddea[_0x4c606a(0x2b8)]((_0x42ec6d,_0x4303a0)=>{const _0x3f3ec5=_0x4c606a;if(!_0x42ec6d||!_0x4303a0)return-0x1;return _0x4303a0[_0x3f3ec5(0x3c8)][_0x3f3ec5(0x10a)]-_0x42ec6d[_0x3f3ec5(0x3c8)]['length'];});},Scene_Boot[_0x571fe1(0x252)][_0x571fe1(0xfd)]=function(){const _0x52b339=_0x571fe1;VisuMZ[_0x52b339(0x3f9)][_0x52b339(0x352)]('TextCodeActions');for(const _0x2e2aff of VisuMZ[_0x52b339(0x3f9)][_0x52b339(0x49b)][_0x52b339(0x203)]){_0x2e2aff['Match']=_0x2e2aff['Match'][_0x52b339(0x3b8)](),_0x2e2aff[_0x52b339(0x3c4)]=new RegExp('\x1b'+_0x2e2aff[_0x52b339(0x3c8)],'gi'),_0x2e2aff[_0x52b339(0x183)]='\x1b'+_0x2e2aff['Match'];if(_0x2e2aff['Type']==='')_0x2e2aff[_0x52b339(0x183)]+='[0]';}},Scene_Boot['prototype'][_0x571fe1(0x3fb)]=function(){const _0x104ac5=_0x571fe1;VisuMZ['MessageCore'][_0x104ac5(0x352)]('TextCodeReplace');for(const _0x26fab5 of VisuMZ[_0x104ac5(0x3f9)]['Settings'][_0x104ac5(0x368)]){if(_0x104ac5(0x20c)===_0x104ac5(0x20c))_0x26fab5[_0x104ac5(0x3c4)]=new RegExp('\x1b'+_0x26fab5[_0x104ac5(0x3c8)]+_0x26fab5[_0x104ac5(0x309)],'gi'),_0x26fab5['TextStr']!==''&&_0x26fab5[_0x104ac5(0x3af)]!==_0x104ac5(0x40f)?_0x104ac5(0x4d6)!=='pHmTX'?_0x26fab5[_0x104ac5(0x183)]=new Function(_0x104ac5(0x4c2)+_0x26fab5[_0x104ac5(0x3af)][_0x104ac5(0x3e9)](/\\/g,'\x1b')+'\x27'):(this[_0x104ac5(0x4b2)](_0x289bc0),_0x498af3['prototype'][_0x104ac5(0x40e)][_0x104ac5(0x323)](this,_0x41b89f)):_0x26fab5[_0x104ac5(0x183)]=_0x26fab5[_0x104ac5(0x235)];else{if(this[_0x104ac5(0x196)]===_0x1e0ead)this['clearAllPictureTexts']();const _0x26dbb7=this[_0x104ac5(0x3bf)](_0x25532f);this[_0x104ac5(0x12e)][_0x26dbb7]=_0x30f3b4[_0x104ac5(0x3f5)](0x0,_0x5d666d);}}},Scene_Boot[_0x571fe1(0x252)][_0x571fe1(0x4b4)]=function(){const _0x313124=_0x571fe1;for(const _0x594d0a of VisuMZ[_0x313124(0x3f9)][_0x313124(0x49b)][_0x313124(0x22f)]){_0x594d0a[_0x313124(0x3c4)]=new RegExp('\x5c['+_0x594d0a[_0x313124(0x3c8)]+'\x5c]','gi');if(_0x594d0a['TextStr']!==''&&_0x594d0a[_0x313124(0x3af)]!==_0x313124(0x40f)){if('nZVuH'!==_0x313124(0x147)){let _0xbeb9af=_0x594d0a[_0x313124(0x3af)];_0xbeb9af=_0xbeb9af[_0x313124(0x3e9)](/\\/g,'\x1b'),_0xbeb9af=_0xbeb9af[_0x313124(0x3e9)]('\x27','\x5c\x27'),_0xbeb9af=_0xbeb9af[_0x313124(0x3e9)]('\x22','\x5c\x22'),_0x594d0a[_0x313124(0x183)]=new Function('return\x20\x27'+_0xbeb9af+'\x27');}else{const _0x27d0d5=_0x50213c['itemBackColor1'](),_0x1f97f3=_0x9052ac[_0x313124(0x3ec)](),_0x596309=_0x322ffd??_0x255cce[_0x313124(0x24a)](),_0xba5847=_0x1ef067??_0x5e1068,_0xa6dded=_0x597d04['x'],_0x4b1abd=_0x408808['y'],_0x3f880d=_0x4e658f[_0x313124(0x481)],_0x54b665=_0x1e0504[_0x313124(0x3e0)];this['contentsBack'][_0x313124(0x28a)](_0xa6dded,_0x4b1abd,_0x3f880d,_0x54b665,_0x596309,_0xba5847,!![]),_0x5ad649&&this[_0x313124(0x518)][_0x313124(0x28a)](_0xa6dded,_0x4b1abd,_0x3f880d,_0x54b665,_0x27d0d5,_0xba5847,!![]),this[_0x313124(0x518)][_0x313124(0x1d1)](_0xa6dded,_0x4b1abd,_0x3f880d,_0x54b665,_0x27d0d5);}}else _0x594d0a[_0x313124(0x183)]=_0x594d0a['TextJS'];}},Scene_Boot['prototype'][_0x571fe1(0x117)]=function(){const _0x5889f3=_0x571fe1,_0xf77a1d=VisuMZ[_0x5889f3(0x3f9)][_0x5889f3(0x49b)][_0x5889f3(0x1c7)];!VisuMZ[_0x5889f3(0x338)]&&(VisuMZ['MessageCore'][_0x5889f3(0x15d)]($dataClasses,_0xf77a1d[_0x5889f3(0x13f)]),VisuMZ[_0x5889f3(0x3f9)][_0x5889f3(0x15d)]($dataSkills,_0xf77a1d[_0x5889f3(0x502)]),VisuMZ['MessageCore'][_0x5889f3(0x15d)]($dataItems,_0xf77a1d['Items']),VisuMZ[_0x5889f3(0x3f9)][_0x5889f3(0x15d)]($dataWeapons,_0xf77a1d[_0x5889f3(0x389)]),VisuMZ[_0x5889f3(0x3f9)][_0x5889f3(0x15d)]($dataArmors,_0xf77a1d[_0x5889f3(0x467)]),VisuMZ[_0x5889f3(0x3f9)]['AddAutoColor']($dataEnemies,_0xf77a1d['Enemies']),VisuMZ['MessageCore'][_0x5889f3(0x15d)]($dataStates,_0xf77a1d['States'])),VisuMZ[_0x5889f3(0x3f9)][_0x5889f3(0x217)]();},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2c0)]=['V','N','P','C','I','PX','PY','G','{','}','<','>','FS','\x5c','$','.','|','!','<','>','^',_0x571fe1(0x3c0),_0x571fe1(0x2ba),_0x571fe1(0x4ef),_0x571fe1(0x299),_0x571fe1(0x4de),'</LEFT>',_0x571fe1(0x248),'</CENTER>','<RIGHT>','</RIGHT>','<COLORLOCK>',_0x571fe1(0x289),_0x571fe1(0x363),')))',_0x571fe1(0x4be),'</WORDWRAP>','<BR>',_0x571fe1(0x313),_0x571fe1(0x4cc),_0x571fe1(0x348),_0x571fe1(0x16f),_0x571fe1(0x1f8),_0x571fe1(0x525),_0x571fe1(0x395),_0x571fe1(0x4e7),'DISABLE',_0x571fe1(0x4ae),_0x571fe1(0x379),_0x571fe1(0x3ed),_0x571fe1(0x39c)],VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x15d)]=function(_0x27e75c,_0x147940){const _0x77439d=_0x571fe1;if(_0x147940<=0x0)return;const _0x410d39=_0x27e75c;for(const _0x146c2b of _0x410d39){if(_0x77439d(0x21a)!=='aXdgn'){if(!_0x146c2b)continue;VisuMZ[_0x77439d(0x3f9)][_0x77439d(0x52b)](_0x146c2b,_0x147940);}else _0x2766e['x']-=_0x50e3ee[_0x77439d(0x12d)]/0x2;}},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x217)]=function(){const _0x4467a7=_0x571fe1;VisuMZ[_0x4467a7(0x3f9)][_0x4467a7(0x124)]=[];for(let _0x1668b5=0x1;_0x1668b5<=0x1f;_0x1668b5++){const _0x2736f3='TextColor%1'['format'](_0x1668b5),_0x4d0bfa=VisuMZ['MessageCore'][_0x4467a7(0x49b)][_0x4467a7(0x1c7)][_0x2736f3];_0x4d0bfa[_0x4467a7(0x2b8)]((_0x46f65c,_0x18e3ef)=>{const _0x382783=_0x4467a7;if(!_0x46f65c||!_0x18e3ef)return-0x1;return _0x18e3ef[_0x382783(0x10a)]-_0x46f65c[_0x382783(0x10a)];}),this[_0x4467a7(0x361)](_0x4d0bfa,_0x1668b5);}},VisuMZ['MessageCore'][_0x571fe1(0x361)]=function(_0x2418a5,_0x5365dc){const _0x5e3188=_0x571fe1;for(const _0x3071ba of _0x2418a5){if(_0x3071ba[_0x5e3188(0x10a)]<=0x0)continue;if(/^\d+$/[_0x5e3188(0x431)](_0x3071ba))continue;let _0x8d3b3=VisuMZ[_0x5e3188(0x3f9)][_0x5e3188(0x253)](_0x3071ba);if(_0x3071ba[_0x5e3188(0xf6)](/[\u3000-\u303F]|[\u3040-\u309F]|[\u30A0-\u30FF]|[\uFF00-\uFFEF]|[\u4E00-\u9FAF]|[\u2605-\u2606]|[\u2190-\u2195]|\u203B/g))var _0x186148=new RegExp(_0x8d3b3,'i');else var _0x186148=new RegExp('\x5cb'+_0x8d3b3+'\x5cb','g');VisuMZ[_0x5e3188(0x3f9)][_0x5e3188(0x124)][_0x5e3188(0x491)]([_0x186148,'\x1bC[%1]%2\x1bPREVCOLOR[0]'[_0x5e3188(0x3dd)](_0x5365dc,_0x3071ba)]);}},VisuMZ['MessageCore'][_0x571fe1(0x253)]=function(_0x3b3bc8){const _0x3183c6=_0x571fe1;return _0x3b3bc8=_0x3b3bc8[_0x3183c6(0x3e9)](/(\W)/gi,(_0x39a51d,_0x3e6f59)=>_0x3183c6(0x14b)['format'](_0x3e6f59)),_0x3b3bc8;},VisuMZ[_0x571fe1(0x3f9)]['ParseClassNotetags']=VisuMZ['ParseClassNotetags'],VisuMZ[_0x571fe1(0x463)]=function(_0x45653e){const _0x501b2c=_0x571fe1;VisuMZ[_0x501b2c(0x3f9)][_0x501b2c(0x463)]['call'](this,_0x45653e);const _0x33699f=VisuMZ[_0x501b2c(0x3f9)]['Settings'][_0x501b2c(0x1c7)];VisuMZ[_0x501b2c(0x3f9)][_0x501b2c(0x52b)](_0x45653e,_0x33699f['Classes']);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x359)]=VisuMZ[_0x571fe1(0x359)],VisuMZ[_0x571fe1(0x359)]=function(_0xc4af32){const _0x5506ed=_0x571fe1;VisuMZ[_0x5506ed(0x3f9)][_0x5506ed(0x359)]['call'](this,_0xc4af32);const _0x5e4fd7=VisuMZ['MessageCore'][_0x5506ed(0x49b)][_0x5506ed(0x1c7)];VisuMZ[_0x5506ed(0x3f9)][_0x5506ed(0x52b)](_0xc4af32,_0x5e4fd7[_0x5506ed(0x502)]);},0x7,VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2c8)]=VisuMZ['ParseItemNotetags'],VisuMZ['ParseItemNotetags']=function(_0x13a9ef){const _0x2c5e37=_0x571fe1;VisuMZ[_0x2c5e37(0x3f9)][_0x2c5e37(0x2c8)][_0x2c5e37(0x323)](this,_0x13a9ef);const _0xc3b733=VisuMZ[_0x2c5e37(0x3f9)][_0x2c5e37(0x49b)][_0x2c5e37(0x1c7)];VisuMZ[_0x2c5e37(0x3f9)][_0x2c5e37(0x52b)](_0x13a9ef,_0xc3b733[_0x2c5e37(0x50c)]);},VisuMZ[_0x571fe1(0x3f9)]['ParseWeaponNotetags']=VisuMZ[_0x571fe1(0x1b8)],VisuMZ['ParseWeaponNotetags']=function(_0xaf4f3c){const _0x244bd6=_0x571fe1;VisuMZ[_0x244bd6(0x3f9)]['ParseWeaponNotetags']['call'](this,_0xaf4f3c);const _0x42b62d=VisuMZ[_0x244bd6(0x3f9)][_0x244bd6(0x49b)][_0x244bd6(0x1c7)];VisuMZ[_0x244bd6(0x3f9)]['CreateAutoColorFor'](_0xaf4f3c,_0x42b62d[_0x244bd6(0x389)]);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x33b)]=VisuMZ[_0x571fe1(0x33b)],VisuMZ[_0x571fe1(0x33b)]=function(_0x269846){const _0x3d0abe=_0x571fe1;VisuMZ['MessageCore']['ParseArmorNotetags'][_0x3d0abe(0x323)](this,_0x269846);const _0x4e8501=VisuMZ[_0x3d0abe(0x3f9)]['Settings'][_0x3d0abe(0x1c7)];VisuMZ['MessageCore'][_0x3d0abe(0x52b)](_0x269846,_0x4e8501[_0x3d0abe(0x467)]);},VisuMZ['MessageCore'][_0x571fe1(0x241)]=VisuMZ[_0x571fe1(0x241)],VisuMZ['ParseEnemyNotetags']=function(_0x48b32e){const _0x2c4ee3=_0x571fe1;VisuMZ[_0x2c4ee3(0x3f9)][_0x2c4ee3(0x241)][_0x2c4ee3(0x323)](this,_0x48b32e);const _0x18c560=VisuMZ[_0x2c4ee3(0x3f9)]['Settings'][_0x2c4ee3(0x1c7)];VisuMZ[_0x2c4ee3(0x3f9)][_0x2c4ee3(0x52b)](_0x48b32e,_0x18c560['Enemies']);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x1ec)]=VisuMZ[_0x571fe1(0x1ec)],VisuMZ['ParseStateNotetags']=function(_0x93b3c2){const _0x249a53=_0x571fe1;VisuMZ[_0x249a53(0x3f9)][_0x249a53(0x1ec)]['call'](this,_0x93b3c2);const _0x58434e=VisuMZ[_0x249a53(0x3f9)][_0x249a53(0x49b)][_0x249a53(0x1c7)];VisuMZ[_0x249a53(0x3f9)]['CreateAutoColorFor'](_0x93b3c2,_0x58434e[_0x249a53(0xf4)]);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x52b)]=function(_0x22f365,_0x33b060){const _0x2603f5=_0x571fe1;if(_0x33b060<=0x0)return;const _0x34e108=VisuMZ[_0x2603f5(0x3f9)][_0x2603f5(0x49b)][_0x2603f5(0x1c7)][_0x2603f5(0x20f)+_0x33b060];let _0x121ab8=_0x22f365[_0x2603f5(0x2cd)][_0x2603f5(0x2a1)]();if(/^\d+$/['test'](_0x121ab8))return;if(VisuMZ[_0x2603f5(0x3f9)]['AutoColorBypassList'][_0x2603f5(0x297)](_0x121ab8[_0x2603f5(0x3b8)]()))return;_0x121ab8=_0x121ab8[_0x2603f5(0x3e9)](/\\I\[(\d+)\]/gi,''),_0x121ab8=_0x121ab8[_0x2603f5(0x3e9)](/\x1bI\[(\d+)\]/gi,'');if(_0x121ab8[_0x2603f5(0x10a)]<=0x0)return;if(_0x121ab8[_0x2603f5(0xf6)](/-----/i))return;_0x34e108[_0x2603f5(0x491)](_0x121ab8);},VisuMZ['MessageCore'][_0x571fe1(0x3f6)]=Scene_Boot[_0x571fe1(0x252)][_0x571fe1(0x370)],Scene_Boot[_0x571fe1(0x252)][_0x571fe1(0x370)]=function(){const _0xa0edf5=_0x571fe1;VisuMZ[_0xa0edf5(0x3f9)][_0xa0edf5(0x3f6)][_0xa0edf5(0x323)](this),this[_0xa0edf5(0x280)]();},Scene_Boot[_0x571fe1(0x252)][_0x571fe1(0x280)]=function(){const _0x4a1d3e=_0x571fe1,_0x42865a=VisuMZ[_0x4a1d3e(0x3f9)][_0x4a1d3e(0x49b)]['CustomFonts']||[];for(const _0x5ad8ce of _0x42865a){if(_0x4a1d3e(0x233)===_0x4a1d3e(0x26e))return 0x0;else{if(!_0x5ad8ce)continue;const _0x4b265a=_0x5ad8ce[_0x4a1d3e(0x529)];if(_0x4b265a['trim']()==='')continue;if(_0x4b265a[_0x4a1d3e(0x366)]()[_0x4a1d3e(0x2a1)]()===_0x4a1d3e(0x399))continue;const _0x251cc5=_0x5ad8ce['Filename'];if(_0x251cc5===_0x4a1d3e(0x375))continue;FontManager[_0x4a1d3e(0x3d4)](_0x4b265a,_0x251cc5);}}},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x517)]=DataManager[_0x571fe1(0x154)],DataManager[_0x571fe1(0x154)]=function(){const _0x645ce=_0x571fe1;VisuMZ[_0x645ce(0x3f9)]['DataManager_loadDatabase'][_0x645ce(0x323)](this),this[_0x645ce(0x2ac)]();},DataManager[_0x571fe1(0x2ac)]=function(){const _0x59b135=_0x571fe1;if(!TextManager[_0x59b135(0x3e5)]())return;const _0x33c6ab=VisuMZ[_0x59b135(0x3f9)][_0x59b135(0x49b)]['Localization'],_0x107cea=_0x33c6ab['CsvFilename']||'';if(!_0x107cea)return;const _0x1a6764=_0x59b135(0x272),_0x544996=new XMLHttpRequest(),_0x302c7d=_0x59b135(0x10f)+_0x107cea;window[_0x1a6764]=null,_0x544996['open'](_0x59b135(0x1e5),_0x302c7d),_0x544996[_0x59b135(0x391)](_0x59b135(0x2b9)),_0x544996[_0x59b135(0x3de)]=()=>this[_0x59b135(0x327)](_0x544996,_0x1a6764),_0x544996['onerror']=()=>this[_0x59b135(0x35d)](),_0x544996['send']();},DataManager[_0x571fe1(0x327)]=function(_0x408454,_0xec0be2){const _0x4f4556=_0x571fe1;if(_0x408454['status']>=0x190)return;const _0x1c2e0e=_0x408454[_0x4f4556(0x13c)];window[_0xec0be2]=VisuMZ['MessageCore']['ParseLocalizationCsv'](_0x1c2e0e);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x421)]=function(_0x108f37){const _0x366a74=_0x571fe1,_0x4723b8=_0x108f37['split']('\x0a'),_0x376df1=_0x4723b8[0x0]['split'](';'),_0x5caf49={};return _0x4723b8['slice'](0x1)[_0x366a74(0x1fe)](_0xa500aa=>{const _0x5d8d71=_0x366a74;if('jODFj'===_0x5d8d71(0x408)){let _0xc481c=[],_0x3a323f='',_0x183fb9=![];for(let _0x13a4c5=0x0;_0x13a4c5<_0xa500aa[_0x5d8d71(0x10a)];_0x13a4c5++){if('PjrJt'==='PjrJt'){let _0x56be68=_0xa500aa[_0x13a4c5];if(_0x56be68==='\x22')_0x183fb9&&_0xa500aa[_0x13a4c5+0x1]==='\x22'?'DKxMo'!==_0x5d8d71(0x2f5)?(_0x56853e=this['processStoredAutoColorChanges'](_0x30419e),_0x3a0a1b=this[_0x5d8d71(0x1fa)](_0x14ba0e)):(_0x3a323f+=_0x56be68,_0x13a4c5++):_0x5d8d71(0x208)!==_0x5d8d71(0x208)?this['_pictureTextRefresh'][_0x5d8d71(0x491)](_0x2b727f):_0x183fb9=!_0x183fb9;else{if(_0x56be68===';'&&!_0x183fb9){if(_0x5d8d71(0x192)!==_0x5d8d71(0x2d7))_0xc481c[_0x5d8d71(0x491)](_0x3a323f),_0x3a323f='';else return this[_0x5d8d71(0x132)];}else _0x3a323f+=_0x56be68;}}else{const _0x176550=_0x2a8047>=0x1?_0x5a01ac['members']()[_0x1765aa-0x1]:null,_0x510910=_0x176550?_0x176550[_0x5d8d71(0x2cd)]():'',_0x47ca24=_0x11291c(_0x135a0a[_0x5d8d71(0x3f9)][_0x5d8d71(0x49b)][_0x5d8d71(0x1c7)][_0x5d8d71(0x21e)]);return this[_0x5d8d71(0x34d)]()&&_0x47ca24!==0x0?_0x5d8d71(0x1c1)[_0x5d8d71(0x3dd)](_0x47ca24,_0x510910):_0x510910;}}if(_0x3a323f)_0xc481c['push'](_0x3a323f);const _0x58321c=_0xc481c[0x0][_0x5d8d71(0x3e9)](/^"|"$/g,'')[_0x5d8d71(0x366)]()['trim']();_0x5caf49[_0x58321c]=_0x376df1[_0x5d8d71(0x13a)](0x1)[_0x5d8d71(0x237)]((_0x568f7e,_0xe2b9a1,_0x34d12b)=>{const _0x6a8118=_0x5d8d71;return _0x568f7e[_0xe2b9a1]=(_0xc481c[_0x34d12b+0x1]||'')[_0x6a8118(0x3e9)](/^"|"$/g,''),_0x568f7e;},{});}else{if(this[_0x5d8d71(0x201)]===_0x46f8c3)this[_0x5d8d71(0x305)]();this[_0x5d8d71(0x201)][_0x5d8d71(0x2a6)]=_0x180fe6||0x0;}}),_0x5caf49;},DataManager[_0x571fe1(0x35d)]=function(){const _0x3e6766=_0x571fe1;let _0x460f45='';_0x460f45+='You\x20do\x20not\x20have\x20a\x20language\x20CSV\x20set\x20up.\x0a',_0x460f45+=_0x3e6766(0x427),confirm(_0x460f45)?Utils['isOptionValid'](_0x3e6766(0x431))?(_0x460f45=_0x3e6766(0x263),alert(_0x460f45),this['createLocalizationCsvFile'](),this[_0x3e6766(0x172)](),_0x460f45=''):_0x460f45=_0x3e6766(0x11e):_0x3e6766(0x229)!=='lcvCX'?(_0x1b01bd=this[_0x3e6766(0x178)](),_0x45e8c3[_0x3e6766(0x3f9)]['Game_Interpreter_setupChoices']['call'](this,_0x2ea1c3),_0x1c1007['setupShuffleChoices']()):_0x460f45=_0x3e6766(0x296),_0x460f45+='Please\x20restart\x20the\x20game.',alert(_0x460f45),SceneManager[_0x3e6766(0x48c)]();},DataManager[_0x571fe1(0x4da)]=function(){const _0x48c384=_0x571fe1,_0x122d13=[_0x48c384(0x4f0),_0x48c384(0x2b3),'Bengali',_0x48c384(0x1f3),_0x48c384(0x170),_0x48c384(0x2e5),_0x48c384(0x146),'Dutch','Finnish','French',_0x48c384(0x13e),_0x48c384(0x1e9),_0x48c384(0x4e5),_0x48c384(0x2f8),_0x48c384(0x4eb),_0x48c384(0x10c),'Japanese',_0x48c384(0x4c8),_0x48c384(0x51a),_0x48c384(0x116),_0x48c384(0x4a0),_0x48c384(0x168),'Russian',_0x48c384(0x32a),_0x48c384(0x104),'Swedish','Tamil',_0x48c384(0x4aa),'Turkish'],_0x2a7bfa=[_0x48c384(0x11d),_0x48c384(0x460),_0x48c384(0x4d8),'你好','你好','Ahoj','Hej',_0x48c384(0x387),'Hei',_0x48c384(0xf9),_0x48c384(0x387),_0x48c384(0x3aa),_0x48c384(0x412),_0x48c384(0x159),_0x48c384(0x24b),'Ciao',_0x48c384(0x37c),_0x48c384(0x426),_0x48c384(0x4e9),_0x48c384(0x238),'Olá',_0x48c384(0x274),_0x48c384(0x528),_0x48c384(0x3f7),_0x48c384(0x16e),_0x48c384(0x1f9),_0x48c384(0x2dc),'สวัสดี',_0x48c384(0x434)],_0x33e635=[_0x48c384(0x189),_0x48c384(0x453),_0x48c384(0x15c),'再见','再見','Sbohem',_0x48c384(0x18d),'Tot\x20ziens',_0x48c384(0x1f5),'Au\x20revoir',_0x48c384(0x157),_0x48c384(0x223),_0x48c384(0x191),'Viszontlátásra',_0x48c384(0x1e3),_0x48c384(0x1c0),_0x48c384(0x1e2),_0x48c384(0x307),_0x48c384(0x30c),_0x48c384(0x2f7),_0x48c384(0x294),'La\x20revedere','До\x20свидания',_0x48c384(0x396),_0x48c384(0x3e2),_0x48c384(0x1cf),_0x48c384(0x1cc),'ลาก่อน',_0x48c384(0xd7)],_0x434691=[_0x48c384(0x204),_0x48c384(0x204),_0x48c384(0x3c6),'哇','哇','Ó',_0x48c384(0x204),_0x48c384(0x16c),_0x48c384(0x4ee),_0x48c384(0x45f),_0x48c384(0x204),_0x48c384(0x3da),'वाह',_0x48c384(0x2a0),_0x48c384(0x18c),_0x48c384(0x204),'ワオ','와우','Oi','O',_0x48c384(0x3ad),_0x48c384(0x3ad),_0x48c384(0x4f8),'Ó','Guau','Oj',_0x48c384(0x4ac),_0x48c384(0x22b),_0x48c384(0x160)],_0x36a968=[_0x122d13,_0x2a7bfa,_0x33e635,_0x434691],_0x5339e7=_0x36a968['map'](_0x6c2832=>_0x6c2832[_0x48c384(0x369)](';'))[_0x48c384(0x369)]('\x0a'),_0xf46643=VisuMZ[_0x48c384(0x3f9)]['Settings'][_0x48c384(0x496)],_0x1d78d1=_0xf46643[_0x48c384(0x277)]||_0x48c384(0x48e),_0x54f619=require(_0x48c384(0x137)),_0x4afdf4=_0x54f619[_0x48c384(0x1a8)](process[_0x48c384(0x293)][_0x48c384(0x4b1)]),_0x443e9c=_0x54f619[_0x48c384(0x369)](_0x4afdf4,'data/'),_0x1fbcb4=_0x443e9c+_0x1d78d1,_0xef551d=require('fs');return _0xef551d[_0x48c384(0x35b)](_0x1fbcb4,_0x5339e7),_0x1fbcb4;},DataManager[_0x571fe1(0x172)]=function(){const _0x5a6483=_0x571fe1,{exec:_0x419b0f}=require(_0x5a6483(0x4e6));_0x419b0f(_0x5a6483(0x1d5)),_0x419b0f(_0x5a6483(0x347));},SceneManager[_0x571fe1(0x207)]=function(){const _0x58c5b0=_0x571fe1;return this[_0x58c5b0(0x45c)]&&this[_0x58c5b0(0x45c)][_0x58c5b0(0x524)]===Scene_Battle;},SceneManager[_0x571fe1(0x240)]=function(){const _0x369ba3=_0x571fe1;return this[_0x369ba3(0x45c)]&&this['_scene'][_0x369ba3(0x524)]===Scene_Map;},ConfigManager[_0x571fe1(0x211)]=VisuMZ[_0x571fe1(0x3f9)]['Settings'][_0x571fe1(0x496)][_0x571fe1(0x167)]||_0x571fe1(0x2b3),ConfigManager[_0x571fe1(0x28b)]=VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x49b)][_0x571fe1(0x31c)][_0x571fe1(0x43f)],VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x477)]=ConfigManager[_0x571fe1(0x113)],ConfigManager[_0x571fe1(0x113)]=function(){const _0x5c1ce8=_0x571fe1,_0x59738d=VisuMZ[_0x5c1ce8(0x3f9)][_0x5c1ce8(0x477)]['call'](this);return TextManager[_0x5c1ce8(0x3e5)]()&&(_0x59738d[_0x5c1ce8(0x211)]=this[_0x5c1ce8(0x211)]),_0x59738d[_0x5c1ce8(0x28b)]=this['textSpeed'],_0x59738d;},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x121)]=ConfigManager[_0x571fe1(0x446)],ConfigManager[_0x571fe1(0x446)]=function(_0x1504f6){const _0x434275=_0x571fe1;VisuMZ['MessageCore'][_0x434275(0x121)][_0x434275(0x323)](this,_0x1504f6),TextManager[_0x434275(0x3e5)]()&&(_0x434275(0x1a2)===_0x434275(0x1a2)?'textLocale'in _0x1504f6?this[_0x434275(0x211)]=String(_0x1504f6[_0x434275(0x211)]):this[_0x434275(0x211)]=VisuMZ[_0x434275(0x3f9)][_0x434275(0x49b)][_0x434275(0x496)][_0x434275(0x167)]||_0x434275(0x2b3):(_0x11945f=_0x4a6dae[_0x434275(0x366)]()[_0x434275(0x2a1)](),this['getPictureTextData'](_0x5f344f)[_0x382687]=_0x54c17a||'',this[_0x434275(0x498)](_0x1bab51,!![]))),_0x434275(0x28b)in _0x1504f6?'BHeMG'===_0x434275(0x29f)?this[_0x434275(0x30b)](_0x2fd941):this[_0x434275(0x28b)]=Number(_0x1504f6['textSpeed'])[_0x434275(0x374)](0x1,0xb):'untrR'===_0x434275(0x295)?(_0x4661ac[_0x434275(0x3f9)][_0x434275(0x215)][_0x434275(0x323)](this),this[_0x434275(0x123)]()):this[_0x434275(0x28b)]=VisuMZ[_0x434275(0x3f9)]['Settings'][_0x434275(0x31c)][_0x434275(0x43f)];},TextManager['messageCoreLocalization']=VisuMZ['MessageCore']['Settings']['Localization'][_0x571fe1(0x334)],TextManager['messageCoreTextSpeed']=VisuMZ[_0x571fe1(0x3f9)]['Settings'][_0x571fe1(0x31c)][_0x571fe1(0x334)],TextManager[_0x571fe1(0x425)]=VisuMZ[_0x571fe1(0x3f9)]['Settings'][_0x571fe1(0x31c)][_0x571fe1(0x39e)],VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2bb)]=TextManager[_0x571fe1(0x3b5)],TextManager[_0x571fe1(0x3b5)]=function(_0x5e04c5){const _0x158f4b=_0x571fe1,_0x2e1218=['levelUp','emerge',_0x158f4b(0x2d3),_0x158f4b(0x52a),_0x158f4b(0x3cf),_0x158f4b(0x4f1),_0x158f4b(0x2f6),_0x158f4b(0x1cd),_0x158f4b(0x2e7),_0x158f4b(0x1fc)];let _0x5f4d88=VisuMZ[_0x158f4b(0x3f9)][_0x158f4b(0x2bb)][_0x158f4b(0x323)](this,_0x5e04c5);return _0x2e1218[_0x158f4b(0x297)](_0x5e04c5)&&(_0x5f4d88='</WORDWRAP>'+_0x5f4d88),_0x5f4d88;},TextManager['isVisuMzLocalizationEnabled']=function(){const _0x3610cb=_0x571fe1;return VisuMZ['MessageCore'][_0x3610cb(0x49b)][_0x3610cb(0x496)][_0x3610cb(0x2c6)];},TextManager['parseLocalizedText']=function(_0x3f1c1a){const _0x3edf64=_0x571fe1;if(!this[_0x3edf64(0x3e5)]())return _0x3f1c1a;return _0x3f1c1a=String(_0x3f1c1a)[_0x3edf64(0x3e9)](/\$(?:\[|\<|\{)(.*?)(?:\]|\>|\})/gi,(_0x413a72,_0x1c6a33)=>this[_0x3edf64(0x282)](String(_0x1c6a33))),_0x3f1c1a=String(_0x3f1c1a)['replace'](/\\(?:KEY|TL|TRANSLATE|LOC|LOCALIZE|LOCALE)(?:\[|\<|\{)(.*?)(?:\]|\>|\})/gi,(_0x28894e,_0x12ce99)=>this[_0x3edf64(0x282)](String(_0x12ce99))),_0x3f1c1a=String(_0x3f1c1a)[_0x3edf64(0x3e9)](/\x1b(?:KEY|TL|TRANSLATE|LOC|LOCALIZE|LOCALE)(?:\[|\<|\{)(.*?)(?:\]|\>|\})/gi,(_0x460466,_0x44bf7e)=>this[_0x3edf64(0x282)](String(_0x44bf7e))),_0x3f1c1a;},TextManager[_0x571fe1(0x282)]=function(_0x1bf19b){const _0x2e3f03=_0x571fe1;if(!$dataLocalization)return'';const _0x3574a3=$dataLocalization[_0x1bf19b['toLowerCase']()[_0x2e3f03(0x2a1)]()];if(!_0x3574a3)return;const _0x3ae049=ConfigManager[_0x2e3f03(0x211)]||_0x2e3f03(0x2b3);let _0x4e0bc9=_0x3574a3[_0x3ae049]||_0x2e3f03(0x1e6);return _0x4e0bc9=_0x4e0bc9[_0x2e3f03(0x3e9)](/\\/g,'\x1b'),_0x4e0bc9=_0x4e0bc9[_0x2e3f03(0x3e9)](/<SEMI(?:|-COLON|COLON)>/gi,';'),_0x4e0bc9;},TextManager[_0x571fe1(0x3f0)]=function(_0x4772c1){const _0x35deb8=_0x571fe1;return VisuMZ[_0x35deb8(0x3f9)][_0x35deb8(0x49b)]['Localization'][_0x4772c1]||'';},TextManager[_0x571fe1(0x4b0)]=function(){const _0x43db2f=_0x571fe1,_0x3c484b=ConfigManager[_0x43db2f(0x211)]||_0x43db2f(0x2b3);return this[_0x43db2f(0x3f0)](_0x3c484b);},TextManager[_0x571fe1(0x286)]=function(_0x204ca2){const _0x366a78=_0x571fe1,_0x1bfaf1=VisuMZ[_0x366a78(0x3f9)][_0x366a78(0x49b)][_0x366a78(0x496)][_0x366a78(0x25d)]||[];let _0x4961ca=_0x1bfaf1['indexOf'](ConfigManager[_0x366a78(0x211)]||_0x366a78(0x2b3));_0x4961ca+=_0x204ca2;const _0x343e03=_0x1bfaf1[_0x4961ca]||'';return this['getLanguageName'](_0x343e03);},Game_Temp[_0x571fe1(0x252)]['setLastPluginCommandInterpreter']=function(_0x118e93){const _0x577cd5=_0x571fe1;this[_0x577cd5(0x132)]=_0x118e93;},Game_Temp['prototype'][_0x571fe1(0x31a)]=function(){const _0x5ddc06=_0x571fe1;return this[_0x5ddc06(0x132)];},VisuMZ['MessageCore'][_0x571fe1(0x262)]=Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x3b4)],Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x3b4)]=function(_0x472663){const _0x5e181c=_0x571fe1;return $gameTemp[_0x5e181c(0x179)](this),VisuMZ['MessageCore']['Game_Interpreter_PluginCommand'][_0x5e181c(0x323)](this,_0x472663);},VisuMZ['MessageCore'][_0x571fe1(0x22d)]=Game_System[_0x571fe1(0x252)][_0x571fe1(0x49f)],Game_System['prototype'][_0x571fe1(0x49f)]=function(){const _0x13c027=_0x571fe1;VisuMZ[_0x13c027(0x3f9)]['Game_System_initialize']['call'](this),this[_0x13c027(0x305)]();},Game_System[_0x571fe1(0x252)]['initMessageCore']=function(){const _0x4f127c=_0x571fe1,_0xd5487=VisuMZ[_0x4f127c(0x3f9)][_0x4f127c(0x49b)][_0x4f127c(0x35f)],_0x2dea5c=VisuMZ['MessageCore']['Settings'][_0x4f127c(0x2c2)];this[_0x4f127c(0x201)]={'messageRows':_0xd5487[_0x4f127c(0x2a5)],'messageWidth':_0xd5487['MessageWidth'],'messageWordWrap':_0x2dea5c['MessageWindow'],'helpWordWrap':_0x2dea5c[_0x4f127c(0x452)],'choiceLineHeight':_0xd5487['ChoiceWindowLineHeight'],'choiceMinWidth':_0xd5487[_0x4f127c(0x218)]??0x60,'choiceRows':_0xd5487[_0x4f127c(0x27e)],'choiceCols':_0xd5487[_0x4f127c(0x134)],'choiceTextAlign':_0xd5487[_0x4f127c(0x1a4)],'choiceDistance':0x0};if(this['_messageOffsetX']===undefined){if('AkggI'!==_0x4f127c(0xea))this[_0x4f127c(0x49a)]=_0xd5487[_0x4f127c(0x304)],this[_0x4f127c(0x2a4)]=_0xd5487[_0x4f127c(0x50b)];else{const _0x4802aa=_0x476fab[_0x4f127c(0x3f9)]['Settings'][_0x4f127c(0x496)][_0x4f127c(0x25d)]||[];let _0x4dee6a=_0x4802aa['indexOf'](_0x18ec87[_0x4f127c(0x211)]||_0x4f127c(0x2b3));_0x4dee6a+=_0x5270d1;const _0x414546=_0x4802aa[_0x4dee6a]||'';return this[_0x4f127c(0x3f0)](_0x414546);}}},Game_System[_0x571fe1(0x252)][_0x571fe1(0x11a)]=function(){const _0x83e1c4=_0x571fe1;if(this[_0x83e1c4(0x201)]===undefined)this['initMessageCore']();if(this['_MessageCoreSettings'][_0x83e1c4(0x288)]===undefined)this['initMessageCore']();return this[_0x83e1c4(0x201)][_0x83e1c4(0x288)];},Game_System[_0x571fe1(0x252)][_0x571fe1(0x1db)]=function(_0x42430c){const _0x2fc1a1=_0x571fe1;if(this['_MessageCoreSettings']===undefined)this[_0x2fc1a1(0x305)]();if(this[_0x2fc1a1(0x201)][_0x2fc1a1(0x288)]===undefined)this['initMessageCore']();this['_MessageCoreSettings'][_0x2fc1a1(0x288)]=_0x42430c||0x1;},Game_System[_0x571fe1(0x252)][_0x571fe1(0xfb)]=function(){const _0x48f61f=_0x571fe1;if(this[_0x48f61f(0x201)]===undefined)this[_0x48f61f(0x305)]();if(this[_0x48f61f(0x201)][_0x48f61f(0x331)]===undefined)this['initMessageCore']();return this['_MessageCoreSettings'][_0x48f61f(0x331)];},Game_System[_0x571fe1(0x252)][_0x571fe1(0x507)]=function(_0x26d891){const _0x34019a=_0x571fe1;if(this[_0x34019a(0x201)]===undefined)this[_0x34019a(0x305)]();if(this[_0x34019a(0x201)]['messageWidth']===undefined)this[_0x34019a(0x305)]();_0x26d891=Math[_0x34019a(0x17b)](_0x26d891);if(_0x26d891%0x2!==0x0)_0x26d891+=0x1;this['_MessageCoreSettings'][_0x34019a(0x331)]=_0x26d891||0x2;},Game_System[_0x571fe1(0x252)]['isMessageWindowWordWrap']=function(){const _0x1c4385=_0x571fe1;if(this[_0x1c4385(0x201)]===undefined)this[_0x1c4385(0x305)]();if(this[_0x1c4385(0x201)][_0x1c4385(0x33f)]===undefined)this[_0x1c4385(0x305)]();return this['_MessageCoreSettings'][_0x1c4385(0x33f)];},Game_System[_0x571fe1(0x252)][_0x571fe1(0x462)]=function(_0x56eaef){const _0x5c63be=_0x571fe1;if(this[_0x5c63be(0x201)]===undefined)this[_0x5c63be(0x305)]();if(this[_0x5c63be(0x201)][_0x5c63be(0x33f)]===undefined)this['initMessageCore']();this['_MessageCoreSettings'][_0x5c63be(0x33f)]=_0x56eaef;},Game_System[_0x571fe1(0x252)]['getMessageWindowXyOffsets']=function(){const _0x3b06f1=_0x571fe1;if(this['_messageOffsetX']===undefined){if(_0x3b06f1(0x184)!==_0x3b06f1(0xfc)){const _0x20e1bd=VisuMZ[_0x3b06f1(0x3f9)]['Settings']['General'];this[_0x3b06f1(0x49a)]=_0x20e1bd[_0x3b06f1(0x304)],this[_0x3b06f1(0x2a4)]=_0x20e1bd['MsgWindowOffsetY'];}else _0x5d246a[_0x3b06f1(0x3f9)][_0x3b06f1(0x515)][_0x3b06f1(0x323)](this),this[_0x3b06f1(0x22c)](),this[_0x3b06f1(0x3c2)](),this[_0x3b06f1(0x3e8)](![]),this['setTextAlignment'](_0x3b06f1(0x2ed)),this[_0x3b06f1(0x442)](_0x10d192['MessageCore'][_0x3b06f1(0x49b)]['General'][_0x3b06f1(0x499)]);}return{'x':this[_0x3b06f1(0x49a)]||0x0,'y':this[_0x3b06f1(0x2a4)]||0x0};},Game_System['prototype'][_0x571fe1(0x112)]=function(_0x31249e,_0x271e6f){const _0x10aa7f=_0x571fe1;if(this[_0x10aa7f(0x201)]===undefined)this['initMessageCore']();this[_0x10aa7f(0x49a)]=_0x31249e,this['_messageOffsetY']=_0x271e6f;},Game_System[_0x571fe1(0x252)][_0x571fe1(0x336)]=function(){const _0x3e4d1a=_0x571fe1;if(this[_0x3e4d1a(0x201)]===undefined)this[_0x3e4d1a(0x305)]();if(this[_0x3e4d1a(0x201)]['helpWordWrap']===undefined)this['initMessageCore']();return this[_0x3e4d1a(0x201)][_0x3e4d1a(0x4dc)];},Game_System[_0x571fe1(0x252)][_0x571fe1(0x214)]=function(_0x361508){const _0x2638df=_0x571fe1;if(this[_0x2638df(0x201)]===undefined)this[_0x2638df(0x305)]();if(this[_0x2638df(0x201)][_0x2638df(0x4dc)]===undefined)this[_0x2638df(0x305)]();this['_MessageCoreSettings'][_0x2638df(0x4dc)]=_0x361508;},Game_System[_0x571fe1(0x252)]['getChoiceListLineHeight']=function(){const _0x1f2c04=_0x571fe1;if(this[_0x1f2c04(0x201)]===undefined)this['initMessageCore']();if(this[_0x1f2c04(0x201)]['choiceLineHeight']===undefined)this[_0x1f2c04(0x305)]();return this['_MessageCoreSettings'][_0x1f2c04(0x174)];},Game_System[_0x571fe1(0x252)]['setChoiceListLineHeight']=function(_0x368078){const _0xa84e37=_0x571fe1;if(this[_0xa84e37(0x201)]===undefined)this[_0xa84e37(0x305)]();if(this[_0xa84e37(0x201)]['choiceLineHeight']===undefined)this[_0xa84e37(0x305)]();this[_0xa84e37(0x201)][_0xa84e37(0x174)]=_0x368078||0x1;},Game_System[_0x571fe1(0x252)][_0x571fe1(0x2c9)]=function(){const _0x2eb87f=_0x571fe1;if(this[_0x2eb87f(0x201)]===undefined)this[_0x2eb87f(0x305)]();return this[_0x2eb87f(0x201)][_0x2eb87f(0x34f)]??0x60;},Game_System[_0x571fe1(0x252)][_0x571fe1(0x39f)]=function(_0x342621){const _0x3caf73=_0x571fe1;if(this[_0x3caf73(0x201)]===undefined)this[_0x3caf73(0x305)]();this[_0x3caf73(0x201)][_0x3caf73(0x34f)]=_0x342621||0x0;},Game_System['prototype'][_0x571fe1(0x1dc)]=function(){const _0x3e4259=_0x571fe1;if(this[_0x3e4259(0x201)]===undefined)this[_0x3e4259(0x305)]();if(this['_MessageCoreSettings']['choiceRows']===undefined)this[_0x3e4259(0x305)]();return this[_0x3e4259(0x201)][_0x3e4259(0x213)];},Game_System[_0x571fe1(0x252)][_0x571fe1(0xd2)]=function(_0x22e5d6){const _0x2ecdca=_0x571fe1;if(this[_0x2ecdca(0x201)]===undefined)this[_0x2ecdca(0x305)]();if(this[_0x2ecdca(0x201)][_0x2ecdca(0x213)]===undefined)this[_0x2ecdca(0x305)]();this['_MessageCoreSettings'][_0x2ecdca(0x213)]=_0x22e5d6||0x1;},Game_System[_0x571fe1(0x252)][_0x571fe1(0x2a2)]=function(){const _0x102848=_0x571fe1;if(this[_0x102848(0x201)]===undefined)this[_0x102848(0x305)]();if(this[_0x102848(0x201)][_0x102848(0x32f)]===undefined)this[_0x102848(0x305)]();return this['_MessageCoreSettings'][_0x102848(0x32f)];},Game_System[_0x571fe1(0x252)][_0x571fe1(0x11f)]=function(_0x2620d4){const _0x4c957d=_0x571fe1;if(this['_MessageCoreSettings']===undefined)this[_0x4c957d(0x305)]();if(this[_0x4c957d(0x201)][_0x4c957d(0x32f)]===undefined)this[_0x4c957d(0x305)]();this[_0x4c957d(0x201)][_0x4c957d(0x32f)]=_0x2620d4||0x1;},Game_System['prototype'][_0x571fe1(0x279)]=function(){const _0x48fcc3=_0x571fe1;if(this['_MessageCoreSettings']===undefined)this[_0x48fcc3(0x305)]();if(this[_0x48fcc3(0x201)][_0x48fcc3(0x15f)]===undefined)this[_0x48fcc3(0x305)]();return this[_0x48fcc3(0x201)]['choiceTextAlign'];},Game_System['prototype']['setChoiceListTextAlign']=function(_0x3f4e27){const _0xfe86e1=_0x571fe1;if(this['_MessageCoreSettings']===undefined)this[_0xfe86e1(0x305)]();if(this[_0xfe86e1(0x201)][_0xfe86e1(0x15f)]===undefined)this['initMessageCore']();this['_MessageCoreSettings']['choiceTextAlign']=_0x3f4e27[_0xfe86e1(0x366)]();},Game_System[_0x571fe1(0x252)][_0x571fe1(0x33a)]=function(){const _0x31d7f8=_0x571fe1;if(this[_0x31d7f8(0x201)]===undefined)this[_0x31d7f8(0x305)]();return this['_MessageCoreSettings'][_0x31d7f8(0x2a6)]||0x0;},Game_System[_0x571fe1(0x252)][_0x571fe1(0x318)]=function(_0x52139c){const _0x5809ba=_0x571fe1;if(this[_0x5809ba(0x201)]===undefined)this[_0x5809ba(0x305)]();this[_0x5809ba(0x201)][_0x5809ba(0x2a6)]=_0x52139c||0x0;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x2f9)]=function(_0x3a5802,_0x260b49){const _0x11388e=_0x571fe1;this[_0x11388e(0x33e)]=_0x3a5802,this[_0x11388e(0x19d)]=_0x11388e(0x316),this[_0x11388e(0x1ee)]=_0x260b49,this[_0x11388e(0x210)]=0x0;},Game_Message['prototype'][_0x571fe1(0x42d)]=function(){const _0x44d385=_0x571fe1;return this[_0x44d385(0x1ee)]||0x0;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x4a6)]=function(_0x1c0c48,_0x45d71f,_0x17eb24){const _0x1200da=_0x571fe1;this[_0x1200da(0x33e)]=_0x1c0c48,this[_0x1200da(0x19d)]=_0x1200da(0x411),this[_0x1200da(0xdb)]=_0x45d71f,this['_itemChoiceEtypeId']=_0x17eb24;},Game_Message[_0x571fe1(0x252)]['itemChoiceAtypeId']=function(){const _0x4a6093=_0x571fe1;return this[_0x4a6093(0xdb)]||0x0;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x486)]=function(){const _0x327cb7=_0x571fe1;return this[_0x327cb7(0x210)]||0x0;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x3cb)]=function(_0x58a3a1,_0x4f32c3,_0x5356b9){const _0x22177e=_0x571fe1;this[_0x22177e(0x33e)]=_0x58a3a1,this[_0x22177e(0x19d)]='skill',this[_0x22177e(0x447)]=_0x4f32c3,this[_0x22177e(0x1ae)]=_0x5356b9;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x44f)]=function(){const _0x2c265e=_0x571fe1;return this[_0x2c265e(0x447)]||0x0;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x13d)]=function(){const _0x2e189b=_0x571fe1;return $gameActors[_0x2e189b(0x29e)](this[_0x2e189b(0x44f)]())||$gameParty['leader']()||null;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x47a)]=function(){return this['_itemChoiceStypeId']||0x0;},VisuMZ[_0x571fe1(0x3f9)]['Game_Message_setChoices']=Game_Message['prototype'][_0x571fe1(0xe4)],Game_Message['prototype'][_0x571fe1(0xe4)]=function(_0x260ba6,_0x375082,_0x257ff2){const _0x21f4ae=_0x571fe1;this['_scriptCall']=!![],VisuMZ['MessageCore'][_0x21f4ae(0x319)][_0x21f4ae(0x323)](this,_0x260ba6,_0x375082,_0x257ff2);},Game_Message[_0x571fe1(0x252)]['setupShuffleChoices']=function(){const _0x17a073=_0x571fe1;this['_scriptCall']=![],this[_0x17a073(0x38b)]=[];const _0x152dcc=this[_0x17a073(0x2d9)][_0x17a073(0x10a)];this[_0x17a073(0x2d4)]=_0x152dcc;let _0xdd6baf=![];for(let _0x38255d=0x0;_0x38255d<_0x152dcc;_0x38255d++){let _0x14e691=this['_choices'][_0x38255d];if(_0x14e691[_0x17a073(0xf6)](/<SHUFFLE>/gi)){if('Mtync'!=='Mtync'){const _0xc38c3e=_0x5e6e5d['$1'][_0x17a073(0x234)](',')['map'](_0xcab33b=>_0x23036e(_0xcab33b)||0x0);for(const _0xddb48b of _0xc38c3e){if(_0x28fe78['value'](_0xddb48b))return![];}return!![];}else _0xdd6baf=!![],_0x14e691=_0x14e691[_0x17a073(0x3e9)](/<SHUFFLE>/gi,'');}_0x14e691[_0x17a073(0xf6)](/<SHUFFLE:[ ](\d+)>/gi)&&(_0xdd6baf=!![],this[_0x17a073(0x2d4)]=Math[_0x17a073(0x38d)](Number(RegExp['$1']),this[_0x17a073(0x2d4)]),_0x14e691=_0x14e691[_0x17a073(0x3e9)](/<SHUFFLE:[ ](\d+)>/gi,'')),this[_0x17a073(0x38b)]['push'](_0x38255d),this['_choices'][_0x38255d]=_0x14e691;}if(_0xdd6baf){this[_0x17a073(0x38b)]=VisuMZ[_0x17a073(0x3f9)][_0x17a073(0x161)](this['_choiceIndexArray']);if(this[_0x17a073(0x28e)]()!==-0x2)this[_0x17a073(0x414)]=-0x1;}},VisuMZ['MessageCore'][_0x571fe1(0x161)]=function(_0x33be81){const _0x1086a8=_0x571fe1;var _0x5da0b4,_0x3cabcd,_0x8e231f;for(_0x8e231f=_0x33be81[_0x1086a8(0x10a)]-0x1;_0x8e231f>0x0;_0x8e231f--){_0x5da0b4=Math[_0x1086a8(0x18f)](Math[_0x1086a8(0x3ba)]()*(_0x8e231f+0x1)),_0x3cabcd=_0x33be81[_0x8e231f],_0x33be81[_0x8e231f]=_0x33be81[_0x5da0b4],_0x33be81[_0x5da0b4]=_0x3cabcd;}return _0x33be81;},Game_Message[_0x571fe1(0x252)][_0x571fe1(0x194)]=function(){const _0x512864=_0x571fe1;if(!this[_0x512864(0x38b)])this['setupShuffleChoices']();return this[_0x512864(0x38b)];},Game_Message['prototype']['maxShuffleChoices']=function(){const _0x287d5b=_0x571fe1;if(this[_0x287d5b(0x2d4)]===undefined)this[_0x287d5b(0x4f6)]();return this[_0x287d5b(0x2d4)];},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x405)]=Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x25a)],Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x25a)]=function(){const _0x11e553=_0x571fe1;VisuMZ[_0x11e553(0x3f9)]['Game_Screen_clearPictures'][_0x11e553(0x323)](this),this[_0x11e553(0xe5)]();},Game_Screen['prototype'][_0x571fe1(0xe5)]=function(){const _0xe6973a=_0x571fe1;this[_0xe6973a(0x196)]=[],this[_0xe6973a(0x12e)]=[],this[_0xe6973a(0x271)]=[];},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x310)]=function(_0x59732f){const _0xdfde11=_0x571fe1;if(this['_pictureText']===undefined)this[_0xdfde11(0xe5)]();const _0x5586bd=this[_0xdfde11(0x3bf)](_0x59732f);return this['_pictureText'][_0x5586bd]=this[_0xdfde11(0x196)][_0x5586bd]||{},this[_0xdfde11(0x196)][_0x5586bd];},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x385)]=function(_0x16600c,_0xebc381){const _0x2369e9=_0x571fe1;return _0xebc381=_0xebc381[_0x2369e9(0x366)]()[_0x2369e9(0x2a1)](),this[_0x2369e9(0x310)](_0x16600c)[_0xebc381]||'';},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x177)]=function(_0xb58ce9,_0xddaba0,_0x39ce9e){const _0x4b5ade=_0x571fe1;_0x39ce9e=_0x39ce9e['toLowerCase']()[_0x4b5ade(0x2a1)](),this[_0x4b5ade(0x310)](_0xb58ce9)[_0x39ce9e]=_0xddaba0||'',this[_0x4b5ade(0x498)](_0xb58ce9,!![]);},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x448)]=function(_0x25a0be){const _0x1fa9ab=_0x571fe1;if(this[_0x1fa9ab(0x196)]===undefined)this['clearAllPictureTexts']();const _0x48dc32=this[_0x1fa9ab(0x3bf)](_0x25a0be);this[_0x1fa9ab(0x196)][_0x48dc32]=null,this['requestPictureTextRefresh'](_0x25a0be,!![]);},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x2f1)]=function(_0x206e52){const _0xe4fe6c=_0x571fe1;if(this['_pictureText']===undefined)this[_0xe4fe6c(0xe5)]();const _0x2548a1=this[_0xe4fe6c(0x3bf)](_0x206e52);return this['_pictureTextBuffer'][_0x2548a1]||0x0;},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x2e4)]=function(_0x479a56,_0xca380f){const _0x6aedf5=_0x571fe1;if(this[_0x6aedf5(0x196)]===undefined)this[_0x6aedf5(0xe5)]();const _0x47dd23=this[_0x6aedf5(0x3bf)](_0x479a56);this[_0x6aedf5(0x12e)][_0x47dd23]=Math[_0x6aedf5(0x3f5)](0x0,_0xca380f);},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x417)]=function(_0x487d11){const _0x188df4=_0x571fe1;if(this[_0x188df4(0x196)]===undefined)this[_0x188df4(0xe5)]();const _0x385894=this[_0x188df4(0x3bf)](_0x487d11);this['_pictureTextBuffer'][_0x385894]=undefined;},VisuMZ['MessageCore'][_0x571fe1(0x397)]=Game_Screen['prototype'][_0x571fe1(0x472)],Game_Screen[_0x571fe1(0x252)]['erasePicture']=function(_0x4f31f2){const _0x42eba0=_0x571fe1;VisuMZ['MessageCore'][_0x42eba0(0x397)]['call'](this,_0x4f31f2),this[_0x42eba0(0x448)](_0x4f31f2),this[_0x42eba0(0x417)](_0x4f31f2),this[_0x42eba0(0x498)](_0x4f31f2,!![]);},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x440)]=function(){const _0x532da2=_0x571fe1;for(const _0x242675 of this[_0x532da2(0x2f4)]){if(_0x242675){let _0x4df740=this[_0x532da2(0x2f4)][_0x532da2(0x454)](_0x242675);this[_0x532da2(0x498)](_0x4df740);}}},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x498)]=function(_0x24fa93,_0x1fa81e){const _0xe1a754=_0x571fe1;this['_pictureTextRefresh']=this[_0xe1a754(0x271)]||[],(this[_0xe1a754(0x51e)](_0x24fa93)||_0x1fa81e)&&this[_0xe1a754(0x271)]['push'](_0x24fa93);},Game_Screen['prototype']['needsPictureTextRefresh']=function(_0x426fe2){const _0xe703a0=_0x571fe1;return this[_0xe703a0(0x271)]=this[_0xe703a0(0x271)]||[],this[_0xe703a0(0x271)][_0xe703a0(0x297)](_0x426fe2);},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x3ea)]=function(_0xad0ab3){const _0x1a804b=_0x571fe1;this[_0x1a804b(0x271)]=this[_0x1a804b(0x271)]||[],this[_0x1a804b(0x271)][_0x1a804b(0x510)](_0xad0ab3);},Game_Screen[_0x571fe1(0x252)][_0x571fe1(0x51e)]=function(_0x2849fc){const _0x11989c=_0x571fe1,_0x47e987=[_0x11989c(0x468),'up',_0x11989c(0x27d),'left','center',_0x11989c(0x236),_0x11989c(0x3d6),'down','lowerright'];return _0x47e987[_0x11989c(0x1ea)](_0x43adee=>this[_0x11989c(0x385)](_0x2849fc,_0x43adee)!=='');},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x438)]=Game_Party['prototype'][_0x571fe1(0x49f)],Game_Party[_0x571fe1(0x252)][_0x571fe1(0x49f)]=function(){const _0x3a5d37=_0x571fe1;VisuMZ[_0x3a5d37(0x3f9)]['Game_Party_initialize'][_0x3a5d37(0x323)](this),this[_0x3a5d37(0x305)]();},Game_Party[_0x571fe1(0x252)][_0x571fe1(0x305)]=function(){const _0x3a15c1=_0x571fe1;this[_0x3a15c1(0x320)]={'type':0x0,'id':0x0,'quantity':0x0};},Game_Party['prototype'][_0x571fe1(0x3b7)]=function(){const _0x14a095=_0x571fe1;if(this['_lastGainedItemData']===undefined)this[_0x14a095(0x305)]();return this[_0x14a095(0x320)];},Game_Party[_0x571fe1(0x252)][_0x571fe1(0x4ea)]=function(_0x314158,_0x5ef258){const _0x33ca19=_0x571fe1;if(this['_lastGainedItemData']===undefined)this[_0x33ca19(0x305)]();if(!_0x314158)return;if(DataManager[_0x33ca19(0x21f)](_0x314158)){if(_0x33ca19(0x287)===_0x33ca19(0x2b4))return this[_0x33ca19(0x210)]||0x0;else this[_0x33ca19(0x320)]['type']=0x0;}else{if(DataManager['isWeapon'](_0x314158))_0x33ca19(0x4ed)===_0x33ca19(0x4ed)?this[_0x33ca19(0x320)]['type']=0x1:(this['_commonEventId']=_0x5455c0,this['_eventId']=_0xcde848||0x0,this[_0x33ca19(0x4c5)]());else{if(DataManager[_0x33ca19(0x140)](_0x314158)){if(_0x33ca19(0x50a)===_0x33ca19(0x50a))this['_lastGainedItemData'][_0x33ca19(0x32c)]=0x2;else{var _0x3dc507=/^\<(.*?)\>/[_0x33ca19(0x3d3)](_0x4afdb4[_0x33ca19(0x339)][_0x33ca19(0x13a)](_0x551d6e[_0x33ca19(0x497)]));return _0x3dc507?(_0x45d22f[_0x33ca19(0x497)]+=_0x3dc507[0x0]['length'],_0x5eb802(_0x3dc507[0x0][_0x33ca19(0x13a)](0x1,_0x3dc507[0x0][_0x33ca19(0x10a)]-0x1))):'';}}}}this[_0x33ca19(0x320)]['id']=_0x314158['id'],this['_lastGainedItemData']['quantity']=_0x5ef258;},VisuMZ['MessageCore'][_0x571fe1(0x4ab)]=Game_Party[_0x571fe1(0x252)][_0x571fe1(0x49d)],Game_Party[_0x571fe1(0x252)][_0x571fe1(0x49d)]=function(_0x1c3da6,_0x537fd4,_0x495197){const _0x438d91=_0x571fe1;VisuMZ[_0x438d91(0x3f9)][_0x438d91(0x4ab)][_0x438d91(0x323)](this,_0x1c3da6,_0x537fd4,_0x495197),_0x537fd4>0x0&&this[_0x438d91(0x4ea)](_0x1c3da6,_0x537fd4);},VisuMZ['MessageCore'][_0x571fe1(0x197)]=Game_Map[_0x571fe1(0x252)]['initialize'],Game_Map[_0x571fe1(0x252)][_0x571fe1(0x49f)]=function(){const _0x5439bc=_0x571fe1;VisuMZ[_0x5439bc(0x3f9)][_0x5439bc(0x197)][_0x5439bc(0x323)](this),this[_0x5439bc(0x2ca)]=[];},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x212)]=Game_Map[_0x571fe1(0x252)][_0x571fe1(0xe6)],Game_Map[_0x571fe1(0x252)][_0x571fe1(0xe6)]=function(){const _0x430739=_0x571fe1;VisuMZ['MessageCore'][_0x430739(0x212)][_0x430739(0x323)](this),this[_0x430739(0x2ca)]=[];},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2ae)]=Game_Map[_0x571fe1(0x252)]['updateEvents'],Game_Map[_0x571fe1(0x252)][_0x571fe1(0x169)]=function(){const _0x1b0d38=_0x571fe1;VisuMZ[_0x1b0d38(0x3f9)]['Game_Map_updateEvents'][_0x1b0d38(0x323)](this),this[_0x1b0d38(0x141)]();},Game_Map[_0x571fe1(0x252)][_0x571fe1(0x3a8)]=function(_0x258c43){const _0x40d9a7=_0x571fe1;if(!$dataCommonEvents[_0x258c43])return;this[_0x40d9a7(0x2ca)]=this['_messageCommonEvents']||[];const _0x5d5894=this[_0x40d9a7(0x156)][_0x40d9a7(0x345)],_0xc1f6f1=new Game_MessageCommonEvent(_0x258c43,_0x5d5894);this[_0x40d9a7(0x2ca)][_0x40d9a7(0x491)](_0xc1f6f1);},Game_Map[_0x571fe1(0x252)]['updateMessageCommonEvents']=function(){const _0x41cae3=_0x571fe1;this[_0x41cae3(0x2ca)]=this['_messageCommonEvents']||[];for(const _0x504a74 of this[_0x41cae3(0x2ca)]){if(_0x41cae3(0x376)!==_0x41cae3(0x1e4)){if(!_0x504a74[_0x41cae3(0x156)]){if(_0x41cae3(0x32e)==='EwVxX'){const _0x25e832=_0x22d7f2[_0x41cae3(0x513)]();_0x41ce38=_0x279fb0[_0x41cae3(0x17b)](_0x380a06[_0x41cae3(0x38d)](_0x25e832,_0x514ad3[_0x41cae3(0x10a)])/this[_0x41cae3(0x2b6)]());}else this[_0x41cae3(0x2ca)][_0x41cae3(0x510)](_0x504a74);}else _0x504a74['update']();}else{_0x4fcbc0[_0x41cae3(0x50d)](_0x3eea2a,_0x2ad04f);const _0x2584b8=_0x55a4df[_0x41cae3(0x31e)]||[];for(const _0x127e34 of _0x2584b8){_0x127a57[_0x41cae3(0x448)](_0x127e34),_0x11cdf1[_0x41cae3(0x417)](_0x127e34);}}}},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x30e)]=Game_Map['prototype'][_0x571fe1(0x4c5)],Game_Map['prototype'][_0x571fe1(0x4c5)]=function(){const _0x158808=_0x571fe1;VisuMZ[_0x158808(0x3f9)][_0x158808(0x30e)][_0x158808(0x323)](this),$gameScreen[_0x158808(0x440)]();},Game_Interpreter[_0x571fe1(0x1f6)]=pluginData[_0x571fe1(0x2cd)],Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x298)]=function(_0x48ab24){const _0x525d19=_0x571fe1;if($gameMessage[_0x525d19(0x2d8)]())return![];return this[_0x525d19(0x2a3)](_0x48ab24),this['addContinuousShowTextCommands'](_0x48ab24),this[_0x525d19(0x23a)](_0x48ab24),this[_0x525d19(0x31f)](_0x525d19(0x3b5)),!![];},Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x2a3)]=function(_0x571a3c){const _0x486687=_0x571fe1;$gameMessage[_0x486687(0x4a9)](_0x571a3c[0x0],_0x571a3c[0x1]),$gameMessage[_0x486687(0x423)](_0x571a3c[0x2]),$gameMessage[_0x486687(0x3ac)](_0x571a3c[0x3]),$gameMessage[_0x486687(0x1c2)](_0x571a3c[0x4]);},Game_Interpreter['prototype']['addContinuousShowTextCommands']=function(_0x468dcc){const _0x158833=_0x571fe1;while(this['isContinuePrepareShowTextCommands']()){this['_index']++;if(this[_0x158833(0x1a3)]()['code']===0x191){if(_0x158833(0x465)===_0x158833(0x465)){let _0x2e6d6e=this['currentCommand']()[_0x158833(0x15e)][0x0];_0x2e6d6e=VisuMZ['MessageCore'][_0x158833(0x36d)](_0x2e6d6e),$gameMessage['add'](_0x2e6d6e);}else{if(this[_0x158833(0x201)]===_0x2e9a2a)this[_0x158833(0x305)]();return this['_MessageCoreSettings']['choiceMinWidth']??0x60;}}if(this[_0x158833(0x3db)]()){if(_0x158833(0x2ec)!==_0x158833(0x2ec))_0xe657a4=!![],_0x470acb=_0x1c1970[_0x158833(0x3e9)](/<SHUFFLE>/gi,'');else break;}}},Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x125)]=function(){const _0x2b00bc=_0x571fe1;return this[_0x2b00bc(0x3e1)]()===0x65&&$gameSystem[_0x2b00bc(0x11a)]()>0x4?!![]:this[_0x2b00bc(0x3e1)]()===0x191;},VisuMZ['MessageCore'][_0x571fe1(0x36d)]=function(_0x3e6ef4){const _0x521d78=_0x571fe1,_0x37b3f7=VisuMZ[_0x521d78(0x3f9)][_0x521d78(0x49b)][_0x521d78(0x35f)];return _0x3e6ef4=(_0x37b3f7[_0x521d78(0x291)]||'')+_0x3e6ef4+(_0x37b3f7[_0x521d78(0x12f)]||''),_0x3e6ef4=_0x3e6ef4[_0x521d78(0x3e9)](/<(?:NEXT PAGE|NEXTPAGE)>/gi,''),_0x3e6ef4=_0x3e6ef4['replace'](/<(?:RNG|RAND|RANDOM)>(.*?)<\/(?:RNG|RAND|RANDOM)>/gi,(_0x5c6a80,_0xebca76)=>this[_0x521d78(0x12b)](_0xebca76)),_0x3e6ef4;},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x12b)]=function(_0x3420dc){const _0x3628c4=_0x571fe1,_0x44c8cb=_0x3420dc[_0x3628c4(0x234)]('|')[_0x3628c4(0x328)](_0x3cec6f=>_0x3cec6f[_0x3628c4(0x2a1)]())[_0x3628c4(0x510)]('')[_0x3628c4(0x510)](null);return _0x44c8cb[Math[_0x3628c4(0x18e)](_0x44c8cb[_0x3628c4(0x10a)])];},Game_Interpreter['prototype'][_0x571fe1(0x3db)]=function(){const _0x426e5d=_0x571fe1;if(this[_0x426e5d(0x1a3)]()&&this[_0x426e5d(0x1a3)]()[_0x426e5d(0x15e)][0x0][_0x426e5d(0xf6)](/<(?:NEXT PAGE|NEXTPAGE)>/gi))return!![];return $gameMessage[_0x426e5d(0x1ff)][_0x426e5d(0x10a)]>=$gameSystem[_0x426e5d(0x11a)]()&&this[_0x426e5d(0x3e1)]()!==0x191;},Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x23a)]=function(_0x556d32){const _0xbb31=_0x571fe1;switch(this[_0xbb31(0x3e1)]()){case 0x66:this[_0xbb31(0x115)]++,this[_0xbb31(0x21d)](this[_0xbb31(0x1a3)]()[_0xbb31(0x15e)]);break;case 0x67:this[_0xbb31(0x115)]++,this[_0xbb31(0x1a6)](this[_0xbb31(0x1a3)]()[_0xbb31(0x15e)]);break;case 0x68:this[_0xbb31(0x115)]++,this[_0xbb31(0x220)](this[_0xbb31(0x1a3)]()['parameters']);break;case 0x165:const _0x4dadfb=this[_0xbb31(0x42e)][this[_0xbb31(0x115)]+0x1],_0x5cdcea=_0x4dadfb['parameters'];_0x5cdcea[0x0]===Game_Interpreter[_0xbb31(0x1f6)]&&this[_0xbb31(0x24e)](_0x5cdcea);break;}},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2ab)]=Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x21d)],Game_Interpreter['prototype'][_0x571fe1(0x21d)]=function(_0x14419b){const _0x246fb6=_0x571fe1;_0x14419b=this[_0x246fb6(0x178)](),VisuMZ[_0x246fb6(0x3f9)]['Game_Interpreter_setupChoices'][_0x246fb6(0x323)](this,_0x14419b),$gameMessage[_0x246fb6(0x4f6)]();},Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x178)]=function(){const _0x24c7bf=_0x571fe1,_0x398114=this[_0x24c7bf(0x115)],_0x598022=[];let _0x2c0b8d=0x0;this['_index']++;while(this[_0x24c7bf(0x115)]<this['_list'][_0x24c7bf(0x10a)]){if(_0x24c7bf(0x1d2)===_0x24c7bf(0x1d2)){if(this[_0x24c7bf(0x1a3)]()[_0x24c7bf(0xe3)]===this[_0x24c7bf(0x503)]){if(_0x24c7bf(0x26d)===_0x24c7bf(0x26d)){if(this[_0x24c7bf(0x1a3)]()['code']===0x194&&this[_0x24c7bf(0x3e1)]()!==0x66){if(_0x24c7bf(0x37a)!==_0x24c7bf(0x4c3))break;else{let _0x1a8986=_0x59735c[_0x24c7bf(0x2c9)]();const _0x2335b5=_0x9bce54[_0x24c7bf(0x1cb)]();for(const _0x32ae82 of _0x2335b5){_0x32ae82[_0x24c7bf(0xf6)](/<CHOICE WIDTH:[ ](\d+)>/gi)&&(_0x1a8986=_0x279286[_0x24c7bf(0x3f5)](_0x1a8986,_0xdb5f60(_0x5b6834['$1'])));}return _0xfa97c1[_0x24c7bf(0x3f5)](_0x1a8986,0x1);}}else{if(this[_0x24c7bf(0x1a3)]()[_0x24c7bf(0x1a5)]===0x66)_0x24c7bf(0x1ed)==='BDPcr'?(this[_0x24c7bf(0x273)](_0x2c0b8d,this[_0x24c7bf(0x1a3)](),_0x398114),this['_index']-=0x2):_0x30b21e[_0x24c7bf(0x3f9)]['Window_ItemList_drawItemNumber'][_0x24c7bf(0x323)](this,_0x535625,_0x15c28e,_0x27da66,_0x109061);else this[_0x24c7bf(0x1a3)]()[_0x24c7bf(0x1a5)]===0x192&&('NZAYV'!==_0x24c7bf(0x441)?(this['currentCommand']()[_0x24c7bf(0x15e)][0x0]=_0x2c0b8d,_0x2c0b8d++):_0x11a2ea[_0x24c7bf(0x183)]=new _0x5c6eda(_0x24c7bf(0x4c2)+_0x22bec7[_0x24c7bf(0x3af)]['replace'](/\\/g,'\x1b')+'\x27'));}}else _0x13df67[_0x24c7bf(0x183)]=_0x2fa741['TextJS'];}this[_0x24c7bf(0x115)]++;}else{if(_0x1b1b7d['value'](_0x3d38c5))return!![];}}return this['_index']=_0x398114,this[_0x24c7bf(0x1a3)]()[_0x24c7bf(0x15e)];},Game_Interpreter[_0x571fe1(0x252)]['adjustShowChoiceExtension']=function(_0x931976,_0x33df00,_0xf2a8fd){const _0x310779=_0x571fe1;this[_0x310779(0x2e1)](_0x931976,_0x33df00,_0xf2a8fd),this[_0x310779(0x4f3)](_0x931976,_0x33df00,_0xf2a8fd),this[_0x310779(0x34e)](_0x33df00,_0xf2a8fd);},Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x2e1)]=function(_0x1f1d31,_0x57f052,_0x3eae9a){const _0x1be43c=_0x571fe1;if(_0x57f052['parameters'][0x2]<0x0)return;const _0x2f145b=_0x57f052[_0x1be43c(0x15e)][0x2]+_0x1f1d31;this['_list'][_0x3eae9a][_0x1be43c(0x15e)][0x2]=_0x2f145b;},Game_Interpreter['prototype']['adjustShowChoiceCancel']=function(_0x1c8a23,_0x30b63b,_0xb20b4c){const _0x565fd5=_0x571fe1;if(_0x30b63b['parameters'][0x1]>=0x0){if(_0x565fd5(0x221)===_0x565fd5(0x221)){var _0x5d57ef=_0x30b63b[_0x565fd5(0x15e)][0x1]+_0x1c8a23;this[_0x565fd5(0x42e)][_0xb20b4c][_0x565fd5(0x15e)][0x1]=_0x5d57ef;}else return![];}else _0x30b63b['parameters'][0x1]===-0x2&&(this['_list'][_0xb20b4c][_0x565fd5(0x15e)][0x1]=_0x30b63b['parameters'][0x1]);},Game_Interpreter[_0x571fe1(0x252)]['addExtraShowChoices']=function(_0x85c843,_0x36d1fd){const _0x2f65c2=_0x571fe1;for(const _0x39755c of _0x85c843[_0x2f65c2(0x15e)][0x0]){if(_0x2f65c2(0x122)===_0x2f65c2(0x122))this[_0x2f65c2(0x42e)][_0x36d1fd][_0x2f65c2(0x15e)][0x0]['push'](_0x39755c);else return _0x4569eb=_0x2dfa36[_0x2f65c2(0x3e9)](/\\/g,'\x1b'),_0x5c4460=_0x14f90d[_0x2f65c2(0x3e9)](/\x1b\x1b/g,'\x5c'),_0x20cccf;}this['_list']['splice'](this[_0x2f65c2(0x115)]-0x1,0x2);},Game_Interpreter[_0x571fe1(0x252)][_0x571fe1(0x24e)]=function(_0x180da2){const _0x427ad2=_0x571fe1,_0xe078ee=_0x180da2[0x1];if(_0xe078ee===_0x427ad2(0x1eb))_0x427ad2(0x25f)===_0x427ad2(0x25f)?(this[_0x427ad2(0x115)]++,this[_0x427ad2(0x2f9)](_0x180da2)):this[_0x427ad2(0x4e0)][_0x427ad2(0x491)](null);else{if(_0xe078ee===_0x427ad2(0x48a))this[_0x427ad2(0x115)]++,this[_0x427ad2(0x4a6)](_0x180da2);else _0xe078ee==='SelectSkill'&&Imported[_0x427ad2(0x511)]&&(this['_index']++,this[_0x427ad2(0x3cb)](_0x180da2));}},Game_Interpreter[_0x571fe1(0x252)]['setWeaponChoice']=function(_0x4c6551){const _0x3dd079=_0x571fe1,_0x3ae6ed=JSON[_0x3dd079(0x47f)](JSON[_0x3dd079(0x349)](_0x4c6551[0x3]));VisuMZ['ConvertParams'](_0x3ae6ed,_0x3ae6ed),$gameMessage[_0x3dd079(0x2f9)](_0x3ae6ed[_0x3dd079(0x2ce)]||0x0,_0x3ae6ed['WeaponTypeID']||0x0);},Game_Interpreter['prototype'][_0x571fe1(0x4a6)]=function(_0x1d7203){const _0x504c25=_0x571fe1,_0x1290b5=JSON[_0x504c25(0x47f)](JSON['stringify'](_0x1d7203[0x3]));VisuMZ[_0x504c25(0x50d)](_0x1290b5,_0x1290b5),$gameMessage[_0x504c25(0x4a6)](_0x1290b5[_0x504c25(0x2ce)]||0x0,_0x1290b5[_0x504c25(0x108)]||0x0,_0x1290b5[_0x504c25(0x516)]||0x0);},Game_Interpreter['prototype'][_0x571fe1(0x3cb)]=function(_0x315a28){const _0xfc75b1=_0x571fe1,_0x1bc99f=JSON[_0xfc75b1(0x47f)](JSON['stringify'](_0x315a28[0x3]));VisuMZ[_0xfc75b1(0x50d)](_0x1bc99f,_0x1bc99f),$gameMessage[_0xfc75b1(0x3cb)](_0x1bc99f[_0xfc75b1(0x2ce)]||0x0,_0x1bc99f[_0xfc75b1(0x34c)]||0x0,_0x1bc99f[_0xfc75b1(0x2dd)]||0x0);};function Game_MessageCommonEvent(){const _0x191983=_0x571fe1;this[_0x191983(0x49f)](...arguments);}function _0x3605(_0x3f12ac,_0x5328c3){const _0x3c55b8=_0x3c55();return _0x3605=function(_0x3605a5,_0x106a39){_0x3605a5=_0x3605a5-0xd1;let _0x19cf41=_0x3c55b8[_0x3605a5];return _0x19cf41;},_0x3605(_0x3f12ac,_0x5328c3);}function _0x3c55(){const _0x2a1aed=['processAllText','BOLD','\x1bi[%1]','processCharacter','Undefined','5005920odZPrA','armor','नमस्ते','jCuKy','_choiceCancelType','windowX','drawItem','erasePictureTextBuffer','Window_Options_addGeneralOptions','iconIndex','lqIDO','convertMessageCoreEscapeReplacements','Window_Base_processNewLine','_pictureTextCache','isCommandEnabled','battle\x20actor','ZquVb','ParseLocalizationCsv','changeOutlineColor','setBackground','vDpZD','instantTextSpeed','안녕하세요','Would\x20you\x20like\x20the\x20plugin\x20to\x20create\x20the\x20base\x20CSV\x20file?\x0a\x0a','updateAutoPosition','_choiceListHelpWindow','pYAZM','windowWidth','JqduF','itemChoiceWtypeId','_list','Window_Base_initialize','Scene_Options_maxCommands','test','startY','_cancelButton','Merhaba','NYPxB','itemChoiceItypeId','OhNkZ','Game_Party_initialize','initTextAlignement','preConvertEscapeCharacters','Window_EventItem_includes','drawSkillCost','maxChoiceWidth','changeVolume','Default','requestPictureTextRefreshAll','fwpvl','setTextDelay','updateForcedPlacement','nOYMB','normalColor','applyData','_itemChoiceActorId','eraseAllPictureTexts','getStartingChoiceWidth','3202864injCtV','yAeTo','addMessageCoreCommands','blue','list','itemChoiceActorId','WeaponTypeID','moveBy','HelpWindow','Good-bye','indexOf','substr','upper\x20right','VisuMZ_3_ActSeqCamera','_autoPositionTarget','EVAL','dzYua','mniHN','_scene','processFontChangeItalic','downright','Waouh','Hello','midleft','setMessageWindowWordWrap','ParseClassNotetags','ihKhv','FoxQt','windowPadding','Armors','upperleft','aTYwP','pageup','_dimmerSprite','Ceetr','drawItemContents','STR','\x1bWrapBreak[0]','powerUpColor','upcenter','erasePicture','setHelpWindow','processColorLock','downcenter','isTriggered','ConfigManager_makeData','ARRAYEVAL','_relativePosition','itemChoiceStypeId','visible','actorName','NameBoxWindowDefaultColor','_macroBypassWordWrap','parse','textSizeExWordWrap','width','boxWidth','lRgWd','sIXsF','\x1bCOLORLOCK[1]','itemChoiceEtypeId','_action','status','fdvtR','SelectArmor','VisuMZ_0_CoreEngine','exit','_forcedPosition','Languages.csv','down\x20center','battle\x20enemy','push','centered','clampPlacementPosition','outputHeight','_choiceListWindow','Localization','index','requestPictureTextRefresh','MessageTextDelay','_messageOffsetX','Settings','battleActionName','gainItem','autoPositionOffsetY','initialize','Portuguese','event','drawPictureText','processPxTextCode','jUXwb','_pictureId','setArmorChoice','prepareAutoSizeEscapeCharacters','createTextState','setFaceImage','Thai','Game_Party_gainItem','ஆஹா','paintOpacity','SWITCH','brown','getCurrentLanguage','filename','onProcessCharacter','Window_Message_synchronizeNameBox','process_VisuMZ_MessageCore_TextMacros','_messagePositionReset','nxUJG','maxLines','getConfigValue','convertFontSettingsEscapeCharacters','_commonEventId','qKmLd','#ffc8e0','isRunning','<WORDWRAP>','callOkHandler','maxCommands','Enemies','return\x20\x27','wcEDR','DZDcS','refresh','updateOffsetPosition','upright','Korean','updateMove','Window_MessageLog','_textDelayCount','PICTURE','ZTGPV','zoomScale','convertShowChoiceEscapeCodes','postFlushTextState','fontItalic','requestChoiceForegroundImage','Window_Base_processAllText','textColor','innerHeight','NNJvt','WRAPBREAK','হ্যালো','createChoiceListWindow','createLocalizationCsvFile','MQPtv','helpWordWrap','updateXyOffsets','<LEFT>','getChoiceListLineHeight','_data','EkTWm','newPage','8eUCXwh','Oetot','Hindi','child_process','ENABLE','sOuUf','Hei','setLastGainedItemData','Indonesian','yhPFr','LrhBF','Vau','<I>','Key','defeat','isRTL','adjustShowChoiceCancel','getMessageWindowXyOffsets','AUBOa','setupShuffleChoices','makeFontSmaller','Вау','requestChoiceBackgroundImage','isInputting','processMessageCoreEscapeActions','_moveTargetHeight','OUKmu','Window_ChoiceList_callCancelHandler','move','#6dcff6','value','Skills','_indent','NameBoxWindowOffsetY','makeCommandListScriptCall','isSkillHidden','setMessageWindowWidth','TQruu','COLORLOCK','rhehT','MsgWindowOffsetY','Items','ConvertParams','RelativePXPY','tWqXE','remove','VisuMZ_1_SkillsStatesCore','pZNZW','maxShuffleChoices','zbNJu','Window_Message_clearFlags','EquipTypeID','DataManager_loadDatabase','contentsBack','lowerright','Norwegian','preFlushTextState','atypeId','MessageWindowXyOffsets','hasPictureText','startWait','NUM','Window_NameBox_refresh','orange','UKVsP','constructor','SHOW','CheckCompatibility','addCommand','Привет','FontFamily','surprise','CreateAutoColorFor','convertNewPageTextStateMacros','setChoiceListMaxRows','addChoiceDistance','round','OffsetX','_wordWrap','Hoşça\x20kal','registerCommand','_textDelay','_currentAutoSize','_itemChoiceAtypeId','follower','hwYiB','contentsHeight','XMZFs','wtypeId','up\x20left','ARRAYFUNC','indent','setChoices','clearAllPictureTexts','setupEvents','itemRectWithPadding','Window_Base_update','easeOut','HLInt','AddOption','AdjustRect','osFuz','isWordWrapEnabled','unshift','KvyYj','followers','isPressed','mFbYu','States','shift','match','addWrapBreakAfterPunctuation','FnDnS','Bonjour','updateChoiceListHelpWindowPlacement','getMessageWindowWidth','nCHDK','process_VisuMZ_MessageCore_TextCodes_Action','\x1bBOLD[0]','Window_Message_processEscapeCharacter','tpQxG','white','contents','isChoiceWindow','Spanish','\x1bTEXTALIGNMENT[3]','Scene_Message_createChoiceListWindow','skill','ArmorTypeID','getColor','length','parseLocalizedText','Italian','down','Window_Help_refresh','data/','show','onDatabaseLoaded','setMessageWindowXyOffsets','makeData','anchor','_index','Polish','process_VisuMZ_MessageCore_AutoColor','convertHardcodedEscapeReplacements','VZFtM','getMessageWindowRows','flushTextState','pagedown','Greeting','CSV\x20file\x20cannot\x20be\x20created.\x0aPlease\x20enter\x20Playtest\x20mode.\x0a','setChoiceListMaxColumns','isChoiceVisible','ConfigManager_applyData','yIYfB','updatePictureText','AutoColorRegExp','isContinuePrepareShowTextCommands','sCGdJ','gmnpt','bitmap','changeChoiceBackgroundColor','ThpHC','getRandomTextFromPool','up\x20right','startX','_pictureTextBuffer','EachMessageEnd','swsxj','mgNFC','_lastPluginCommandInterpreter','Window_Base_processControlCharacter','ChoiceWindowMaxCols','IAJnU','registerResetRect','path','yes','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','slice','KmVZs','responseText','itemChoiceActor','German','Classes','isArmor','updateMessageCommonEvents','changePaintOpacity','grey','applyChoiceHelpDescriptions','textSizeExRaw','Danish','JiEkG','openness','fontSize','blt','\x5c%1','convertTextAlignmentEscapeCharacters','partyMemberName','isClosed','statusText','moveTo','MrSDB','_colorLock','loadPicture','loadDatabase','lineHeight','_interpreter','Auf\x20Wiedersehen','eysPL','Szia','map\x20player','defaultColor','বিদায়','AddAutoColor','parameters','choiceTextAlign','Vay','ShuffleArray','isChoiceEnabled','obtainEscapeParam','2aUGnDH','setTextAlignment','oEcYj','DefaultLocale','Romanian','updateEvents','update','_choiceHelpDescriptions','Wauw','drawBackCenteredPicture','Hola','COMMONEVENT','Chinese(Traditional)','chqCr','openLocalizationFolder','\x1bTEXTALIGNMENT[0]','choiceLineHeight','wBCRs','needsNewPage','setPictureText','addContinuousShowChoices','setLastPluginCommandInterpreter','battle\x20party','ceil','mainFontSize','AUvRs','processFontChangeBold','tfBEd','SelectSkill','203579BHFAxZ','Rows','textCodeResult','pOdqw','convertButtonAssistEscapeCharacters','processDrawPicture','eVkQe','addGeneralOptions','Farewell','_pictureTextSprite','boxHeight','Wah','Farvel','randomInt','floor','processStoredAutoColorChanges','अलविदा','HhUhH','makeFontBigger','choiceIndexArray','etypeId','_pictureText','Game_Map_initialize','convertChoiceMacros','PictureTextChange','registerActorNameAutoColorChanges','addMessageCoreLocalizationCommand','inBattle','_itemChoiceItypeId','#7cc576','\x1bTEXTALIGNMENT[2]','Bitmap_drawTextTopAligned','wjThA','cvHJH','currentCommand','ChoiceWindowTextAlign','code','setupNumInput','commandName','dirname','_pictureTextWindow','createPictureText','red','canMove','processTextAlignmentChange','_itemChoiceStypeId','setText','crisisColor','lower-right','parseChoiceText','currentExt','PREVCOLOR','kbTIX','jmyIA','_resetRect','ParseWeaponNotetags','launchMessageCommonEvent','SplitJpCnCharacters','down-left','cancel','itemHeight','drawing','MessageWindowProperties','Arrivederci','\x1bC[%1]%2\x1bPREVCOLOR[0]','setSpeakerName','activate','menu','XUPCN','41234410BxluDB','AutoColor','_scriptCall','outlineColor','open','choices','பிரியாவிடை','obtainExp','updatePlacement','Hejdå','Window_Options_changeVolume','strokeRect','VBvZO','lskaP','_autoSizeRegexp','start\x20.\x5cdata','gpgTM','upper\x20center','JHIHq','drawItemNumber','_target','setMessageWindowRows','getChoiceListMaxRows','setChoiceListLineHeight','choiceAlignText','ChoiceWindowDistance','YpJwQ','4290780TMXMzD','さようなら','Selamat\x20tinggal','TttCl','GET','UNDEFINED!','lower\x20left','makeCommandListShuffle','Greek','some','SelectWeapon','ParseStateNotetags','BDPcr','_itemChoiceWtypeId','battleUserName','padding','#acacac','CuyUa','Chinese(Simplified)','isSkillTypeMatchForUse','Näkemiin','MESSAGE_CORE_PLUGIN_NAME','true','WAIT','Hej','processActorNameAutoColorChanges','item','obtainItem','NhJBD','forEach','_texts','needsPictureTextRefresh','_MessageCoreSettings','updateTransform','TextCodeActions','Wow','visuMzTextLocaleStatusText','registerSelfEvent','isSceneBattle','VpTzP','setup','Window_Options_statusText','upper\x20left','fxBpD','eIPjY','updateOverlappingY','TextColor','_itemChoiceEtypeId','textLocale','Game_Map_setupEvents','choiceRows','setHelpWindowWordWrap','Sprite_Picture_update','ITALIC','CreateAutoColorRegExpLists','ChoiceWindowMinWidth','QEaAt','asnKu','applyMoveEasing','updateNameBoxMove','setupChoices','Actors','isItem','setupItemChoice','EGrAC','mpISf','Αντίο','convertVariableEscapeCharacters','_showFast','anyPictureTextChanges','8iIXcTS','ThAZW','lcvCX','createContents','ว้าว','clearActorNameAutoColor','Game_System_initialize','EVpVi','TextMacros','getChoiceIndent','elpua','_autoPosRegExp','sACzU','split','TextJS','right','reduce','Cześć','bind','prepareShowTextFollowups','TEXTALIGNMENT','choicePositionType','convertBackslashCharacters','clearFlags','BNtqe','isSceneMap','ParseEnemyNotetags','outputWidth','NameBoxWindowOffsetX','selectDefault','TextAlign','ZyHUw','skills','<CENTER>','_autoColorActorNames','itemBackColor1','Halo','jKxWH','Window_ChoiceList_windowX','prepareShowTextPluginCommandFollowups','up-center','downleft','calcMoveEasing','prototype','ConvertTextAutoColorRegExpFriendly','crisis','\x1bCOLORLOCK[0]','filter','TIgXq','clearChoiceHelpDescriptions','\x1bWrapJpBreak[0]','clearPictures','inputtingAction','_positionType','Languages','textSpeedStatusText','fatqF','none','Window_Base_textSizeEx','Game_Interpreter_PluginCommand','CSV\x20file\x20is\x20now\x20created\x20and\x20stored\x20in\x20data\x20folder.\x0a','zVwyE','changeVisuMzTextLocale','violet','createChoiceListHelpWindow','15231690jMxrut','TextColor%1','resetTextColor','MinWidth','VPqbi','DjyJr','LtCSK','hcdWS','VisuMZ_1_EventsMoveCore','_pictureTextRefresh','$dataLocalization','adjustShowChoiceExtension','Salut','JSoWM','OXlqi','CsvFilename','nSekw','getChoiceListTextAlign','drawCustomBackgroundColor','_textAlignment','changeTextColor','upperright','ChoiceWindowMaxRows','Window_Message_needsNewPage','loadCustomFontsMessageCore','BGarV','getLocalizedText','qfMig','#707070','FontBiggerCap','getLanguageAt','JLZCl','messageRows','</COLORLOCK>','gradientFillRect','textSpeed','PictureTextRefresh','oKBhs','choiceCancelType','_moveTargetWidth','innerWidth','EachMessageStart','clearRect','mainModule','Adeus','ObhyI','CSV\x20file\x20has\x20not\x20been\x20made.\x0a','includes','command101','</I>','Window_Message_isTriggered','vlGgw','pink','refreshDimmerBitmap','actor','hsoAY','Hűha','trim','getChoiceListMaxColumns','prepareShowTextCommand','_messageOffsetY','MessageRows','choiceDistance','String_format','_moveDuration','yixVo','addLoadListener','Game_Interpreter_setupChoices','loadLocalization','uppercenter','Game_Map_updateEvents','MTCHh','switchOutTextForLocalization','CommonEvent','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','English','xztYe','middleleft','maxCols','\x1bITALIC[0]','sort','application/csv','</B>','TextManager_message','setWordWrap','_moveEasingType','Window_Base_processEscapeCharacter','fontBold','AutoColorBypassList','MwkYQ','WordWrap','DGoLT','Window_Base_changeTextColor','itemBackColor2','Enable','messageWindowRect','ParseItemNotetags','getChoiceListMinChoiceWidth','_messageCommonEvents','Distance','MpDfL','name','VariableID','CBVvv','processPyTextCode','_wholeMoveDuration','stretchDimmerSprite','preemptive','_maxShuffleChoices','_targets','dKiWM','pdJrv','isBusy','_choices','mainFontFace','Scene_Boot_onDatabaseLoaded','வணக்கம்','SkillTypeID','messageCoreWindowX','Window_Message_terminateMessage','_moveTargetY','adjustShowChoiceDefault','ChoiceWindowProperties','isColorLocked','setPictureTextBuffer','Czech','map\x20event','obtainGold','down\x20right','messagePositionReset','convertButtonAssistText','obtainEscapeString','kyveW','default','resetRect','\x1bTEXTALIGNMENT','anchorPictureText','getPictureTextBuffer','getTextAlignment','getPreservedFontSettings','_pictures','DKxMo','escapeStart','Do\x20widzenia','Hungarian','setWeaponChoice','MaxRows','description','lJTFf','drawTextTopAligned','YgWWp','textSizeEx','updateRelativePosition','drawBackPicture','lower\x20right','makeCommandList','MsgWindowOffsetX','initMessageCore','_moveTargetX','안녕히\x20가세요','updateAutoSizePosition','Type','version','drawPictureTextZone','Ha\x20det','attachPictureText','Game_Map_refresh','<%1>','getPictureTextData','XFKnR','outlineWidth','<LINE\x20BREAK>','AgwIK','substring','weapon','callCancelHandler','setChoiceMessageDistance','Game_Message_setChoices','getLastPluginCommandInterpreter','hide','TextSpeed','ROFJD','PictureIDs','setWaitMode','_lastGainedItemData','Window_ChoiceList','processCustomWait','call','HbjmK','bZJZk','changeValue','onLocalizationXhrLoad','map','updateHelp','Slovak','numVisibleRows','type','eytco','PdBWw','choiceCols','scale','messageWidth','_pictureTextHeight','faceWidth','Name','wDTjy','isHelpWindowWordWrap','resizePictureText','ParseAllNotetags','text','getChoiceMessageDistance','ParseArmorNotetags','processAutoColorWords','prepareWordWrapEscapeCharacters','_itemChoiceVariableId','messageWordWrap','ARRAYSTR','oLtKN','JSON','Width','faceName','_eventId','messageCoreTextSpeed','open\x20.\x5cdata','CENTERPICTURE','stringify','KAxCz','close','ActorID','isAutoColorAffected','addExtraShowChoices','choiceMinWidth','_helpWindow','fontFace','SortObjectByKeyLength','sagFN','isSkill','placeCancelButton','charAt','#fff799','EjuYF','ParseSkillNotetags','updateBackground','writeFileSync','\x1bi[%1]%2','onLocalizationXhrError','yellow','General','middlecenter','CreateAutoColorRegExpListEntries','messageCoreLocalization','(((','postConvertEscapeCharacters','itemRect','toLowerCase','textSizeExTextAlignment','TextCodeReplace','join','NTJNp','ZbaoV','commandSymbol','ParseAddedText','DefaultOutlineWidth','Window_Message_updatePlacement','loadGameFonts','upper-left','_pictureTextWidth','OffsetY','clamp','Unnamed.ttf','dANUm','DpefZ','processTextAlignmentX','SWITCHES','Rhwvy','convertBaseEscapeCharacters','こんにちは','_textMacroFound','350155hpefWW','TzTLy','NDDGT','processAutoSize','swrFB','tqgLA','addMessageCoreTextSpeedCommand','getPictureText','Padding','Hallo','getSkillTypes','Weapons','FontSmallerCap','_choiceIndexArray','mcWJz','min','Window_Message_newPage','Wyblg','members','overrideMimeType','lyWuQ','addedHeight','MpqSZ','HIDE','Zbohom','Game_Screen_erasePicture','processAutoPosition','unnamed','sQQoV','processPreviousColor','ANY','TZTGU','Instant','setChoiceListMinChoiceWidth','terminateMessage','itemChoiceAtypeId','autoPositionOffsetX','processNewLine','PBacW','FCLwF','map\x20party','prepareForcedPositionEscapeCharacters','addMessageCommonEvent','Window_NameBox_updatePlacement','Γειά\x20σου','drawChoiceLocationImage','setPositionType','Uau','makeDeepCopy','TextStr','false','fpaVb','updateDimensions','VisuMZ_4_ExtraEnemyDrops\x20needs\x20to\x20be\x20updated\x20','command357','message','#ffffff','getLastGainedItemData','toUpperCase','WORD_WRAP_PADDING','random','updateBitmap','drawTextEx','processFsTextCode','convertLockColorsEscapeCharacters','realPictureId','<B>','isVolumeSymbol','resetWordWrap','_textColorStack','textCodeCheck','\x1bBOLD[1]','ওহে','Sprite_Picture_updateBitmap','Match','upper-right','lower-center','setSkillChoice','SDsYH','Window_Options_isVolumeSymbol','center','victory','CTLHy','calcWindowHeight','textWidth','exec','load','changeTextSpeed','lowerleft','_messageWindow','rtl','processCommonEvent','Ουάου','isBreakShowTextCommands','choice','format','onload','setRelativePosition','height','nextEventCode','Adiós','dtAUD','easeInOut','isVisuMzLocalizationEnabled','convertTextMacros','colSpacing','setColorLock','replace','clearPictureTextRefresh','outLineColor','dimColor2','ALL','middleright','_nameBoxWindow','getLanguageName','Bitmap_drawText','ActionJS','Window_ChoiceList_updatePlacement','FontChangeValue','max','Scene_Boot_loadGameFonts','Ahoj','_autoSizeCheck','MessageCore','isWeapon','process_VisuMZ_MessageCore_TextCodes_Replace','hcsqp','processWrapBreak','PictureTextErase','lower\x20center','clear','battleTargetName','left','makeItemList','processEscapeCharacter','Game_Screen_clearPictures','quantity','returnPreservedFontSettings','jODFj','databaseObjectName','itemPadding'];_0x3c55=function(){return _0x2a1aed;};return _0x3c55();}Game_MessageCommonEvent[_0x571fe1(0x252)][_0x571fe1(0x49f)]=function(_0x44e548,_0x22860a){const _0x12e903=_0x571fe1;this[_0x12e903(0x4ba)]=_0x44e548,this[_0x12e903(0x345)]=_0x22860a||0x0,this[_0x12e903(0x4c5)]();},Game_MessageCommonEvent[_0x571fe1(0x252)][_0x571fe1(0x4a1)]=function(){return $dataCommonEvents[this['_commonEventId']];},Game_MessageCommonEvent[_0x571fe1(0x252)][_0x571fe1(0x44e)]=function(){const _0x5d7857=_0x571fe1;return this['event']()[_0x5d7857(0x44e)];},Game_MessageCommonEvent['prototype'][_0x571fe1(0x4c5)]=function(){const _0x53af76=_0x571fe1;this[_0x53af76(0x156)]=new Game_Interpreter(),this[_0x53af76(0x156)][_0x53af76(0x209)](this[_0x53af76(0x44e)](),this['_eventId']);},Game_MessageCommonEvent[_0x571fe1(0x252)][_0x571fe1(0x16a)]=function(){const _0x396704=_0x571fe1;if(this['_interpreter']){if(_0x396704(0x3fc)!==_0x396704(0x3fc))this['_interpreter'][_0x396704(0x16a)]();else{if(this[_0x396704(0x156)][_0x396704(0x4bd)]())this[_0x396704(0x156)][_0x396704(0x16a)]();else{if(_0x396704(0x36a)===_0x396704(0x36a))this[_0x396704(0x400)]();else{const _0x5e2530=_0x396704(0x269)['format'](_0x4c1a87),_0x3b3ccd=_0x1a6322[_0x396704(0x3f9)][_0x396704(0x49b)][_0x396704(0x1c7)][_0x5e2530];_0x3b3ccd[_0x396704(0x2b8)]((_0x54f0fb,_0x501771)=>{const _0x5df1e5=_0x396704;if(!_0x54f0fb||!_0x501771)return-0x1;return _0x501771['length']-_0x54f0fb[_0x5df1e5(0x10a)];}),this[_0x396704(0x361)](_0x3b3ccd,_0x5291ec);}}}}},Game_MessageCommonEvent[_0x571fe1(0x252)]['clear']=function(){this['_interpreter']=null;},Scene_Message[_0x571fe1(0x252)][_0x571fe1(0x2c7)]=function(){const _0x30d6fe=_0x571fe1,_0x33b54f=Math[_0x30d6fe(0x38d)](Graphics[_0x30d6fe(0x481)],$gameSystem['getMessageWindowWidth']()),_0x3dc89e=$gameSystem[_0x30d6fe(0x11a)](),_0x29a568=this[_0x30d6fe(0x3d1)](_0x3dc89e,![]),_0x5e7e15=(Graphics[_0x30d6fe(0x482)]-_0x33b54f)/0x2,_0x5db246=0x0;return new Rectangle(_0x5e7e15,_0x5db246,_0x33b54f,_0x29a568);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x106)]=Scene_Message[_0x571fe1(0x252)][_0x571fe1(0x4d9)],Scene_Message['prototype'][_0x571fe1(0x4d9)]=function(){const _0x2fe181=_0x571fe1;VisuMZ['MessageCore'][_0x2fe181(0x106)][_0x2fe181(0x323)](this),this[_0x2fe181(0x267)]();},Scene_Message[_0x571fe1(0x252)][_0x571fe1(0x267)]=function(){const _0x1ca773=_0x571fe1,_0x39976c=this['choiceListHelpWindowRect'](),_0x4710aa=new Window_Help(_0x39976c);_0x4710aa['hide'](),this[_0x1ca773(0x495)][_0x1ca773(0x473)](_0x4710aa),this[_0x1ca773(0x3d7)]['setChoiceListHelpWindow'](_0x4710aa),this['addWindow'](_0x4710aa),this['_choiceListHelpWindow']=_0x4710aa;},Scene_Message['prototype']['choiceListHelpWindowRect']=function(){const _0x3a4ed1=_0x571fe1,_0x41cbd9=0x0,_0x5846e1=0x0,_0x1666e4=Graphics[_0x3a4ed1(0x482)],_0xfa040=this[_0x3a4ed1(0x3d1)](0x2,![]);return new Rectangle(_0x41cbd9,_0x5846e1,_0x1666e4,_0xfa040);},Window_Message['prototype']['setChoiceListHelpWindow']=function(_0x2b3e68){const _0x4b05be=_0x571fe1;this[_0x4b05be(0x429)]=_0x2b3e68;},Window_Message[_0x571fe1(0x252)][_0x571fe1(0xfa)]=function(){const _0x3f8a7d=_0x571fe1;if(!this['_choiceListHelpWindow'])return;const _0x20ca98=this['_choiceListHelpWindow'];_0x20ca98&&('EAbhq'==='IgIco'?this[_0x3f8a7d(0x458)]=_0x53a16f:_0x20ca98['y']=this['y']>0x0?0x0:Graphics['boxHeight']-_0x20ca98[_0x3f8a7d(0x3e0)]);},VisuMZ['MessageCore'][_0x571fe1(0x430)]=Scene_Options[_0x571fe1(0x252)]['maxCommands'],Scene_Options[_0x571fe1(0x252)][_0x571fe1(0x4c0)]=function(){const _0x5353c1=_0x571fe1;let _0x4b3347=VisuMZ['MessageCore'][_0x5353c1(0x430)][_0x5353c1(0x323)](this);const _0x3b3ea8=VisuMZ[_0x5353c1(0x3f9)][_0x5353c1(0x49b)];if(_0x3b3ea8[_0x5353c1(0x31c)][_0x5353c1(0xec)]){if(_0x3b3ea8['Localization'][_0x5353c1(0xeb)]&&TextManager[_0x5353c1(0x3e5)]()){if('aPHDz'===_0x5353c1(0x2fc)){if(this[_0x5353c1(0x201)]===_0x1a75bc)this[_0x5353c1(0x305)]();if(this[_0x5353c1(0x201)][_0x5353c1(0x174)]===_0x2777df)this[_0x5353c1(0x305)]();this[_0x5353c1(0x201)][_0x5353c1(0x174)]=_0x507995||0x1;}else _0x4b3347++;}if(_0x3b3ea8[_0x5353c1(0x31c)]['AddOption'])_0x4b3347++;}return _0x4b3347;},VisuMZ[_0x571fe1(0x3f9)]['Sprite_Picture_updateBitmap']=Sprite_Picture[_0x571fe1(0x252)][_0x571fe1(0x3bb)],Sprite_Picture[_0x571fe1(0x252)]['updateBitmap']=function(){const _0x4589a2=_0x571fe1;VisuMZ[_0x4589a2(0x3f9)][_0x4589a2(0x3c7)][_0x4589a2(0x323)](this),this['createPictureText']();},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x215)]=Sprite_Picture[_0x571fe1(0x252)]['update'],Sprite_Picture[_0x571fe1(0x252)]['update']=function(){const _0x5c8042=_0x571fe1;VisuMZ[_0x5c8042(0x3f9)]['Sprite_Picture_update']['call'](this),this[_0x5c8042(0x123)]();},Sprite_Picture[_0x571fe1(0x252)][_0x571fe1(0x123)]=function(){const _0x131820=_0x571fe1;if(!this[_0x131820(0x47b)])return;this[_0x131820(0x337)](),this[_0x131820(0x2f0)](),this['drawPictureText'](),this[_0x131820(0x30d)]();},Sprite_Picture[_0x571fe1(0x252)][_0x571fe1(0x1aa)]=function(){const _0x2be265=_0x571fe1;if(this[_0x2be265(0x1a9)])return;if(this['_pictureTextSprite'])return;const _0x195e2f=new Rectangle(0x0,0x0,0x0,0x0);this[_0x2be265(0x1a9)]=new Window_Base(_0x195e2f),this['_pictureTextWindow']['padding']=0x0,this['_pictureTextSprite']=new Sprite(),this['addChildAt'](this[_0x2be265(0x18a)],0x0),this[_0x2be265(0x372)]=0x0,this[_0x2be265(0x332)]=0x0,this[_0x2be265(0x41d)]={};},Sprite_Picture[_0x571fe1(0x252)][_0x571fe1(0x337)]=function(){const _0x41d9fa=_0x571fe1;if(!this[_0x41d9fa(0x1a9)])return;if(this['_pictureTextWidth']===this[_0x41d9fa(0x481)]&&this[_0x41d9fa(0x332)]===this[_0x41d9fa(0x3e0)])return;this[_0x41d9fa(0x372)]=this[_0x41d9fa(0x481)],this[_0x41d9fa(0x332)]=this[_0x41d9fa(0x3e0)],this['_pictureTextCache']={},this[_0x41d9fa(0x1a9)][_0x41d9fa(0x4ff)](0x0,0x0,this[_0x41d9fa(0x481)],this[_0x41d9fa(0x3e0)]);},Sprite_Picture[_0x571fe1(0x252)]['anchorPictureText']=function(){const _0x2689c6=_0x571fe1;if(!this[_0x2689c6(0x18a)])return;this[_0x2689c6(0x18a)][_0x2689c6(0x114)]['x']=this[_0x2689c6(0x114)]['x'],this[_0x2689c6(0x18a)][_0x2689c6(0x114)]['y']=this[_0x2689c6(0x114)]['y'];},Sprite_Picture['prototype'][_0x571fe1(0x4a2)]=function(){const _0x31a444=_0x571fe1;if(!this[_0x31a444(0x1a9)])return;if(!this[_0x31a444(0x226)]())return;const _0x130f19=['upperleft','up','upperright',_0x31a444(0x402),_0x31a444(0x3ce),_0x31a444(0x236),_0x31a444(0x3d6),_0x31a444(0x10d),_0x31a444(0x519)];this['_pictureTextWindow']['createContents']();for(const _0x50f49f of _0x130f19){if('pVdVe'!==_0x31a444(0x489))this[_0x31a444(0x30b)](_0x50f49f);else{if(!_0x120650[_0x31a444(0x501)](_0x1de64b))return!![];}}},Sprite_Picture[_0x571fe1(0x252)]['anyPictureTextChanges']=function(){const _0x39434b=_0x571fe1;if($gameScreen[_0x39434b(0x200)](this[_0x39434b(0x4a5)]))return!![];const _0x2054d9=[_0x39434b(0x468),'up',_0x39434b(0x27d),_0x39434b(0x402),_0x39434b(0x3ce),'right','lowerleft','down','lowerright'];for(const _0x7f2595 of _0x2054d9){if(_0x39434b(0x126)!=='sCGdJ')!_0x1bc8dd['_interpreter']?this[_0x39434b(0x2ca)][_0x39434b(0x510)](_0x540b40):_0x13926c[_0x39434b(0x16a)]();else{const _0x6a9768=$gameScreen[_0x39434b(0x385)](this[_0x39434b(0x4a5)],_0x7f2595);if(this[_0x39434b(0x41d)][_0x7f2595]===_0x6a9768)continue;return!![];}}return![];},Sprite_Picture[_0x571fe1(0x252)]['drawPictureTextZone']=function(_0x4d8b07){const _0xcc9332=_0x571fe1;$gameScreen[_0xcc9332(0x3ea)](this[_0xcc9332(0x4a5)]);const _0x4dff04=$gameScreen[_0xcc9332(0x385)](this[_0xcc9332(0x4a5)],_0x4d8b07);this['_pictureTextCache'][_0x4d8b07]=_0x4dff04;const _0x1556c5=this[_0xcc9332(0x1a9)][_0xcc9332(0x2ff)](_0x4dff04);let _0x5d19be=$gameScreen[_0xcc9332(0x2f1)](this[_0xcc9332(0x4a5)]),_0x477711=_0x5d19be,_0xd2473d=_0x5d19be;if(['up','center','down'][_0xcc9332(0x297)](_0x4d8b07))_0x477711=Math[_0xcc9332(0x18f)]((this[_0xcc9332(0x481)]-_0x1556c5[_0xcc9332(0x481)])/0x2);else[_0xcc9332(0x27d),_0xcc9332(0x236),'lowerright'][_0xcc9332(0x297)](_0x4d8b07)&&(_0x477711=Math[_0xcc9332(0x18f)](this[_0xcc9332(0x481)]-_0x1556c5[_0xcc9332(0x481)]-_0x5d19be));if(['left',_0xcc9332(0x3ce),_0xcc9332(0x236)][_0xcc9332(0x297)](_0x4d8b07))'jKxWH'!==_0xcc9332(0x24c)?_0x5b98c4=_0x372c1b(_0x18029b['$2'])[_0xcc9332(0x2a1)]():_0xd2473d=Math['floor']((this[_0xcc9332(0x3e0)]-_0x1556c5[_0xcc9332(0x3e0)])/0x2);else[_0xcc9332(0x3d6),_0xcc9332(0x10d),_0xcc9332(0x519)][_0xcc9332(0x297)](_0x4d8b07)&&(_0xd2473d=Math[_0xcc9332(0x18f)](this[_0xcc9332(0x3e0)]-_0x1556c5[_0xcc9332(0x3e0)]-_0x5d19be));this['_pictureTextWindow'][_0xcc9332(0x3bc)](_0x4dff04,_0x477711,_0xd2473d);},Sprite_Picture[_0x571fe1(0x252)]['attachPictureText']=function(){const _0x582952=_0x571fe1;if(!this[_0x582952(0x1a9)])return;if(!this[_0x582952(0x18a)])return;this[_0x582952(0x18a)][_0x582952(0x128)]=this['_pictureTextWindow'][_0x582952(0x102)];},VisuMZ[_0x571fe1(0x3f9)]['Window_Base_initialize']=Window_Base[_0x571fe1(0x252)]['initialize'],Window_Base[_0x571fe1(0x252)][_0x571fe1(0x49f)]=function(_0x18d6c8){const _0x1e4e31=_0x571fe1;this[_0x1e4e31(0x305)](_0x18d6c8),VisuMZ['MessageCore'][_0x1e4e31(0x42f)][_0x1e4e31(0x323)](this,_0x18d6c8);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x305)]=function(_0x368be3){const _0x30b991=_0x571fe1;this[_0x30b991(0x439)](),this[_0x30b991(0x3c2)](),this[_0x30b991(0x136)](_0x368be3);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x439)]=function(){const _0x452ee3=_0x571fe1;this[_0x452ee3(0x165)](_0x452ee3(0x2ed));},Window_Base['prototype'][_0x571fe1(0x165)]=function(_0x1458ac){const _0x296ad5=_0x571fe1;this[_0x296ad5(0x27b)]=_0x1458ac;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x2f2)]=function(){const _0x164da7=_0x571fe1;return this[_0x164da7(0x27b)];},VisuMZ[_0x571fe1(0x3f9)]['Window_Base_textSizeEx']=Window_Base[_0x571fe1(0x252)]['textSizeEx'],Window_Base[_0x571fe1(0x252)][_0x571fe1(0x2ff)]=function(_0x357c0f){const _0x4b32fd=_0x571fe1;return this['resetWordWrap'](),VisuMZ['MessageCore'][_0x4b32fd(0x261)]['call'](this,_0x357c0f);},Window_Base[_0x571fe1(0x252)]['textSizeExRaw']=function(_0x769756){const _0x43dd7f=_0x571fe1;return VisuMZ[_0x43dd7f(0x3f9)][_0x43dd7f(0x261)]['call'](this,_0x769756);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x4d3)]=Window_Base['prototype'][_0x571fe1(0x40b)],Window_Base['prototype'][_0x571fe1(0x40b)]=function(_0x17da33){const _0xf0613b=_0x571fe1;VisuMZ[_0xf0613b(0x3f9)]['Window_Base_processAllText'][_0xf0613b(0x323)](this,_0x17da33);if(_0x17da33[_0xf0613b(0x1be)])this[_0xf0613b(0x165)](_0xf0613b(0x2ed));},Window_Base[_0x571fe1(0x252)]['resetWordWrap']=function(){this['setWordWrap'](![]);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0xee)]=function(){const _0x2cd32d=_0x571fe1;return this[_0x2cd32d(0xd6)];},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x2bc)]=function(_0x536ec8){return this['_wordWrap']=_0x536ec8,'';},Window_Base[_0x571fe1(0x252)]['registerResetRect']=function(_0x477181){const _0x4d01c6=_0x571fe1;this[_0x4d01c6(0x1b7)]=JsonEx[_0x4d01c6(0x3ae)](_0x477181);},Window_Base[_0x571fe1(0x252)]['resetFontSettings']=function(){const _0x4ba5b7=_0x571fe1;this[_0x4ba5b7(0x102)]['fontFace']=$gameSystem[_0x4ba5b7(0x2da)](),this['contents']['fontSize']=$gameSystem[_0x4ba5b7(0x17c)](),this[_0x4ba5b7(0x102)][_0x4ba5b7(0x2bf)]=![],this[_0x4ba5b7(0x102)][_0x4ba5b7(0x4d1)]=![],this[_0x4ba5b7(0x26a)]();},Window_Base[_0x571fe1(0x252)]['resetTextColor']=function(){const _0x5af5e8=_0x571fe1;this[_0x5af5e8(0x27c)](ColorManager['normalColor']()),this[_0x5af5e8(0x422)](ColorManager[_0x5af5e8(0x1c9)]());const _0x38a81b=VisuMZ[_0x5af5e8(0x3f9)][_0x5af5e8(0x49b)]['General'];if(_0x38a81b[_0x5af5e8(0x36e)]===undefined){if(_0x5af5e8(0x1d6)!==_0x5af5e8(0x4e8))_0x38a81b[_0x5af5e8(0x36e)]=0x3;else{this[_0x5af5e8(0x4cb)]=this[_0x5af5e8(0xd9)];if(this['_textDelay']<=0x0)this[_0x5af5e8(0x225)]=!![];}}this['contents'][_0x5af5e8(0x312)]=_0x38a81b[_0x5af5e8(0x36e)],this[_0x5af5e8(0x3e8)](![]);},Window_Base[_0x571fe1(0x252)]['setColorLock']=function(_0x33796b){const _0x25ff16=_0x571fe1;this[_0x25ff16(0x152)]=_0x33796b;},Window_Base['prototype']['isColorLocked']=function(){return this['_colorLock'];},Window_Base['prototype'][_0x571fe1(0x34d)]=function(){return![];},Window_Base['prototype']['getPreservedFontSettings']=function(){const _0x5d08a3=_0x571fe1,_0x31567d=[_0x5d08a3(0x351),_0x5d08a3(0x149),_0x5d08a3(0x2bf),_0x5d08a3(0x4d1),'textColor',_0x5d08a3(0x3eb),_0x5d08a3(0x312),_0x5d08a3(0x4ad)];let _0x1738fc={};for(const _0x564a9b of _0x31567d){if(_0x5d08a3(0x4b6)===_0x5d08a3(0x4f5)){if(!_0x5afd4c[_0x5d08a3(0x501)](_0x12e6f5))return![];}else _0x1738fc[_0x564a9b]=this[_0x5d08a3(0x102)][_0x564a9b];}return _0x1738fc;},Window_Base[_0x571fe1(0x252)]['returnPreservedFontSettings']=function(_0x488fda){const _0x4fdca2=_0x571fe1;for(const _0x5534c8 in _0x488fda){this[_0x4fdca2(0x102)][_0x5534c8]=_0x488fda[_0x5534c8];}},VisuMZ[_0x571fe1(0x3f9)]['Window_Base_update']=Window_Base[_0x571fe1(0x252)][_0x571fe1(0x16a)],Window_Base[_0x571fe1(0x252)][_0x571fe1(0x16a)]=function(){const _0xef5d8a=_0x571fe1;VisuMZ[_0xef5d8a(0x3f9)][_0xef5d8a(0xe8)][_0xef5d8a(0x323)](this),this['updateMove']();},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x1ac)]=function(){return![];},Window_Base['prototype'][_0x571fe1(0x4c9)]=function(){const _0x2458d6=_0x571fe1;this['_moveDuration']>0x0&&(_0x2458d6(0x1f2)!==_0x2458d6(0x469)?(this[_0x2458d6(0x1ac)]()&&(this['x']=this['applyMoveEasing'](this['x'],this[_0x2458d6(0x306)]),this['y']=this['applyMoveEasing'](this['y'],this[_0x2458d6(0x2e0)]),this[_0x2458d6(0x481)]=this[_0x2458d6(0x21b)](this[_0x2458d6(0x481)],this['_moveTargetWidth']),this['height']=this[_0x2458d6(0x21b)](this['height'],this[_0x2458d6(0x4fc)]),this[_0x2458d6(0x493)]()),this['_moveDuration']--):(this['_helpWindow']['clear'](),this[_0x2458d6(0x350)][_0x2458d6(0x31b)]()));},Window_Base['prototype']['clampPlacementPosition']=function(_0x391fe7,_0x46c38b){const _0x3b4db5=_0x571fe1;!_0x391fe7&&(this[_0x3b4db5(0x481)]=Math[_0x3b4db5(0x38d)](this[_0x3b4db5(0x481)],Graphics[_0x3b4db5(0x481)]),this[_0x3b4db5(0x3e0)]=Math[_0x3b4db5(0x38d)](this[_0x3b4db5(0x3e0)],Graphics[_0x3b4db5(0x3e0)]));if(!_0x46c38b){const _0x54ba18=-(Math[_0x3b4db5(0x18f)](Graphics[_0x3b4db5(0x481)]-Graphics[_0x3b4db5(0x482)])/0x2),_0x265145=_0x54ba18+Graphics[_0x3b4db5(0x481)]-this[_0x3b4db5(0x481)],_0x14ae3b=-(Math[_0x3b4db5(0x18f)](Graphics['height']-Graphics[_0x3b4db5(0x18b)])/0x2),_0x119045=_0x14ae3b+Graphics[_0x3b4db5(0x3e0)]-this['height'];this['x']=this['x'][_0x3b4db5(0x374)](_0x54ba18,_0x265145),this['y']=this['y'][_0x3b4db5(0x374)](_0x14ae3b,_0x119045);}},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x21b)]=function(_0x933e5c,_0x4a4168){const _0x14a235=_0x571fe1,_0x20664a=this[_0x14a235(0x2a8)],_0x346759=this[_0x14a235(0x2d1)],_0x2b7c44=this['calcMoveEasing']((_0x346759-_0x20664a)/_0x346759),_0x377dcb=this[_0x14a235(0x251)]((_0x346759-_0x20664a+0x1)/_0x346759),_0x171502=(_0x933e5c-_0x4a4168*_0x2b7c44)/(0x1-_0x2b7c44);return _0x171502+(_0x4a4168-_0x171502)*_0x377dcb;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x251)]=function(_0x457358){const _0x56b78b=_0x571fe1,_0x2d8de4=0x2;switch(this[_0x56b78b(0x2bd)]){case 0x0:return _0x457358;case 0x1:return this['easeIn'](_0x457358,_0x2d8de4);case 0x2:return this[_0x56b78b(0xe9)](_0x457358,_0x2d8de4);case 0x3:return this[_0x56b78b(0x3e4)](_0x457358,_0x2d8de4);default:return Imported[_0x56b78b(0x48b)]?VisuMZ[_0x56b78b(0x21b)](_0x457358,this['_moveEasingType']):_0x457358;}},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x150)]=function(_0x461207,_0x32a979,_0x4dd0a5,_0x4df678,_0x4cf1a5,_0x576a71){const _0x1b19fe=_0x571fe1;this[_0x1b19fe(0x306)]=_0x461207,this['_moveTargetY']=_0x32a979,this['_moveTargetWidth']=_0x4dd0a5||this['width'],this['_moveTargetHeight']=_0x4df678||this['height'],this[_0x1b19fe(0x2a8)]=_0x4cf1a5||0x1;if(this[_0x1b19fe(0x2a8)]<=0x0)this[_0x1b19fe(0x2a8)]=0x1;this[_0x1b19fe(0x2d1)]=this[_0x1b19fe(0x2a8)],this[_0x1b19fe(0x2bd)]=_0x576a71||0x0;if(_0x4cf1a5<=0x0)this[_0x1b19fe(0x4c9)]();},Window_Base['prototype'][_0x571fe1(0x451)]=function(_0x43d3e4,_0x4f6243,_0x2ddfd7,_0x355eec,_0x24fedc,_0x25130c){const _0x132a24=_0x571fe1;this['_moveTargetX']=this['x']+_0x43d3e4,this[_0x132a24(0x2e0)]=this['y']+_0x4f6243,this[_0x132a24(0x28f)]=this[_0x132a24(0x481)]+(_0x2ddfd7||0x0),this[_0x132a24(0x4fc)]=this[_0x132a24(0x3e0)]+(_0x355eec||0x0),this['_moveDuration']=_0x24fedc||0x1;if(this[_0x132a24(0x2a8)]<=0x0)this[_0x132a24(0x2a8)]=0x1;this[_0x132a24(0x2d1)]=this[_0x132a24(0x2a8)],this['_moveEasingType']=_0x25130c||0x0;if(_0x24fedc<=0x0)this['updateMove']();},Window_Base[_0x571fe1(0x252)]['resetRect']=function(_0x191bb1,_0x2970f8){const _0x27ff42=_0x571fe1;this[_0x27ff42(0x150)](this[_0x27ff42(0x1b7)]['x'],this[_0x27ff42(0x1b7)]['y'],this[_0x27ff42(0x1b7)][_0x27ff42(0x481)],this[_0x27ff42(0x1b7)][_0x27ff42(0x3e0)],_0x191bb1,_0x2970f8);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2c4)]=Window_Base[_0x571fe1(0x252)][_0x571fe1(0x27c)],Window_Base[_0x571fe1(0x252)]['changeTextColor']=function(_0x3d1d75){const _0x3fa241=_0x571fe1;if(this[_0x3fa241(0x2e3)]())return;_0x3d1d75=_0x3d1d75[_0x3fa241(0x3e9)](/\,/g,''),this[_0x3fa241(0x3c3)]=this[_0x3fa241(0x3c3)]||[],this[_0x3fa241(0x3c3)][_0x3fa241(0xef)](this[_0x3fa241(0x102)][_0x3fa241(0x4d4)]),VisuMZ[_0x3fa241(0x3f9)][_0x3fa241(0x2c4)]['call'](this,_0x3d1d75);},Window_Base['prototype']['processPreviousColor']=function(_0xfc8dc5){const _0x57e25d=_0x571fe1;this[_0x57e25d(0x163)](_0xfc8dc5);if(this[_0x57e25d(0x2e3)]())return;_0xfc8dc5[_0x57e25d(0x1be)]&&(this[_0x57e25d(0x3c3)]=this['_textColorStack']||[],this[_0x57e25d(0x102)][_0x57e25d(0x4d4)]=this[_0x57e25d(0x3c3)][_0x57e25d(0xf5)]()||ColorManager[_0x57e25d(0x445)]());},Window_Base[_0x571fe1(0x252)]['convertEscapeCharacters']=function(_0x25125f){const _0x2d1cd5=_0x571fe1;return _0x25125f=this[_0x2d1cd5(0x3e6)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x23d)](_0x25125f),_0x25125f=this['convertVariableEscapeCharacters'](_0x25125f),_0x25125f=this[_0x2d1cd5(0x185)](_0x25125f),_0x25125f=this['preConvertEscapeCharacters'](_0x25125f),_0x25125f=this[_0x2d1cd5(0x4cf)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x4b9)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x14c)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x3be)](_0x25125f),_0x25125f=this['convertBaseEscapeCharacters'](_0x25125f),_0x25125f=this[_0x2d1cd5(0x118)](_0x25125f),_0x25125f=this['convertMessageCoreEscapeActions'](_0x25125f),_0x25125f=this['convertMessageCoreEscapeReplacements'](_0x25125f),_0x25125f=this[_0x2d1cd5(0x364)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x224)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x33c)](_0x25125f),_0x25125f=this[_0x2d1cd5(0x33d)](_0x25125f),_0x25125f;},Window_Base[_0x571fe1(0x252)]['convertTextMacros']=function(_0x5f261d){const _0x839d20=_0x571fe1;this[_0x839d20(0x37d)]=![];for(const _0x502be0 of VisuMZ['MessageCore']['Settings'][_0x839d20(0x22f)]){if(_0x839d20(0x42a)===_0x839d20(0x42a))_0x5f261d&&_0x5f261d[_0x839d20(0xf6)](_0x502be0[_0x839d20(0x3c4)])&&(_0x839d20(0x424)!=='vDpZD'?_0x233820[_0x839d20(0x183)]=_0x7477b8['TextJS']:(this['_textMacroFound']=!![],_0x5f261d=_0x5f261d[_0x839d20(0x3e9)](_0x502be0[_0x839d20(0x3c4)],_0x502be0[_0x839d20(0x183)][_0x839d20(0x239)](this))));else return _0x2e5a32=_0x1cfa39['replace'](/\<(?:BATTLE|CURRENT BATTLE) TARGET\>/gi,this[_0x839d20(0x401)]()),_0x4dbbab=_0x21ee0b['replace'](/\<(?:BATTLE|CURRENT BATTLE) (?:USER|SUBJECT)\>/gi,this[_0x839d20(0x1ef)]()),_0x169b01=_0xc6382[_0x839d20(0x3e9)](/\<(?:BATTLE|CURRENT BATTLE) (?:ITEM|SKILL|ACTION)\>/gi,this[_0x839d20(0x49c)](!![])),_0x462b58=_0x8ef5e0['replace'](/\<(?:BATTLE|CURRENT BATTLE) (?:ITEM|SKILL|ACTION) NAME\>/gi,this[_0x839d20(0x49c)](![])),_0x59aad1;}return _0x5f261d||'';},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x23d)]=function(_0xb2cb4c){const _0x460f98=_0x571fe1;return _0xb2cb4c=_0xb2cb4c[_0x460f98(0x3e9)](/\\/g,'\x1b'),_0xb2cb4c=_0xb2cb4c['replace'](/\x1b\x1b/g,'\x5c'),_0xb2cb4c;},Window_Base['prototype'][_0x571fe1(0x224)]=function(_0x1b904e){const _0x14b372=_0x571fe1;for(;;){if(_0x1b904e[_0x14b372(0xf6)](/\\V\[(\d+)\]/gi))_0x1b904e=_0x1b904e[_0x14b372(0x3e9)](/\\V\[(\d+)\]/gi,(_0x13715d,_0x54f21f)=>this[_0x14b372(0x23d)](String($gameVariables['value'](parseInt(_0x54f21f)))));else{if(_0x1b904e[_0x14b372(0xf6)](/\x1bV\[(\d+)\]/gi))_0x1b904e=_0x1b904e[_0x14b372(0x3e9)](/\x1bV\[(\d+)\]/gi,(_0x4efe49,_0x3fe38e)=>this[_0x14b372(0x23d)](String($gameVariables[_0x14b372(0x501)](parseInt(_0x3fe38e)))));else break;}}return _0x1b904e;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x185)]=function(_0x3a510a){const _0x1eb096=_0x571fe1;if(Imported[_0x1eb096(0x48b)]){if(_0x1eb096(0x4fd)==='OUKmu')_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Up (?:KEY|BUTTON)>/gi,this[_0x1eb096(0x2ea)]('up')),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Left (?:KEY|BUTTON)>/gi,this['convertButtonAssistText'](_0x1eb096(0x402))),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Right (?:KEY|BUTTON)>/gi,this[_0x1eb096(0x2ea)](_0x1eb096(0x236))),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Down (?:KEY|BUTTON)>/gi,this[_0x1eb096(0x2ea)](_0x1eb096(0x10d))),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Ok (?:KEY|BUTTON)>/gi,this['convertButtonAssistText']('ok')),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Cancel (?:KEY|BUTTON)>/gi,this['convertButtonAssistText'](_0x1eb096(0x1bc))),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Menu (?:KEY|BUTTON)>/gi,this[_0x1eb096(0x2ea)](_0x1eb096(0x1c4))),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<Shift (?:KEY|BUTTON)>/gi,this[_0x1eb096(0x2ea)]('shift')),_0x3a510a=_0x3a510a[_0x1eb096(0x3e9)](/<(?:PAGEUP|PAGE UP) (?:KEY|BUTTON)>/gi,this[_0x1eb096(0x2ea)](_0x1eb096(0x46a))),_0x3a510a=_0x3a510a['replace'](/<(?:PAGEDOWN|PAGEDN|PAGE DOWN) (?:KEY|BUTTON)>/gi,this['convertButtonAssistText'](_0x1eb096(0x11c)));else{_0x52f27b[_0x1eb096(0x3f9)][_0x1eb096(0x2c8)][_0x1eb096(0x323)](this,_0x1836ea);const _0x462f23=_0x41c85d[_0x1eb096(0x3f9)][_0x1eb096(0x49b)][_0x1eb096(0x1c7)];_0x132558['MessageCore']['CreateAutoColorFor'](_0x4583ed,_0x462f23[_0x1eb096(0x50c)]);}}return _0x3a510a;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x2ea)]=function(_0x375045){const _0x90481=_0x571fe1;let _0x1e6aea=TextManager['getInputButtonString'](_0x375045)||'';return _0x1e6aea=this['convertBackslashCharacters'](_0x1e6aea),_0x1e6aea=this[_0x90481(0x224)](_0x1e6aea),_0x1e6aea['trim']();},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x43a)]=function(_0x3b0e46){const _0x4998d7=_0x571fe1;return _0x3b0e46=this[_0x4998d7(0x2b0)](_0x3b0e46),this[_0x4998d7(0x19a)](),_0x3b0e46;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x2b0)]=function(_0x3e667d){const _0x2b899c=_0x571fe1;return _0x3e667d=TextManager[_0x2b899c(0x10b)](_0x3e667d),_0x3e667d;},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2a7)]=String[_0x571fe1(0x252)][_0x571fe1(0x3dd)],String[_0x571fe1(0x252)][_0x571fe1(0x3dd)]=function(){const _0x1dad83=_0x571fe1;let _0x10510c=this;return _0x10510c=TextManager[_0x1dad83(0x10b)](_0x10510c),VisuMZ[_0x1dad83(0x3f9)][_0x1dad83(0x2a7)]['apply'](_0x10510c,arguments);},VisuMZ['MessageCore']['Bitmap_drawText']=Bitmap['prototype']['drawText'],Bitmap['prototype']['drawText']=function(_0x4d106a,_0x2f96df,_0x387328,_0xf80055,_0x448168,_0x3dffe3){const _0x599422=_0x571fe1;_0x4d106a=TextManager[_0x599422(0x10b)](_0x4d106a),VisuMZ[_0x599422(0x3f9)][_0x599422(0x3f1)]['call'](this,_0x4d106a,_0x2f96df,_0x387328,_0xf80055,_0x448168,_0x3dffe3);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x1a0)]=Bitmap[_0x571fe1(0x252)][_0x571fe1(0x2fd)],Bitmap[_0x571fe1(0x252)][_0x571fe1(0x2fd)]=function(_0x8faeb9,_0x1c2150,_0x1ef891,_0x4295f4,_0x3f8c63,_0x36cad5){const _0xb209b8=_0x571fe1;_0x8faeb9=TextManager[_0xb209b8(0x10b)](_0x8faeb9),VisuMZ[_0xb209b8(0x3f9)]['Bitmap_drawTextTopAligned'][_0xb209b8(0x323)](this,_0x8faeb9,_0x1c2150,_0x1ef891,_0x4295f4,_0x3f8c63,_0x36cad5);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x364)]=function(_0x4c9ef0){return _0x4c9ef0;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x4cf)]=function(_0x3d0e4f){const _0xdf0c22=_0x571fe1;if(this['isChoiceWindow']()){if('igIcD'!==_0xdf0c22(0x420))_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<(?:SHOW|HIDE|DISABLE|ENABLE)>/gi,''),_0x3d0e4f=_0x3d0e4f['replace'](/<(?:SHOW|HIDE|DISABLE|ENABLE)[ ](?:SWITCH|SWITCHES):[ ](.*?)>/gi,''),_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<(?:SHOW|HIDE|DISABLE|ENABLE)[ ](?:ALL|ANY)[ ](?:SWITCH|SWITCHES):[ ](.*?)>/gi,''),_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<CHOICE WIDTH:[ ](\d+)>/gi,''),_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<CHOICE INDENT:[ ](\d+)>/gi,''),_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<(?:BGCOLOR|BG COLOR):[ ](.*?)>/gi,''),_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<(?:FG|BG)(?:| )(?:IMG|IMAGE|PIC|PICTURE):[ ](.*?)>/gi,''),_0x3d0e4f=_0x3d0e4f[_0xdf0c22(0x3e9)](/<(?:FG|BG)(?:IMG|IMAGE|PIC|PICTURE)[ ]*(.*?):[ ](.*?)>/gi,'');else{this[_0xdf0c22(0x481)]=_0x2d47db[_0xdf0c22(0xfb)]()+this['addedWidth']();;this[_0xdf0c22(0x481)]=_0x3610ef['min'](_0x4b67f4[_0xdf0c22(0x481)],this[_0xdf0c22(0x481)]);const _0xf341e9=_0x5aa79a['getMessageWindowRows']();this['height']=_0x7a347e[_0xdf0c22(0x45c)]['calcWindowHeight'](_0xf341e9,![])+this[_0xdf0c22(0x393)](),this[_0xdf0c22(0x3e0)]=_0x517e0e['min'](_0x4c7045['height'],this[_0xdf0c22(0x3e0)]);if(_0x390aef['_centerMessageWindow'])this['resetPositionX']();}}return _0x3d0e4f;},Window_Base['prototype'][_0x571fe1(0x103)]=function(){const _0x4d6949=_0x571fe1,_0x52e111=[_0x4d6949(0x321),_0x4d6949(0x4ca)];return _0x52e111[_0x4d6949(0x297)](this['constructor']['name']);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x4b9)]=function(_0x20bd5c){const _0x4f972f=_0x571fe1;return _0x20bd5c=_0x20bd5c[_0x4f972f(0x3e9)](/<B>/gi,_0x4f972f(0x3c5)),_0x20bd5c=_0x20bd5c[_0x4f972f(0x3e9)](/<\/B>/gi,_0x4f972f(0xfe)),_0x20bd5c=_0x20bd5c['replace'](/<I>/gi,'\x1bITALIC[1]'),_0x20bd5c=_0x20bd5c[_0x4f972f(0x3e9)](/<\/I>/gi,_0x4f972f(0x2b7)),_0x20bd5c;},Window_Base[_0x571fe1(0x252)]['convertTextAlignmentEscapeCharacters']=function(_0x22e9eb){const _0x27dec9=_0x571fe1;return _0x22e9eb=_0x22e9eb[_0x27dec9(0x3e9)](/<LEFT>/gi,'\x1bTEXTALIGNMENT[1]'),_0x22e9eb=_0x22e9eb[_0x27dec9(0x3e9)](/<\/LEFT>/gi,_0x27dec9(0x173)),_0x22e9eb=_0x22e9eb[_0x27dec9(0x3e9)](/<CENTER>/gi,_0x27dec9(0x19f)),_0x22e9eb=_0x22e9eb['replace'](/<\/CENTER>/gi,_0x27dec9(0x173)),_0x22e9eb=_0x22e9eb[_0x27dec9(0x3e9)](/<RIGHT>/gi,_0x27dec9(0x105)),_0x22e9eb=_0x22e9eb[_0x27dec9(0x3e9)](/<\/RIGHT>/gi,_0x27dec9(0x173)),_0x22e9eb;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x3be)]=function(_0x308f59){const _0xf98d4a=_0x571fe1;return _0x308f59=_0x308f59['replace'](/<COLORLOCK>/gi,_0xf98d4a(0x485)),_0x308f59=_0x308f59['replace'](/<\/COLORLOCK>/gi,'\x1bCOLORLOCK[0]'),_0x308f59=_0x308f59[_0xf98d4a(0x3e9)](/\(\(\(/gi,_0xf98d4a(0x485)),_0x308f59=_0x308f59[_0xf98d4a(0x3e9)](/\)\)\)/gi,_0xf98d4a(0x255)),_0x308f59;},Window_Base['prototype'][_0x571fe1(0x37b)]=function(_0x3c4341){const _0x593400=_0x571fe1;return _0x3c4341=_0x3c4341['replace'](/\x1bN\[(\d+)\]/gi,(_0xe18a00,_0x324456)=>this['actorName'](parseInt(_0x324456))),_0x3c4341=_0x3c4341['replace'](/\x1bP\[(\d+)\]/gi,(_0x46c071,_0xa98941)=>this[_0x593400(0x14d)](parseInt(_0xa98941))),_0x3c4341=_0x3c4341['replace'](/\x1bG/gi,TextManager['currencyUnit']),_0x3c4341;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x118)]=function(_0x1b8efb){const _0x4ff733=_0x571fe1;return _0x1b8efb=_0x1b8efb[_0x4ff733(0x3e9)](/\<(?:BATTLE|CURRENT BATTLE) TARGET\>/gi,this[_0x4ff733(0x401)]()),_0x1b8efb=_0x1b8efb[_0x4ff733(0x3e9)](/\<(?:BATTLE|CURRENT BATTLE) (?:USER|SUBJECT)\>/gi,this['battleUserName']()),_0x1b8efb=_0x1b8efb[_0x4ff733(0x3e9)](/\<(?:BATTLE|CURRENT BATTLE) (?:ITEM|SKILL|ACTION)\>/gi,this[_0x4ff733(0x49c)](!![])),_0x1b8efb=_0x1b8efb['replace'](/\<(?:BATTLE|CURRENT BATTLE) (?:ITEM|SKILL|ACTION) NAME\>/gi,this[_0x4ff733(0x49c)](![])),_0x1b8efb;},Window_Base[_0x571fe1(0x252)]['battleTargetName']=function(){const _0x548ad9=_0x571fe1;if(!SceneManager[_0x548ad9(0x207)]())return'';if(BattleManager[_0x548ad9(0x1da)])return BattleManager['_target'][_0x548ad9(0x2cd)]();if(BattleManager[_0x548ad9(0x2d5)][0x0])return BattleManager['_targets'][0x0][_0x548ad9(0x2cd)]();return'';},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x1ef)]=function(){const _0x55f26e=_0x571fe1;if(!SceneManager[_0x55f26e(0x207)]())return'';let _0x506629=null;return _0x506629=BattleManager['_subject'],!_0x506629&&BattleManager['isInputting']()&&(_0x506629=BattleManager[_0x55f26e(0x29e)]()),_0x506629?_0x506629[_0x55f26e(0x2cd)]():'';},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x49c)]=function(_0x3d2ed1){const _0x384b36=_0x571fe1;if(!SceneManager[_0x384b36(0x207)]())return'';let _0x5cdc82=BattleManager[_0x384b36(0x487)]||null;if(!_0x5cdc82&&BattleManager[_0x384b36(0x4fa)]()){if(_0x384b36(0x17f)===_0x384b36(0x17f))_0x5cdc82=BattleManager[_0x384b36(0x25b)]();else{const _0x387c1a=this[_0x384b36(0x4d2)](_0x275c55);if(_0x387c1a){const _0x3c1a95=_0x124dcf['loadPicture'](_0x387c1a),_0x4615be=this[_0x384b36(0x1de)](),_0x34514b=_0x4615be+this[_0x384b36(0x1a7)](_0x1022e7),_0x414771=this[_0x384b36(0xe7)](_0x20affc);_0x3c1a95[_0x384b36(0x2aa)](this[_0x384b36(0x3ab)][_0x384b36(0x239)](this,_0x2437ab,!![],_0x34514b,_0x414771,_0x3c1a95));return;}this['drawItemContents'](_0x59ff25);}}if(_0x5cdc82&&_0x5cdc82[_0x384b36(0x1fb)]()){let _0x224c2e='';if(_0x3d2ed1)_0x224c2e+='\x1bI[%1]'[_0x384b36(0x3dd)](_0x5cdc82[_0x384b36(0x1fb)]()[_0x384b36(0x419)]);return _0x224c2e+=_0x5cdc82['item']()[_0x384b36(0x2cd)],_0x224c2e;}return'';},Window_Base['prototype']['convertMessageCoreEscapeActions']=function(_0x3e9bbe){const _0x308e3b=_0x571fe1;for(const _0x445bee of VisuMZ[_0x308e3b(0x3f9)][_0x308e3b(0x49b)][_0x308e3b(0x203)]){_0x3e9bbe[_0x308e3b(0xf6)](_0x445bee[_0x308e3b(0x3c4)])&&(_0x308e3b(0x222)!==_0x308e3b(0x392)?(_0x3e9bbe=_0x3e9bbe[_0x308e3b(0x3e9)](_0x445bee[_0x308e3b(0x3c4)],_0x445bee['textCodeResult']),_0x3e9bbe=this[_0x308e3b(0x224)](_0x3e9bbe)):_0x5f7093[_0x109e34]=this[_0x308e3b(0x102)][_0x5453aa]);}return _0x3e9bbe;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x41b)]=function(_0x4300f7){const _0x1486d3=_0x571fe1;for(const _0x151db5 of VisuMZ[_0x1486d3(0x3f9)][_0x1486d3(0x49b)][_0x1486d3(0x368)]){if(_0x4300f7[_0x1486d3(0xf6)](_0x151db5[_0x1486d3(0x3c4)])){if(_0x1486d3(0x1b5)!==_0x1486d3(0x1b5))return _0x1dc915;else _0x4300f7=_0x4300f7[_0x1486d3(0x3e9)](_0x151db5[_0x1486d3(0x3c4)],_0x151db5[_0x1486d3(0x183)][_0x1486d3(0x239)](this)),_0x4300f7=this[_0x1486d3(0x224)](_0x4300f7);}}return _0x4300f7;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x47c)]=function(_0x971e2c){const _0x38fdf5=_0x571fe1,_0x307623=_0x971e2c>=0x1?$gameActors[_0x38fdf5(0x29e)](_0x971e2c):null,_0x14d34f=_0x307623?_0x307623[_0x38fdf5(0x2cd)]():'',_0x4f2f48=Number(VisuMZ[_0x38fdf5(0x3f9)]['Settings'][_0x38fdf5(0x1c7)][_0x38fdf5(0x21e)]);return this[_0x38fdf5(0x34d)]()&&_0x4f2f48!==0x0?'\x1bC[%1]%2\x1bPREVCOLOR[0]'['format'](_0x4f2f48,_0x14d34f):_0x14d34f;},Window_Base['prototype']['partyMemberName']=function(_0x5ccbce){const _0x38dbe8=_0x571fe1,_0x310145=_0x5ccbce>=0x1?$gameParty[_0x38dbe8(0x390)]()[_0x5ccbce-0x1]:null,_0x4ba826=_0x310145?_0x310145['name']():'',_0x339935=Number(VisuMZ[_0x38dbe8(0x3f9)]['Settings'][_0x38dbe8(0x1c7)][_0x38dbe8(0x21e)]);return this[_0x38dbe8(0x34d)]()&&_0x339935!==0x0?_0x38dbe8(0x1c1)[_0x38dbe8(0x3dd)](_0x339935,_0x4ba826):_0x4ba826;},Window_Base[_0x571fe1(0x252)]['processAutoColorWords']=function(_0x4ff55f){const _0x367f67=_0x571fe1;return this['isAutoColorAffected']()&&(_0x4ff55f=this[_0x367f67(0x190)](_0x4ff55f),_0x4ff55f=this['processActorNameAutoColorChanges'](_0x4ff55f)),_0x4ff55f;},Window_Base[_0x571fe1(0x252)]['processStoredAutoColorChanges']=function(_0x18c8ac){const _0x202063=_0x571fe1;for(autoColor of VisuMZ[_0x202063(0x3f9)][_0x202063(0x124)]){if(_0x202063(0x38c)==='hQYWJ')return _0x2d9393;else _0x18c8ac=_0x18c8ac['replace'](autoColor[0x0],autoColor[0x1]);}return _0x18c8ac;},Window_Base[_0x571fe1(0x252)]['clearActorNameAutoColor']=function(){const _0x547c57=_0x571fe1;this[_0x547c57(0x249)]=[];},Window_Base['prototype']['registerActorNameAutoColorChanges']=function(){const _0x5b18fc=_0x571fe1;this[_0x5b18fc(0x22c)]();const _0x2c7b11=VisuMZ[_0x5b18fc(0x3f9)][_0x5b18fc(0x49b)]['AutoColor'],_0x1b6982=_0x2c7b11[_0x5b18fc(0x21e)];if(_0x1b6982<=0x0)return;for(const _0x525374 of $gameActors['_data']){if(_0x5b18fc(0x383)===_0x5b18fc(0x131)){const _0x57a635=_0x24e518['MessageCore']['ConfigManager_makeData'][_0x5b18fc(0x323)](this);return _0x39f4c4[_0x5b18fc(0x3e5)]()&&(_0x57a635[_0x5b18fc(0x211)]=this['textLocale']),_0x57a635[_0x5b18fc(0x28b)]=this[_0x5b18fc(0x28b)],_0x57a635;}else{if(!_0x525374)continue;const _0x1ca8dc=_0x525374[_0x5b18fc(0x2cd)]();if(_0x1ca8dc[_0x5b18fc(0x2a1)]()['length']<=0x0)continue;if(/^\d+$/[_0x5b18fc(0x431)](_0x1ca8dc))continue;if(_0x1ca8dc[_0x5b18fc(0xf6)](/-----/i))continue;let _0x666948=VisuMZ[_0x5b18fc(0x3f9)][_0x5b18fc(0x253)](_0x1ca8dc);const _0x4b92dd=new RegExp('\x5cb'+_0x666948+'\x5cb','g'),_0x1b4471='\x1bC[%1]%2\x1bPREVCOLOR[0]'['format'](_0x1b6982,_0x1ca8dc);this['_autoColorActorNames'][_0x5b18fc(0x491)]([_0x4b92dd,_0x1b4471]);}}},Window_Base['prototype'][_0x571fe1(0x1fa)]=function(_0x4b31b1){const _0x3da6a7=_0x571fe1;this[_0x3da6a7(0x249)]===undefined&&this[_0x3da6a7(0x19a)]();for(autoColor of this['_autoColorActorNames']){_0x4b31b1=_0x4b31b1[_0x3da6a7(0x3e9)](autoColor[0x0],autoColor[0x1]);}return _0x4b31b1;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x409)]=function(_0x2dc908,_0x1b5622,_0x17dcda){const _0x5add8b=_0x571fe1;if(!_0x2dc908)return'';const _0x1e1a0e=_0x2dc908[_0x1b5622];let _0x4358ec='';if(_0x1e1a0e&&_0x17dcda&&_0x1e1a0e['iconIndex']){if(_0x5add8b(0x127)==='YZWnU')return![];else{const _0xc39fea='\x1bi[%1]%2';_0x4358ec=_0xc39fea[_0x5add8b(0x3dd)](_0x1e1a0e[_0x5add8b(0x419)],_0x1e1a0e[_0x5add8b(0x2cd)]);}}else _0x1e1a0e?_0x5add8b(0x1b6)!==_0x5add8b(0x22e)?_0x4358ec=_0x1e1a0e[_0x5add8b(0x2cd)]:(this['_messagePositionReset']=![],this[_0x5add8b(0x458)]=_0xe6fec7,_0x2c24ba[_0x5add8b(0x305)](),this[_0x5add8b(0x308)](),this[_0x5add8b(0x148)]=0x0):_0x5add8b(0x437)===_0x5add8b(0x437)?_0x4358ec='':_0x50f9d7[_0x5add8b(0xf6)](/<CHOICE WIDTH:[ ](\d+)>/gi)&&(_0x4b1faf=_0x5cc550[_0x5add8b(0x3f5)](_0x2402ed,_0x3c5f76(_0x359244['$1'])));return this['isAutoColorAffected']()&&('lCovj'===_0x5add8b(0x44b)?(_0xeebf10=_0x4c45fc['replace'](_0x6f6dac[_0x5add8b(0x3c4)],_0x22db55['textCodeResult']),_0x5140e4=this[_0x5add8b(0x224)](_0x452e76)):_0x4358ec=this['applyDatabaseAutoColor'](_0x4358ec,_0x2dc908)),_0x4358ec;},Window_Base[_0x571fe1(0x252)]['lastGainedObjectIcon']=function(){const _0x1de732=_0x571fe1,_0x856ab9=$gameParty[_0x1de732(0x3b7)]();if(_0x856ab9['id']<0x0)return'';let _0x50afec=null;if(_0x856ab9[_0x1de732(0x32c)]===0x0)_0x50afec=$dataItems[_0x856ab9['id']];if(_0x856ab9[_0x1de732(0x32c)]===0x1)_0x50afec=$dataWeapons[_0x856ab9['id']];if(_0x856ab9[_0x1de732(0x32c)]===0x2)_0x50afec=$dataArmors[_0x856ab9['id']];if(!_0x50afec)return'';return _0x1de732(0x40d)[_0x1de732(0x3dd)](_0x50afec[_0x1de732(0x419)]);},Window_Base['prototype']['lastGainedObjectName']=function(_0x135ee8){const _0x56eccf=_0x571fe1,_0x31e198=$gameParty[_0x56eccf(0x3b7)]();if(_0x31e198['id']<0x0)return'';let _0xf62de=null;if(_0x31e198[_0x56eccf(0x32c)]===0x0)_0xf62de=$dataItems[_0x31e198['id']];if(_0x31e198[_0x56eccf(0x32c)]===0x1)_0xf62de=$dataWeapons[_0x31e198['id']];if(_0x31e198['type']===0x2)_0xf62de=$dataArmors[_0x31e198['id']];if(!_0xf62de)return'';return _0x135ee8?_0x56eccf(0x35c)[_0x56eccf(0x3dd)](_0xf62de[_0x56eccf(0x419)],_0xf62de[_0x56eccf(0x2cd)]):_0xf62de[_0x56eccf(0x2cd)];},Window_Base[_0x571fe1(0x252)]['lastGainedObjectQuantity']=function(){const _0x3aaf76=_0x571fe1,_0x1ab99d=$gameParty[_0x3aaf76(0x3b7)]();if(_0x1ab99d['id']<=0x0)return'';return _0x1ab99d[_0x3aaf76(0x406)];},Window_Base[_0x571fe1(0x252)]['applyDatabaseAutoColor']=function(_0x2c2876,_0x2143b2){const _0x59ff06=_0x571fe1,_0x4f6ab3=VisuMZ[_0x59ff06(0x3f9)][_0x59ff06(0x49b)][_0x59ff06(0x1c7)];let _0x5b175c=0x0;if(_0x2143b2===$dataActors)_0x5b175c=_0x4f6ab3[_0x59ff06(0x21e)];if(_0x2143b2===$dataClasses)_0x5b175c=_0x4f6ab3['Classes'];if(_0x2143b2===$dataSkills)_0x5b175c=_0x4f6ab3[_0x59ff06(0x502)];if(_0x2143b2===$dataItems)_0x5b175c=_0x4f6ab3['Items'];if(_0x2143b2===$dataWeapons)_0x5b175c=_0x4f6ab3['Weapons'];if(_0x2143b2===$dataArmors)_0x5b175c=_0x4f6ab3[_0x59ff06(0x467)];if(_0x2143b2===$dataEnemies)_0x5b175c=_0x4f6ab3[_0x59ff06(0x4c1)];if(_0x2143b2===$dataStates)_0x5b175c=_0x4f6ab3[_0x59ff06(0xf4)];if(_0x5b175c>0x0){if(_0x59ff06(0x39a)===_0x59ff06(0x37f))return _0xf321a5[_0x59ff06(0x252)][_0x59ff06(0x3e6)][_0x59ff06(0x323)](this,_0x3927fa);else _0x2c2876='\x1bC[%1]%2\x1bPREVCOLOR[0]'[_0x59ff06(0x3dd)](_0x5b175c,_0x2c2876);}return _0x2c2876;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x33d)]=function(_0x102eca){const _0x438ffa=_0x571fe1;if(_0x102eca[_0x438ffa(0x297)](_0x438ffa(0x2ef)))return this[_0x438ffa(0x2bc)](![]),_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<(?:BR|LINEBREAK)>/gi,'\x20\x0a'),_0x102eca;_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<(?:WORDWRAP|WORD WRAP)>/gi,(_0x4149c0,_0x2bcc0e)=>this[_0x438ffa(0x2bc)](!![])),_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<(?:NOWORDWRAP|NO WORD WRAP)>/gi,(_0x253b88,_0x12285)=>this[_0x438ffa(0x2bc)](![])),_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<\/(?:WORDWRAP|WORD WRAP)>/gi,(_0x28de67,_0x4641f7)=>this[_0x438ffa(0x2bc)](![]));if(_0x102eca['match'](Window_Message[_0x438ffa(0x1d4)]))this[_0x438ffa(0x2bc)](![]);else _0x102eca[_0x438ffa(0xf6)](Window_Message[_0x438ffa(0x232)])&&this['setWordWrap'](![]);if(!this[_0x438ffa(0xee)]())return _0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<(?:BR|LINEBREAK)>/gi,'\x20\x0a'),_0x102eca;if(_0x102eca[_0x438ffa(0x10a)]<=0x0)return _0x102eca;_0x102eca['match'](/[\u3040-\u30FF\u4E00-\u9FFF]/g)&&(_0x438ffa(0x41a)===_0x438ffa(0x23f)?this[_0x438ffa(0x2ca)][_0x438ffa(0x510)](_0x278ad8):_0x102eca=VisuMZ[_0x438ffa(0x3f9)][_0x438ffa(0x1ba)](_0x102eca)[_0x438ffa(0x369)](''));if(VisuMZ['MessageCore']['Settings'][_0x438ffa(0x2c2)]['LineBreakSpace']){if('qfMig'!==_0x438ffa(0x283)){if(!_0x15f0a3)return;this[_0x438ffa(0x47e)]=![],_0x25ebe[_0x438ffa(0x339)]=this[_0x438ffa(0x3e6)](_0x1fa8b8[_0x438ffa(0x339)]),this['_textMacroFound']&&(_0x5910ed[_0x438ffa(0x339)]=this[_0x438ffa(0x33d)](_0x313f99['text']),this['_macroBypassWordWrap']=!![]);}else _0x102eca=_0x102eca[_0x438ffa(0x3e9)](/[\n\r]+/g,'\x20'),_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<(?:BR|LINEBREAK)>/gi,'\x20\x0a');}else _0x438ffa(0x413)===_0x438ffa(0x166)?(_0x1130fe['MessageCore'][_0x438ffa(0x3c7)][_0x438ffa(0x323)](this),this[_0x438ffa(0x1aa)]()):(_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/[\n\r]+/g,''),_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<(?:BR|LINEBREAK)>/gi,'\x0a'));return _0x102eca=this[_0x438ffa(0xf7)](_0x102eca),_0x102eca=_0x102eca[_0x438ffa(0x234)]('\x20')['join'](_0x438ffa(0x46f)),_0x102eca=_0x102eca['replace'](/<(?:BR|LINEBREAK)>/gi,'\x0a'),_0x102eca=_0x102eca[_0x438ffa(0x3e9)](/<LINE\x1bWrapBreak[0]BREAK>/gi,'\x0a'),_0x102eca;},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x1ba)]=function(_0x3fcbaa){const _0x56db49=_0x571fe1;let _0x53b334=[],_0x3ae8a9='';while(_0x3fcbaa[_0x56db49(0x10a)]>0x0){if(_0x56db49(0x483)==='oxnlG')_0x4c5e89[_0x56db49(0x211)]=this[_0x56db49(0x211)];else{const _0x27c8a=_0x3fcbaa[_0x56db49(0x356)](0x0);_0x3fcbaa=_0x3fcbaa[_0x56db49(0x13a)](0x1);if(_0x27c8a[_0x56db49(0xf6)](/[\u3040-\u30FF\u4E00-\u9FFF]/g)){if(_0x56db49(0x13b)==='uBEVH'){const _0x537f9d=_0x2f7b68['prototype'][_0x56db49(0x3d9)][_0x56db49(0x323)](this,_0x217bdf);_0x4045d2[_0x56db49(0x1be)]&&this[_0x56db49(0x1b9)](_0x537f9d);}else _0x3ae8a9[_0x56db49(0x10a)]>0x0&&(_0x56db49(0x246)!=='ZyHUw'?_0x13f9d8=_0x255406(_0x2974e1['$1'])[_0x56db49(0x2a1)]():(_0x53b334[_0x56db49(0x491)](_0x3ae8a9),_0x3ae8a9='')),_0x53b334[_0x56db49(0x491)](_0x27c8a+_0x56db49(0x259));}else _0x3ae8a9+=_0x27c8a;}}return _0x3ae8a9[_0x56db49(0x10a)]>0x0&&(_0x53b334[_0x56db49(0x491)](_0x3ae8a9),_0x3ae8a9=''),_0x53b334;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0xf7)]=function(_0x30890d){return _0x30890d;},VisuMZ['MessageCore'][_0x571fe1(0x41c)]=Window_Base[_0x571fe1(0x252)][_0x571fe1(0x3a3)],Window_Base[_0x571fe1(0x252)]['processNewLine']=function(_0x5a8a09){const _0x19ccfc=_0x571fe1;VisuMZ['MessageCore']['Window_Base_processNewLine'][_0x19ccfc(0x323)](this,_0x5a8a09),this[_0x19ccfc(0x378)](_0x5a8a09);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x133)]=Window_Base['prototype']['processControlCharacter'],Window_Base['prototype']['processControlCharacter']=function(_0x3e8ab0,_0x22ac11){const _0x19948c=_0x571fe1;VisuMZ[_0x19948c(0x3f9)][_0x19948c(0x133)][_0x19948c(0x323)](this,_0x3e8ab0,_0x22ac11);if(_0x22ac11==='\x1bWrapBreak[0]')this[_0x19948c(0x3fd)](_0x3e8ab0);else _0x22ac11==='\x1bWrapJpBreak[0]'&&this['processWrapBreak'](_0x3e8ab0,!![]);},Window_Base['prototype'][_0x571fe1(0x2eb)]=function(_0x73249){const _0x57a726=_0x571fe1;var _0x46621c=/^\<(.*?)\>/['exec'](_0x73249[_0x57a726(0x339)][_0x57a726(0x13a)](_0x73249[_0x57a726(0x497)]));return _0x46621c?(_0x73249[_0x57a726(0x497)]+=_0x46621c[0x0]['length'],String(_0x46621c[0x0][_0x57a726(0x13a)](0x1,_0x46621c[0x0][_0x57a726(0x10a)]-0x1))):_0x57a726(0x444)!=='nOYMB'?(this[_0x57a726(0x2bc)](![]),_0x46fb5a=_0x2704dc[_0x57a726(0x3e9)](/<(?:BR|LINEBREAK)>/gi,'\x20\x0a'),_0x3773aa):'';},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2be)]=Window_Base[_0x571fe1(0x252)]['processEscapeCharacter'],Window_Base[_0x571fe1(0x252)][_0x571fe1(0x404)]=function(_0x154935,_0x2b119a){const _0x44d17d=_0x571fe1;switch(_0x154935){case'C':_0x2b119a[_0x44d17d(0x1be)]?VisuMZ[_0x44d17d(0x3f9)]['Window_Base_processEscapeCharacter']['call'](this,_0x154935,_0x2b119a):this['obtainEscapeParam'](_0x2b119a);break;case'I':case'{':case'}':VisuMZ[_0x44d17d(0x3f9)]['Window_Base_processEscapeCharacter']['call'](this,_0x154935,_0x2b119a);break;case'FS':this['processFsTextCode'](_0x2b119a);break;case'PX':this[_0x44d17d(0x4a3)](_0x2b119a);break;case'PY':this[_0x44d17d(0x2d0)](_0x2b119a);break;case _0x44d17d(0x40c):this[_0x44d17d(0x17e)](this['obtainEscapeParam'](_0x2b119a));break;case _0x44d17d(0x348):this['processDrawCenteredPicture'](_0x2b119a);break;case _0x44d17d(0x509):this[_0x44d17d(0x474)](_0x2b119a);break;case'COMMONEVENT':this[_0x44d17d(0x3d9)](_0x2b119a);break;case _0x44d17d(0x216):this[_0x44d17d(0x45d)](this[_0x44d17d(0x163)](_0x2b119a));break;case _0x44d17d(0x4cc):this[_0x44d17d(0x186)](_0x2b119a);break;case _0x44d17d(0x1b4):this[_0x44d17d(0x39b)](_0x2b119a);break;case _0x44d17d(0x23b):this[_0x44d17d(0x1ad)](_0x2b119a);break;case'WAIT':this['processCustomWait'](_0x2b119a);break;case _0x44d17d(0x4d7):this['processWrapBreak'](_0x2b119a);break;case'WRAPJPBREAK':this[_0x44d17d(0x3fd)](_0x2b119a,!![]);break;default:this[_0x44d17d(0x4fb)](_0x154935,_0x2b119a);}},Window_Base['prototype'][_0x571fe1(0x4fb)]=function(_0x15a89e,_0x35d246){const _0x46134e=_0x571fe1;for(const _0x5d6e4f of VisuMZ[_0x46134e(0x3f9)]['Settings']['TextCodeActions']){if(_0x5d6e4f['Match']===_0x15a89e){if(_0x5d6e4f[_0x46134e(0x309)]==='')this[_0x46134e(0x163)](_0x35d246);_0x5d6e4f[_0x46134e(0x3f2)][_0x46134e(0x323)](this,_0x35d246);if(this['constructor']===Window_Message){const _0x1dd505=_0x5d6e4f[_0x46134e(0x2b1)]||0x0;if(_0x1dd505>0x0)this[_0x46134e(0x1b9)](_0x1dd505);}}}},Window_Base[_0x571fe1(0x252)]['makeFontBigger']=function(){const _0x339f77=_0x571fe1;this['contents'][_0x339f77(0x149)]+=VisuMZ[_0x339f77(0x3f9)][_0x339f77(0x49b)]['General'][_0x339f77(0x3f4)],this[_0x339f77(0x102)][_0x339f77(0x149)]=Math[_0x339f77(0x38d)](this['contents'][_0x339f77(0x149)],VisuMZ[_0x339f77(0x3f9)][_0x339f77(0x49b)][_0x339f77(0x35f)]['FontBiggerCap']);},Window_Base['prototype'][_0x571fe1(0x4f7)]=function(){const _0x349d4c=_0x571fe1;this[_0x349d4c(0x102)][_0x349d4c(0x149)]-=VisuMZ[_0x349d4c(0x3f9)][_0x349d4c(0x49b)][_0x349d4c(0x35f)][_0x349d4c(0x3f4)],this['contents'][_0x349d4c(0x149)]=Math[_0x349d4c(0x3f5)](this[_0x349d4c(0x102)]['fontSize'],VisuMZ[_0x349d4c(0x3f9)][_0x349d4c(0x49b)][_0x349d4c(0x35f)][_0x349d4c(0x38a)]);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x3bd)]=function(_0x244b2d){const _0x4e0876=_0x571fe1,_0x2b1d03=this[_0x4e0876(0x163)](_0x244b2d);this[_0x4e0876(0x102)][_0x4e0876(0x149)]=_0x2b1d03['clamp'](VisuMZ[_0x4e0876(0x3f9)][_0x4e0876(0x49b)]['General']['FontSmallerCap'],VisuMZ[_0x4e0876(0x3f9)][_0x4e0876(0x49b)][_0x4e0876(0x35f)][_0x4e0876(0x285)]);},Window_Base[_0x571fe1(0x252)]['maxFontSizeInLine']=function(_0x290a47){const _0x2d3c4e=_0x571fe1;let _0x391b47=this['contents']['fontSize'];const _0x476e9f=/\x1b({|}|FS)(\[(\d+)])?/gi;for(;;){if(_0x2d3c4e(0x508)===_0x2d3c4e(0x281))this[_0x2d3c4e(0x2d2)]();else{const _0x259b24=_0x476e9f[_0x2d3c4e(0x3d3)](_0x290a47);if(!_0x259b24)break;const _0x457ce7=String(_0x259b24[0x1])[_0x2d3c4e(0x3b8)]();if(_0x457ce7==='{'){if(_0x2d3c4e(0x26f)==='XpLWX'){_0x2c2b98[_0x2d3c4e(0x50d)](_0x45232f,_0x1bbe06);const _0x8b16ee=_0x594516(_0x3251ac[_0x2d3c4e(0x2cb)])||0x0;_0x38db06[_0x2d3c4e(0x318)](_0x8b16ee);}else this[_0x2d3c4e(0x193)]();}else{if(_0x457ce7==='}')this[_0x2d3c4e(0x4f7)]();else _0x457ce7==='FS'&&(this[_0x2d3c4e(0x102)]['fontSize']=parseInt(_0x259b24[0x3])[_0x2d3c4e(0x374)](VisuMZ[_0x2d3c4e(0x3f9)][_0x2d3c4e(0x49b)][_0x2d3c4e(0x35f)][_0x2d3c4e(0x38a)],VisuMZ['MessageCore']['Settings'][_0x2d3c4e(0x35f)]['FontBiggerCap']));}this[_0x2d3c4e(0x102)]['fontSize']>_0x391b47&&(_0x391b47=this[_0x2d3c4e(0x102)][_0x2d3c4e(0x149)]);}}return _0x391b47;},Window_Base['prototype']['processPxTextCode']=function(_0x291dbc){const _0x6dd88c=_0x571fe1;_0x291dbc['x']=this[_0x6dd88c(0x163)](_0x291dbc),VisuMZ[_0x6dd88c(0x3f9)]['Settings'][_0x6dd88c(0x35f)][_0x6dd88c(0x50e)]&&(_0x291dbc['x']+=_0x291dbc[_0x6dd88c(0x12d)]);},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x2d0)]=function(_0x112019){const _0x52ebe0=_0x571fe1;_0x112019['y']=this[_0x52ebe0(0x163)](_0x112019);if(VisuMZ[_0x52ebe0(0x3f9)][_0x52ebe0(0x49b)][_0x52ebe0(0x35f)][_0x52ebe0(0x50e)]){if(_0x52ebe0(0x2c1)!=='MMiMJ')_0x112019['y']+=_0x112019[_0x52ebe0(0x432)];else{const _0x2cdc15=_0x27f6bc['$1']['split'](',')['map'](_0x108f63=>_0x3d940e(_0x108f63)||0x0);for(const _0x2d0c1c of _0x2cdc15){if(!_0x2dd342[_0x52ebe0(0x501)](_0x2d0c1c))return![];}return!![];}}},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x17e)]=function(_0x203dd2){const _0x39228e=_0x571fe1;this['contents'][_0x39228e(0x2bf)]=!!_0x203dd2;},Window_Base['prototype']['processFontChangeItalic']=function(_0x323e48){const _0x16d549=_0x571fe1;this[_0x16d549(0x102)][_0x16d549(0x4d1)]=!!_0x323e48;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x1ad)]=function(_0x443112){const _0x3d63b0=_0x571fe1,_0x1399fa=this[_0x3d63b0(0x163)](_0x443112);if(!_0x443112[_0x3d63b0(0x1be)])return;switch(_0x1399fa){case 0x0:this['setTextAlignment'](_0x3d63b0(0x2ed));return;case 0x1:this[_0x3d63b0(0x165)](_0x3d63b0(0x402));break;case 0x2:this['setTextAlignment'](_0x3d63b0(0x3ce));break;case 0x3:this['setTextAlignment'](_0x3d63b0(0x236));break;}this['processTextAlignmentX'](_0x443112);},Window_Base['prototype'][_0x571fe1(0x378)]=function(_0x4ba191){const _0x309596=_0x571fe1;if(!_0x4ba191[_0x309596(0x1be)])return;if(_0x4ba191[_0x309596(0x3d8)])return;if(this[_0x309596(0x2f2)]()===_0x309596(0x2ed))return;let _0x2b7e50=_0x4ba191['text'][_0x309596(0x454)](_0x309596(0x2ef),_0x4ba191[_0x309596(0x497)]+0x1),_0x51cfb9=_0x4ba191['text'][_0x309596(0x454)]('\x0a',_0x4ba191['index']+0x1);if(_0x2b7e50<0x0)_0x2b7e50=_0x4ba191[_0x309596(0x339)][_0x309596(0x10a)]+0x1;if(_0x51cfb9>0x0)_0x2b7e50=Math[_0x309596(0x38d)](_0x2b7e50,_0x51cfb9);const _0x355836=_0x4ba191[_0x309596(0x339)][_0x309596(0x315)](_0x4ba191[_0x309596(0x497)],_0x2b7e50),_0x2f3c8b=this[_0x309596(0x367)](_0x355836)[_0x309596(0x481)],_0x22332f=_0x4ba191[_0x309596(0x481)]||this['innerWidth']-0x8,_0x8ab3fd=this[_0x309596(0x524)]===Window_Message&&$gameMessage[_0x309596(0x344)]()!=='';switch(this[_0x309596(0x2f2)]()){case _0x309596(0x402):_0x4ba191['x']=_0x4ba191[_0x309596(0x12d)];break;case _0x309596(0x3ce):_0x4ba191['x']=_0x4ba191['startX'],_0x4ba191['x']+=Math[_0x309596(0x18f)]((_0x22332f-_0x2f3c8b)/0x2);_0x8ab3fd&&(_0x4ba191['x']-=_0x4ba191[_0x309596(0x12d)]/0x2);break;case _0x309596(0x236):_0x4ba191['x']=_0x22332f-_0x2f3c8b+_0x4ba191[_0x309596(0x12d)];_0x8ab3fd&&(_0x4ba191['x']-=_0x4ba191[_0x309596(0x12d)]);break;}},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x367)]=function(_0x2b6c25){const _0x1e51c8=_0x571fe1;_0x2b6c25=_0x2b6c25['replace'](/\x1b!/g,''),_0x2b6c25=_0x2b6c25[_0x1e51c8(0x3e9)](/\x1b\|/g,''),_0x2b6c25=_0x2b6c25[_0x1e51c8(0x3e9)](/\x1b\./g,'');const _0x566939=this[_0x1e51c8(0x4a8)](_0x2b6c25,0x0,0x0,0x0),_0xdf8ce1=this[_0x1e51c8(0x2f3)]();return _0x566939[_0x1e51c8(0x1be)]=![],this[_0x1e51c8(0x40b)](_0x566939),this[_0x1e51c8(0x407)](_0xdf8ce1),{'width':_0x566939[_0x1e51c8(0x242)],'height':_0x566939[_0x1e51c8(0x494)]};},Window_Base[_0x571fe1(0x3b9)]=VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x49b)][_0x571fe1(0x2c2)]['EndPadding']||0x0,Window_Base[_0x571fe1(0x252)][_0x571fe1(0x3fd)]=function(_0x4d9019,_0x56c493){const _0x57d879=_0x571fe1,_0x57bd2c=(_0x4d9019[_0x57d879(0x3d8)]?-0x1:0x1)*this[_0x57d879(0x3d2)]('\x20');if(!_0x56c493)_0x4d9019['x']+=_0x57bd2c;if(this[_0x57d879(0x163)](_0x4d9019)>0x0&&!_0x56c493)_0x4d9019['x']+=_0x57bd2c;if(_0x4d9019[_0x57d879(0x3d8)])return;let _0xf4660d;_0x56c493?_0xf4660d=_0x4d9019['text'][_0x57d879(0x454)](_0x57d879(0x259),_0x4d9019[_0x57d879(0x497)]+0x1):_0xf4660d=_0x4d9019[_0x57d879(0x339)][_0x57d879(0x454)](_0x57d879(0x46f),_0x4d9019['index']+0x1);let _0x154ee1=_0x4d9019[_0x57d879(0x339)][_0x57d879(0x454)]('\x0a',_0x4d9019[_0x57d879(0x497)]+0x1);if(_0xf4660d<0x0)_0xf4660d=_0x4d9019[_0x57d879(0x339)][_0x57d879(0x10a)]+0x1;if(_0x154ee1>0x0)_0xf4660d=Math[_0x57d879(0x38d)](_0xf4660d,_0x154ee1);const _0x246b0f=_0x4d9019[_0x57d879(0x339)][_0x57d879(0x315)](_0x4d9019['index'],_0xf4660d),_0xe6a1eb=this['textSizeExWordWrap'](_0x246b0f)['width'];let _0x1791fd=_0x4d9019[_0x57d879(0x481)]||this[_0x57d879(0x290)];_0x1791fd-=Window_Base['WORD_WRAP_PADDING'];if(this['constructor']===Window_Message){if('EWHwl'==='EWHwl'){const _0xa0970c=$gameMessage[_0x57d879(0x344)]()===''?0x0:ImageManager[_0x57d879(0x333)]+0x14;_0x1791fd-=_0xa0970c;if(VisuMZ[_0x57d879(0x3f9)][_0x57d879(0x49b)][_0x57d879(0x2c2)]['TightWrap']){if('aesvy'==='zUKuu'){const _0x47543a=_0x49ca5d[_0x57d879(0x3b7)]();if(_0x47543a['id']<=0x0)return'';return _0x47543a[_0x57d879(0x406)];}else _0x1791fd-=_0xa0970c;}}else this['_textAlignment']=_0x5b83d9;}let _0x5b185c=![];_0x4d9019['x']+_0xe6a1eb>_0x4d9019[_0x57d879(0x12d)]+_0x1791fd&&(_0x5b185c=!![]),_0xe6a1eb===0x0&&(_0x5b185c=![]),_0x5b185c&&(_0x4d9019[_0x57d879(0x339)]=_0x4d9019[_0x57d879(0x339)][_0x57d879(0x13a)](0x0,_0x4d9019[_0x57d879(0x497)])+'\x0a'+_0x4d9019[_0x57d879(0x339)][_0x57d879(0x455)](_0x4d9019[_0x57d879(0x497)]));},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x480)]=function(_0x1ca08c){const _0x53bf34=_0x571fe1,_0x123680=this['createTextState'](_0x1ca08c,0x0,0x0,0x0),_0x4c0dcd=this[_0x53bf34(0x2f3)]();return _0x123680['drawing']=![],this[_0x53bf34(0x2bc)](![]),this[_0x53bf34(0x40b)](_0x123680),this['setWordWrap'](!![]),this[_0x53bf34(0x407)](_0x4c0dcd),{'width':_0x123680[_0x53bf34(0x242)],'height':_0x123680[_0x53bf34(0x494)]};},Window_Base['prototype'][_0x571fe1(0x3d9)]=function(_0x54ffdf){return this['obtainEscapeParam'](_0x54ffdf);},Window_Base['prototype'][_0x571fe1(0x186)]=function(_0x3ba200){const _0x237fed=_0x571fe1,_0x51bbeb=this[_0x237fed(0x2eb)](_0x3ba200)[_0x237fed(0x234)](',');if(!_0x3ba200['drawing'])return;const _0x11f0bd=_0x51bbeb[0x0][_0x237fed(0x2a1)](),_0x10abc0=_0x51bbeb[0x1]||0x0,_0x2f8fec=_0x51bbeb[0x2]||0x0,_0x203b78=ImageManager[_0x237fed(0x153)](_0x11f0bd),_0x54df7f=this[_0x237fed(0x102)][_0x237fed(0x4ad)];_0x203b78['addLoadListener'](this['drawBackPicture']['bind'](this,_0x203b78,_0x3ba200['x'],_0x3ba200['y'],_0x10abc0,_0x2f8fec,_0x54df7f));},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x301)]=function(_0x409964,_0x19a5b2,_0x217ece,_0x298007,_0x12387a,_0x1df2a1){const _0x44410d=_0x571fe1;_0x298007=_0x298007||_0x409964[_0x44410d(0x481)],_0x12387a=_0x12387a||_0x409964['height'],this['contentsBack'][_0x44410d(0x4ad)]=_0x1df2a1,this['contentsBack'][_0x44410d(0x14a)](_0x409964,0x0,0x0,_0x409964['width'],_0x409964[_0x44410d(0x3e0)],_0x19a5b2,_0x217ece,_0x298007,_0x12387a),this['contentsBack'][_0x44410d(0x4ad)]=0xff;},Window_Base[_0x571fe1(0x252)]['processDrawCenteredPicture']=function(_0x44d20d){const _0x4530d6=_0x571fe1,_0xfb1e49=this[_0x4530d6(0x2eb)](_0x44d20d)['split'](',');if(!_0x44d20d[_0x4530d6(0x1be)])return;const _0x3f60ec=_0xfb1e49[0x0]['trim'](),_0x36f42c=ImageManager[_0x4530d6(0x153)](_0x3f60ec),_0x97e312=JsonEx[_0x4530d6(0x3ae)](_0x44d20d),_0x59cf9b=this[_0x4530d6(0x102)][_0x4530d6(0x4ad)];_0x36f42c[_0x4530d6(0x2aa)](this[_0x4530d6(0x16d)][_0x4530d6(0x239)](this,_0x36f42c,_0x97e312,_0x59cf9b));},Window_Base[_0x571fe1(0x252)]['drawBackCenteredPicture']=function(_0x16ff8c,_0x523e50,_0x50b421){const _0x38f7ea=_0x571fe1,_0x2edfb4=_0x523e50['width']||this[_0x38f7ea(0x290)],_0x335a84=this[_0x38f7ea(0x115)]!==undefined?this[_0x38f7ea(0x1bd)]():this[_0x38f7ea(0x4d5)],_0x3c0328=_0x2edfb4/_0x16ff8c['width'],_0x40e762=_0x335a84/_0x16ff8c[_0x38f7ea(0x3e0)],_0x5c526a=Math[_0x38f7ea(0x38d)](_0x3c0328,_0x40e762,0x1),_0x89cba4=this[_0x38f7ea(0x115)]!==undefined?(this[_0x38f7ea(0xe7)](0x0)['height']-this['lineHeight']())/0x2:0x0,_0x4fcca7=_0x16ff8c[_0x38f7ea(0x481)]*_0x5c526a,_0x428243=_0x16ff8c[_0x38f7ea(0x3e0)]*_0x5c526a,_0x3472b8=Math[_0x38f7ea(0x18f)]((_0x2edfb4-_0x4fcca7)/0x2)+_0x523e50[_0x38f7ea(0x12d)],_0x3324fc=Math[_0x38f7ea(0x18f)]((_0x335a84-_0x428243)/0x2)+_0x523e50[_0x38f7ea(0x432)]-_0x89cba4*0x2;this[_0x38f7ea(0x518)][_0x38f7ea(0x4ad)]=_0x50b421,this[_0x38f7ea(0x518)][_0x38f7ea(0x14a)](_0x16ff8c,0x0,0x0,_0x16ff8c[_0x38f7ea(0x481)],_0x16ff8c[_0x38f7ea(0x3e0)],_0x3472b8,_0x3324fc,_0x4fcca7,_0x428243),this['contentsBack']['paintOpacity']=0xff;},Window_Base[_0x571fe1(0x252)][_0x571fe1(0x474)]=function(_0x3b6ad7){const _0x25e41c=_0x571fe1,_0x1498fb=this['obtainEscapeParam'](_0x3b6ad7);if(_0x3b6ad7[_0x25e41c(0x1be)])this[_0x25e41c(0x3e8)](_0x1498fb>0x0);},Window_Base['prototype'][_0x571fe1(0x322)]=function(_0x580c3a){const _0x9f55cf=_0x571fe1,_0x1dc3e5=this['obtainEscapeParam'](_0x580c3a);if(this[_0x9f55cf(0x524)]===Window_Message&&_0x580c3a[_0x9f55cf(0x1be)]){if(_0x9f55cf(0x187)!==_0x9f55cf(0x187))return _0x389a0d=_0x264aa2['replace'](/<(?:BR|LINEBREAK)>/gi,'\x20\x0a'),_0x2a2e79;else this[_0x9f55cf(0x51f)](_0x1dc3e5);}},Window_Help[_0x571fe1(0x252)]['resetWordWrap']=function(){const _0x6fc942=_0x571fe1;this[_0x6fc942(0x2bc)]($gameSystem[_0x6fc942(0x336)]());},Window_Help[_0x571fe1(0x252)][_0x571fe1(0x34d)]=function(){return!![];},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x10e)]=Window_Help[_0x571fe1(0x252)][_0x571fe1(0x4c5)],Window_Help[_0x571fe1(0x252)]['refresh']=function(){const _0x3518ea=_0x571fe1;this[_0x3518ea(0x22c)](),VisuMZ[_0x3518ea(0x3f9)][_0x3518ea(0x10e)][_0x3518ea(0x323)](this),this[_0x3518ea(0x3c2)]();},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x418)]=Window_Options[_0x571fe1(0x252)][_0x571fe1(0x188)],Window_Options['prototype'][_0x571fe1(0x188)]=function(){const _0x138ba6=_0x571fe1;VisuMZ[_0x138ba6(0x3f9)][_0x138ba6(0x418)][_0x138ba6(0x323)](this),this['addMessageCoreCommands']();},Window_Options[_0x571fe1(0x252)][_0x571fe1(0x44c)]=function(){const _0xa02c01=_0x571fe1;VisuMZ[_0xa02c01(0x3f9)]['Settings'][_0xa02c01(0x496)][_0xa02c01(0xeb)]&&TextManager['isVisuMzLocalizationEnabled']()&&this[_0xa02c01(0x19b)]();if(VisuMZ[_0xa02c01(0x3f9)][_0xa02c01(0x49b)][_0xa02c01(0x31c)][_0xa02c01(0xeb)]){if(_0xa02c01(0x228)===_0xa02c01(0x228))this[_0xa02c01(0x384)]();else{if(this[_0xa02c01(0x201)]===_0x212630)this[_0xa02c01(0x305)]();if(this[_0xa02c01(0x201)][_0xa02c01(0x331)]===_0x855f54)this['initMessageCore']();return this['_MessageCoreSettings']['messageWidth'];}}},Window_Options[_0x571fe1(0x252)][_0x571fe1(0x19b)]=function(){const _0x48f5ab=_0x571fe1,_0x329122=TextManager[_0x48f5ab(0x362)],_0x4066e7='textLocale';this['addCommand'](_0x329122,_0x4066e7);},Window_Options['prototype'][_0x571fe1(0x384)]=function(){const _0x4280b2=_0x571fe1,_0x44b2a6=TextManager[_0x4280b2(0x346)],_0x9bae08='textSpeed';this[_0x4280b2(0x527)](_0x44b2a6,_0x9bae08);},VisuMZ['MessageCore']['Window_Options_statusText']=Window_Options[_0x571fe1(0x252)]['statusText'],Window_Options[_0x571fe1(0x252)][_0x571fe1(0x14f)]=function(_0x26cf71){const _0xa1a85e=_0x571fe1,_0x4347cd=this[_0xa1a85e(0x36c)](_0x26cf71);if(_0x4347cd===_0xa1a85e(0x211))return this['visuMzTextLocaleStatusText']();if(_0x4347cd===_0xa1a85e(0x28b))return this['textSpeedStatusText']();return VisuMZ['MessageCore'][_0xa1a85e(0x20a)][_0xa1a85e(0x323)](this,_0x26cf71);},Window_Options[_0x571fe1(0x252)][_0x571fe1(0x205)]=function(){const _0x58171a=_0x571fe1,_0x47f70b=ConfigManager[_0x58171a(0x211)];return TextManager[_0x58171a(0x3f0)](_0x47f70b);},Window_Options['prototype'][_0x571fe1(0x25e)]=function(){const _0x3e308f=_0x571fe1,_0x50acc0=this[_0x3e308f(0x4b8)](_0x3e308f(0x28b));return _0x50acc0>0xa?TextManager[_0x3e308f(0x425)]:_0x50acc0;},VisuMZ['MessageCore'][_0x571fe1(0x3cd)]=Window_Options[_0x571fe1(0x252)][_0x571fe1(0x3c1)],Window_Options[_0x571fe1(0x252)][_0x571fe1(0x3c1)]=function(_0x28a7b1){const _0x43dc1d=_0x571fe1;if(_0x28a7b1===_0x43dc1d(0x211))return!![];if(_0x28a7b1===_0x43dc1d(0x28b))return!![];return VisuMZ[_0x43dc1d(0x3f9)][_0x43dc1d(0x3cd)]['call'](this,_0x28a7b1);},VisuMZ['MessageCore']['Window_Options_changeVolume']=Window_Options[_0x571fe1(0x252)][_0x571fe1(0x43e)],Window_Options[_0x571fe1(0x252)][_0x571fe1(0x43e)]=function(_0x31d338,_0x5e09b7,_0x490585){const _0xb3cecc=_0x571fe1;if(_0x31d338===_0xb3cecc(0x211))return this[_0xb3cecc(0x265)](_0x5e09b7,_0x490585);if(_0x31d338===_0xb3cecc(0x28b))return this[_0xb3cecc(0x3d5)](_0x31d338,_0x5e09b7,_0x490585);VisuMZ[_0xb3cecc(0x3f9)][_0xb3cecc(0x1d0)][_0xb3cecc(0x323)](this,_0x31d338,_0x5e09b7,_0x490585);},Window_Options[_0x571fe1(0x252)][_0x571fe1(0x265)]=function(_0x300f8d,_0x5b4e32){const _0x5efcd8=_0x571fe1,_0xd56e15=VisuMZ['MessageCore'][_0x5efcd8(0x49b)]['Localization'][_0x5efcd8(0x25d)]||[],_0x42339e=ConfigManager[_0x5efcd8(0x211)];let _0x326e3c=_0xd56e15[_0x5efcd8(0x454)](_0x42339e);_0x326e3c+=_0x300f8d?0x1:-0x1;if(_0x326e3c>=_0xd56e15[_0x5efcd8(0x10a)])_0x326e3c=_0x5b4e32?0x0:_0xd56e15['length']-0x1;if(_0x326e3c<0x0)_0x326e3c=_0x5b4e32?_0xd56e15[_0x5efcd8(0x10a)]-0x1:0x0;this[_0x5efcd8(0x326)](_0x5efcd8(0x211),_0xd56e15[_0x326e3c]);},Window_Options[_0x571fe1(0x252)][_0x571fe1(0x3d5)]=function(_0x7dcebe,_0x1b4652,_0x5d0293){const _0x2aad63=_0x571fe1,_0x57c10b=this[_0x2aad63(0x4b8)](_0x7dcebe),_0x537215=0x1,_0x25ec8a=_0x57c10b+(_0x1b4652?_0x537215:-_0x537215);_0x25ec8a>0xb&&_0x5d0293?this[_0x2aad63(0x326)](_0x7dcebe,0x1):this[_0x2aad63(0x326)](_0x7dcebe,_0x25ec8a[_0x2aad63(0x374)](0x1,0xb));},Window_Message[_0x571fe1(0x252)][_0x571fe1(0xde)]=function(){const _0x1dfe92=_0x571fe1;let _0x142cda=Window_Base[_0x1dfe92(0x252)][_0x1dfe92(0xde)][_0x1dfe92(0x323)](this);return _0x142cda-=this[_0x1dfe92(0x393)](),_0x142cda;},Window_Message['prototype'][_0x571fe1(0x29d)]=function(){const _0x5b997f=_0x571fe1;Window_Base[_0x5b997f(0x252)][_0x5b997f(0x29d)][_0x5b997f(0x323)](this),VisuMZ[_0x5b997f(0x3f9)][_0x5b997f(0x49b)]['General']['StretchDimmedBg']&&this[_0x5b997f(0x2d2)]();},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x2d2)]=function(){const _0x1cdb24=_0x571fe1;this['_dimmerSprite']['x']=Math['round'](this[_0x1cdb24(0x481)]/0x2),this['_dimmerSprite'][_0x1cdb24(0x114)]['x']=0.5,this[_0x1cdb24(0x46b)]['scale']['x']=Graphics[_0x1cdb24(0x481)];},VisuMZ['MessageCore']['Window_Message_clearFlags']=Window_Message['prototype']['clearFlags'],Window_Message[_0x571fe1(0x252)][_0x571fe1(0x23e)]=function(){const _0x45f195=_0x571fe1;VisuMZ[_0x45f195(0x3f9)][_0x45f195(0x515)][_0x45f195(0x323)](this),this[_0x45f195(0x22c)](),this['resetWordWrap'](),this[_0x45f195(0x3e8)](![]),this[_0x45f195(0x165)](_0x45f195(0x2ed)),this[_0x45f195(0x442)](VisuMZ[_0x45f195(0x3f9)]['Settings'][_0x45f195(0x35f)][_0x45f195(0x499)]);},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x3c2)]=function(){this['setWordWrap']($gameSystem['isMessageWindowWordWrap']());},Window_Message['prototype'][_0x571fe1(0x34d)]=function(){return!![];},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x442)]=function(_0x322902){const _0x36febd=_0x571fe1,_0x211e8a=0xb-ConfigManager['textSpeed'];_0x322902=Math[_0x36febd(0xd4)](_0x322902*_0x211e8a),this[_0x36febd(0x4cb)]=_0x322902,this[_0x36febd(0xd9)]=_0x322902;},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x29a)]=Window_Message[_0x571fe1(0x252)]['isTriggered'],Window_Message[_0x571fe1(0x252)][_0x571fe1(0x476)]=function(){const _0x2525a8=_0x571fe1;return VisuMZ[_0x2525a8(0x3f9)][_0x2525a8(0x29a)][_0x2525a8(0x323)](this)||Input[_0x2525a8(0xf2)](VisuMZ['MessageCore']['Settings'][_0x2525a8(0x35f)]['FastForwardKey']);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x36f)]=Window_Message['prototype'][_0x571fe1(0x1ce)],Window_Message[_0x571fe1(0x252)]['updatePlacement']=function(){const _0xa9ee38=_0x571fe1;let _0x32c57f=this['y'];this['x']=Math[_0xa9ee38(0xd4)]((Graphics['boxWidth']-this['width'])/0x2),VisuMZ[_0xa9ee38(0x3f9)][_0xa9ee38(0x36f)][_0xa9ee38(0x323)](this);if(this[_0xa9ee38(0x458)])this['y']=_0x32c57f;this['updateXyOffsets'](),this['updateForcedPlacement'](),this[_0xa9ee38(0x493)](),this[_0xa9ee38(0xfa)]();},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x38e)]=Window_Message[_0x571fe1(0x252)]['newPage'],Window_Message[_0x571fe1(0x252)][_0x571fe1(0x4e2)]=function(_0xab624c){const _0x180fec=_0x571fe1;this['convertNewPageTextStateMacros'](_0xab624c),this['onNewPageMessageCore'](_0xab624c),VisuMZ['MessageCore'][_0x180fec(0x38e)][_0x180fec(0x323)](this,_0xab624c),this[_0x180fec(0x22a)]();},Window_Message[_0x571fe1(0x252)][_0x571fe1(0xd1)]=function(_0xd4a406){const _0x5b82bc=_0x571fe1;if(!_0xd4a406)return;this['_macroBypassWordWrap']=![],_0xd4a406[_0x5b82bc(0x339)]=this[_0x5b82bc(0x3e6)](_0xd4a406['text']),this[_0x5b82bc(0x37d)]&&(_0xd4a406[_0x5b82bc(0x339)]=this[_0x5b82bc(0x33d)](_0xd4a406[_0x5b82bc(0x339)]),this[_0x5b82bc(0x47e)]=!![]);},Window_Message['prototype'][_0x571fe1(0x33d)]=function(_0x46423c){const _0x4a135f=_0x571fe1;if(this[_0x4a135f(0x47e)])return _0x46423c;return Window_Base['prototype'][_0x4a135f(0x33d)][_0x4a135f(0x323)](this,_0x46423c);},Window_Message['prototype']['onNewPageMessageCore']=function(_0x26cc94){const _0x383e61=_0x571fe1;this[_0x383e61(0x3a7)](_0x26cc94),this[_0x383e61(0x4a7)](_0x26cc94),this['updateDimensions']();},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x2df)]=Window_Message['prototype'][_0x571fe1(0x3a0)],Window_Message[_0x571fe1(0x252)][_0x571fe1(0x3a0)]=function(){const _0x5c58bf=_0x571fe1;VisuMZ[_0x5c58bf(0x3f9)][_0x5c58bf(0x2df)][_0x5c58bf(0x323)](this),this['clearFlags']();if(this['_messagePositionReset'])this[_0x5c58bf(0x2e9)]();},Window_Message['prototype'][_0x571fe1(0x3b2)]=function(){const _0x4a6ffe=_0x571fe1;this[_0x4a6ffe(0x481)]=$gameSystem[_0x4a6ffe(0xfb)]()+this['addedWidth']();;this[_0x4a6ffe(0x481)]=Math[_0x4a6ffe(0x38d)](Graphics[_0x4a6ffe(0x481)],this[_0x4a6ffe(0x481)]);const _0x5a948a=$gameSystem['getMessageWindowRows']();this['height']=SceneManager[_0x4a6ffe(0x45c)][_0x4a6ffe(0x3d1)](_0x5a948a,![])+this[_0x4a6ffe(0x393)](),this['height']=Math[_0x4a6ffe(0x38d)](Graphics['height'],this[_0x4a6ffe(0x3e0)]);if($gameTemp['_centerMessageWindow'])this['resetPositionX']();},Window_Message['prototype']['addedWidth']=function(){return 0x0;},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x393)]=function(){return 0x0;},Window_Message['prototype']['resetPositionX']=function(){const _0x17bf3d=_0x571fe1;this['x']=(Graphics[_0x17bf3d(0x482)]-this[_0x17bf3d(0x481)])/0x2,$gameTemp['_centerMessageWindow']=undefined,this[_0x17bf3d(0x493)]();},Window_Message[_0x571fe1(0x252)]['updateMove']=function(){const _0xf1e622=_0x571fe1,_0x2d70cb={'x':this['x'],'y':this['y']};Window_Base[_0xf1e622(0x252)]['updateMove']['call'](this),this[_0xf1e622(0x21c)](_0x2d70cb);},Window_Message['prototype'][_0x571fe1(0x1ac)]=function(){return!![];},Window_Message['prototype'][_0x571fe1(0x21c)]=function(_0x27d4ae){const _0x4e315c=_0x571fe1;this[_0x4e315c(0x3ef)]&&(this['_nameBoxWindow']['x']+=this['x']-_0x27d4ae['x'],this[_0x4e315c(0x3ef)]['y']+=this['y']-_0x27d4ae['y']);},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x2ee)]=function(_0x1a186b,_0x39dcba){const _0x4065bd=_0x571fe1;this[_0x4065bd(0x150)](this['_resetRect']['x'],this[_0x4065bd(0x25c)]*(Graphics[_0x4065bd(0x18b)]-this['height'])/0x2,this[_0x4065bd(0x1b7)][_0x4065bd(0x481)],this['_resetRect']['height'],_0x1a186b,_0x39dcba);},Window_Message['prototype'][_0x571fe1(0x3d9)]=function(_0x53d2cc){const _0x4e35cd=_0x571fe1,_0x1175f4=Window_Base[_0x4e35cd(0x252)][_0x4e35cd(0x3d9)]['call'](this,_0x53d2cc);_0x53d2cc[_0x4e35cd(0x1be)]&&(_0x4e35cd(0x264)===_0x4e35cd(0x264)?this[_0x4e35cd(0x1b9)](_0x1175f4):(this[_0x4e35cd(0x350)][_0x4e35cd(0x1af)](this[_0x4e35cd(0x16b)][_0x56e6d6]),this[_0x4e35cd(0x350)]['show']()));},Window_Message['prototype'][_0x571fe1(0x1b9)]=function(_0x5465c1){const _0x580ff1=_0x571fe1;if($gameParty[_0x580ff1(0x19c)]()){}else _0x580ff1(0x17d)!=='AUvRs'?_0x1a1f88=![]:$gameMap[_0x580ff1(0x3a8)](_0x5465c1);},Window_Message[_0x571fe1(0x252)]['processCharacter']=function(_0x1598e7){const _0x594c27=_0x571fe1;this[_0x594c27(0x4cb)]--,this[_0x594c27(0x4cb)]<=0x0&&('bmPGv'!==_0x594c27(0x325)?(this['onProcessCharacter'](_0x1598e7),Window_Base[_0x594c27(0x252)][_0x594c27(0x40e)][_0x594c27(0x323)](this,_0x1598e7)):(this['_helpWindow'][_0x594c27(0x400)](),this['_helpWindow'][_0x594c27(0x31b)]()));},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x4b2)]=function(_0x105125){const _0x32dc44=_0x571fe1;this[_0x32dc44(0x4cb)]=this[_0x32dc44(0xd9)];if(this['_textDelay']<=0x0)this[_0x32dc44(0x225)]=!![];},VisuMZ[_0x571fe1(0x3f9)]['Window_Message_processEscapeCharacter']=Window_Message['prototype'][_0x571fe1(0x404)],Window_Message[_0x571fe1(0x252)][_0x571fe1(0x404)]=function(_0x44810a,_0x502d4a){const _0x291cdb=_0x571fe1;if(!_0x502d4a[_0x291cdb(0x1be)]){if(_0x291cdb(0x3a4)!==_0x291cdb(0x3a4)){if(!_0x1b3a82[_0x291cdb(0x207)]())return'';if(_0x38e1bd[_0x291cdb(0x1da)])return _0x524df3[_0x291cdb(0x1da)][_0x291cdb(0x2cd)]();if(_0x18100c[_0x291cdb(0x2d5)][0x0])return _0x2b3602[_0x291cdb(0x2d5)][0x0]['name']();return'';}else Window_Base['prototype'][_0x291cdb(0x404)][_0x291cdb(0x323)](this,_0x44810a,_0x502d4a);}else'NhJBD'!==_0x291cdb(0x1fd)?this['setWordWrap'](![]):VisuMZ[_0x291cdb(0x3f9)][_0x291cdb(0xff)]['call'](this,_0x44810a,_0x502d4a);},VisuMZ['MessageCore'][_0x571fe1(0x27f)]=Window_Message[_0x571fe1(0x252)]['needsNewPage'],Window_Message['prototype'][_0x571fe1(0x176)]=function(_0x2a336b){const _0x4a26a3=_0x571fe1;if(this[_0x4a26a3(0xda)])return![];return VisuMZ[_0x4a26a3(0x3f9)]['Window_Message_needsNewPage'][_0x4a26a3(0x323)](this,_0x2a336b);},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x3a7)]=function(_0x35ab85){const _0x10e886=_0x571fe1;let _0x4d58ed=_0x35ab85[_0x10e886(0x339)];this['_forcedPosition']={};if(this[_0x10e886(0xee)]())return _0x4d58ed;_0x4d58ed=_0x4d58ed[_0x10e886(0x3e9)](/<POSITION:[ ]*(.*?)>/gi,(_0x5b921e,_0x483352)=>{const _0x4b4845=_0x10e886,_0x382fea=_0x483352['split'](',')[_0x4b4845(0x328)](_0x2550ee=>Number(_0x2550ee)||0x0);if(_0x382fea[0x0]!==undefined)this[_0x4b4845(0x48d)]['x']=Number(_0x382fea[0x0]);if(_0x382fea[0x1]!==undefined)this[_0x4b4845(0x48d)]['y']=Number(_0x382fea[0x1]);if(_0x382fea[0x2]!==undefined)this[_0x4b4845(0x48d)][_0x4b4845(0x481)]=Number(_0x382fea[0x2]);if(_0x382fea[0x3]!==undefined)this['_forcedPosition'][_0x4b4845(0x3e0)]=Number(_0x382fea[0x3]);return'';}),_0x4d58ed=_0x4d58ed['replace'](/<COORDINATES:[ ]*(.*?)>/gi,(_0x40730c,_0x253a28)=>{const _0x5b2a14=_0x10e886,_0x145451=_0x253a28['split'](',')['map'](_0x46fe15=>Number(_0x46fe15)||0x0);if(_0x145451[0x0]!==undefined)this[_0x5b2a14(0x48d)]['x']=Number(_0x145451[0x0]);if(_0x145451[0x1]!==undefined)this[_0x5b2a14(0x48d)]['y']=Number(_0x145451[0x1]);return'';}),_0x4d58ed=_0x4d58ed[_0x10e886(0x3e9)](/<DIMENSIONS:[ ]*(.*?)>/gi,(_0x216329,_0x357ab9)=>{const _0x3123d6=_0x10e886,_0x2e82d3=_0x357ab9[_0x3123d6(0x234)](',')[_0x3123d6(0x328)](_0x2ccc20=>Number(_0x2ccc20)||0x0);if(_0x2e82d3[0x0]!==undefined)this[_0x3123d6(0x48d)][_0x3123d6(0x481)]=Number(_0x2e82d3[0x2]);if(_0x2e82d3[0x1]!==undefined)this[_0x3123d6(0x48d)]['height']=Number(_0x2e82d3[0x3]);return'';}),_0x4d58ed=_0x4d58ed['replace'](/<OFFSET:[ ]*(.*?)>/gi,(_0x5aa4d0,_0x44ba73)=>{const _0x5d3d54=_0x10e886;if(_0x5d3d54(0x484)!==_0x5d3d54(0x484))this[_0x5d3d54(0x2bc)](![]);else{const _0x26b557=_0x44ba73[_0x5d3d54(0x234)](',')[_0x5d3d54(0x328)](_0x3c472c=>Number(_0x3c472c)||0x0);let _0x1e9202=_0x26b557[0x0]||0x0,_0x35df86=_0x26b557[0x1]||0x0;return $gameSystem['setMessageWindowXyOffsets'](_0x1e9202,_0x35df86),'';}}),_0x35ab85[_0x10e886(0x339)]=_0x4d58ed;},Window_Message['prototype'][_0x571fe1(0x4dd)]=function(){const _0x34533a=_0x571fe1,_0x1aa311=$gameSystem[_0x34533a(0x4f4)]();this['x']+=_0x1aa311['x'],this['y']+=_0x1aa311['y'];},Window_Message['prototype'][_0x571fe1(0x443)]=function(){const _0x57eaa5=_0x571fe1;this[_0x57eaa5(0x48d)]=this[_0x57eaa5(0x48d)]||{};const _0x5dcb0d=['x','y',_0x57eaa5(0x481),_0x57eaa5(0x3e0)];for(const _0x3d447f of _0x5dcb0d){this[_0x57eaa5(0x48d)][_0x3d447f]!==undefined&&(this[_0x3d447f]=Number(this[_0x57eaa5(0x48d)][_0x3d447f]));}},Window_Message['prototype']['prepareAutoSizeEscapeCharacters']=function(_0x1f38fb){const _0x586402=_0x571fe1;this[_0x586402(0xda)]=![];let _0x455446=_0x1f38fb['text'];_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTO|AUTOSIZE|AUTO SIZE)>/gi,()=>{const _0x59163e=_0x586402;return this['processAutoSize'](_0x455446,!![],!![]),this[_0x59163e(0x398)](_0x59163e(0x260)),'';}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOWIDTH|AUTO WIDTH)>/gi,()=>{return this['processAutoSize'](_0x455446,!![],![]),this['processAutoPosition']('none'),'';}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOHEIGHT|AUTO HEIGHT)>/gi,()=>{const _0x16b5af=_0x586402;if(_0x16b5af(0x380)!==_0x16b5af(0x36b))return this[_0x16b5af(0x381)](_0x455446,![],!![]),this[_0x16b5af(0x398)]('none'),'';else{const _0x45d406=_0x44ea88['textLocale'];return _0x12addc[_0x16b5af(0x3f0)](_0x45d406);}});if(SceneManager[_0x586402(0x207)]())_0x586402(0x2d6)!==_0x586402(0xdd)?(_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOACTOR|AUTO ACTOR):[ ](.*?)>/gi,(_0x234adb,_0xab9308)=>{const _0x128bb7=_0x586402;if(_0x128bb7(0x358)!=='EjuYF')_0x18e28f[_0x128bb7(0x3f9)][_0x128bb7(0x438)][_0x128bb7(0x323)](this),this[_0x128bb7(0x305)]();else return this[_0x128bb7(0x381)](_0x455446,!![],!![]),this[_0x128bb7(0x398)](_0x128bb7(0x41f),Number(_0xab9308)||0x1),'';}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOPARTY|AUTO PARTY):[ ](.*?)>/gi,(_0x24d0ad,_0x3c2c69)=>{const _0x5789d0=_0x586402;if(_0x5789d0(0x26c)!==_0x5789d0(0xf3))return this[_0x5789d0(0x381)](_0x455446,!![],!![]),this[_0x5789d0(0x398)](_0x5789d0(0x17a),Number(_0x3c2c69)||0x0),'';else _0x4e177c['x']=this[_0x5789d0(0x481)]+_0x217611;}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOENEMY|AUTO ENEMY):[ ](.*?)>/gi,(_0x4c72c1,_0x54a6c6)=>{const _0x12cd82=_0x586402;if(_0x12cd82(0x1d3)!==_0x12cd82(0x28d))return this['processAutoSize'](_0x455446,!![],!![]),this[_0x12cd82(0x398)](_0x12cd82(0x490),Number(_0x54a6c6)||0x0),'';else{const _0x5ed315=_0x35a0ed['split'](',')[_0x12cd82(0x328)](_0x3034e9=>_0x7e5470(_0x3034e9)||0x0);if(_0x5ed315[0x0]!==_0xc226cb)this[_0x12cd82(0x48d)]['x']=_0x2ec824(_0x5ed315[0x0]);if(_0x5ed315[0x1]!==_0x3821b6)this['_forcedPosition']['y']=_0x37ea81(_0x5ed315[0x1]);if(_0x5ed315[0x2]!==_0x9b4445)this['_forcedPosition'][_0x12cd82(0x481)]=_0x743112(_0x5ed315[0x2]);if(_0x5ed315[0x3]!==_0x5c6b4b)this['_forcedPosition'][_0x12cd82(0x3e0)]=_0x46b6bc(_0x5ed315[0x3]);return'';}})):this['y']=_0x551e77[_0x586402(0xd4)]((_0x3a36ee['boxHeight']-this[_0x586402(0x3e0)])/0x2);else SceneManager['isSceneMap']()&&(_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOPLAYER|AUTO PLAYER)>/gi,(_0x4ec9b6,_0x10eeae)=>{const _0x508696=_0x586402;if(_0x508696(0x377)!==_0x508696(0x3a5))return this[_0x508696(0x381)](_0x455446,!![],!![]),this[_0x508696(0x398)](_0x508696(0x15a),0x0),'';else this['_resetRect']=_0x97d687['makeDeepCopy'](_0x23982a);}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOACTOR|AUTO ACTOR):[ ](.*?)>/gi,(_0x829d74,_0x402178)=>{const _0x20e321=_0x586402;if(_0x20e321(0xdf)===_0x20e321(0x3d0))this[_0x20e321(0x439)](),this[_0x20e321(0x3c2)](),this[_0x20e321(0x136)](_0x524e27);else return this[_0x20e321(0x381)](_0x455446,!![],!![]),this[_0x20e321(0x398)]('map\x20actor',Number(_0x402178)||0x1),'';}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOPARTY|AUTO PARTY):[ ](.*?)>/gi,(_0x454dd6,_0x137f3f)=>{const _0x8ef493=_0x586402;return this['processAutoSize'](_0x455446,!![],!![]),this[_0x8ef493(0x398)](_0x8ef493(0x3a6),Number(_0x137f3f)||0x0),'';}),_0x455446=_0x455446[_0x586402(0x3e9)](/<(?:AUTOEVENT|AUTO EVENT):[ ](.*?)>/gi,(_0xd073c9,_0xe168cf)=>{const _0x4fe5fe=_0x586402;if(_0x4fe5fe(0x151)!==_0x4fe5fe(0x3e3))return this[_0x4fe5fe(0x381)](_0x455446,!![],!![]),this['processAutoPosition'](_0x4fe5fe(0x2e6),Number(_0xe168cf)||0x0),'';else{const _0x305ec0=_0x39fe43['$1'][_0x4fe5fe(0x234)](',')[_0x4fe5fe(0x328)](_0x43339d=>_0x4b5231(_0x43339d)||0x0);for(const _0x2162f7 of _0x305ec0){if(_0x5d625d[_0x4fe5fe(0x501)](_0x2162f7))return![];}return!![];}}));_0x1f38fb[_0x586402(0x339)]=_0x455446;},Window_Message['_autoSizeRegexp']=/<(?:AUTO|AUTOSIZE|AUTO SIZE|AUTOWIDTH|AUTO WIDTH|AUTOHEIGHT|AUTO HEIGHT|AUTOPLAYER|AUTO PLAYER)>/gi,Window_Message[_0x571fe1(0x232)]=/<(?:AUTOPARTY|AUTO PARTY|AUTOPLAYER|AUTO PLAYER|AUTOEVENT|AUTO EVENT|AUTOENEMY|AUTO ENEMY|AUTOACTOR|AUTO ACTOR):[ ](.*?)>/gi,Window_Message[_0x571fe1(0x252)][_0x571fe1(0x381)]=function(_0xfb9c72,_0x22d9fd,_0x31e6ea){const _0x1993c0=_0x571fe1;_0xfb9c72=_0xfb9c72['replace'](Window_Message['_autoSizeRegexp'],''),_0xfb9c72=_0xfb9c72[_0x1993c0(0x3e9)](Window_Message[_0x1993c0(0x232)],''),this[_0x1993c0(0x3f8)]=!![],this[_0x1993c0(0xda)]=!![],this[_0x1993c0(0x2bc)](![]);const _0x282837=this[_0x1993c0(0x145)](_0xfb9c72);if(_0x22d9fd){if(_0x1993c0(0x158)===_0x1993c0(0x158)){let _0x3171b9=_0x282837[_0x1993c0(0x481)]+$gameSystem[_0x1993c0(0x466)]()*0x2+0x6;const _0xc94d70=$gameMessage[_0x1993c0(0x344)]()!=='',_0x2a095c=ImageManager[_0x1993c0(0x333)],_0x2e43d5=0x14;_0x3171b9+=_0xc94d70?_0x2a095c+_0x2e43d5:0x4;if(_0x3171b9%0x2!==0x0)_0x3171b9+=0x1;$gameSystem[_0x1993c0(0x507)](_0x3171b9);}else this[_0x1993c0(0x16b)][_0x106928]='';}if(_0x31e6ea){if(_0x1993c0(0x45b)!=='mniHN')this[_0x1993c0(0x458)]=_0x45746[_0x1993c0(0xf1)]()[_0x1993c0(0xdc)](_0x5d5aac-0x2);else{let _0x4afa5b=Math[_0x1993c0(0x17b)](_0x282837['height']/this[_0x1993c0(0x155)]());$gameSystem[_0x1993c0(0x1db)](_0x4afa5b);}}this[_0x1993c0(0x308)](),this['_refreshPauseSign'](),this[_0x1993c0(0x3f8)]=![],this['_messagePositionReset']=!![];},Window_Message['prototype'][_0x571fe1(0x308)]=function(){const _0x4bfef0=_0x571fe1;this[_0x4bfef0(0x3b2)](),this[_0x4bfef0(0x1ce)](),this['resetPositionX'](),this[_0x4bfef0(0x202)](),this['contents'][_0x4bfef0(0x400)](),this[_0x4bfef0(0x22a)]();},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x398)]=function(_0x3fadb5,_0x1d15de){const _0x2b70d6=_0x571fe1;switch(_0x3fadb5[_0x2b70d6(0x366)]()[_0x2b70d6(0x2a1)]()){case _0x2b70d6(0x41f):this[_0x2b70d6(0x458)]=$gameActors[_0x2b70d6(0x29e)](_0x1d15de);break;case _0x2b70d6(0x17a):this['_autoPositionTarget']=$gameParty[_0x2b70d6(0x390)]()[_0x1d15de-0x1];break;case'battle\x20enemy':this[_0x2b70d6(0x458)]=$gameTroop['members']()[_0x1d15de-0x1];break;case'map\x20player':this[_0x2b70d6(0x458)]=$gamePlayer;break;case'map\x20actor':const _0x269bfa=$gameActors['actor'](_0x1d15de)[_0x2b70d6(0x497)]();if(_0x269bfa===0x0)_0x2b70d6(0x335)!==_0x2b70d6(0x335)?_0x220dd2=_0x55a1bb[_0x2b70d6(0x18f)](this[_0x2b70d6(0x3e0)]-_0x53c9bf[_0x2b70d6(0x3e0)]-_0xdb1b71):this[_0x2b70d6(0x458)]=$gamePlayer;else{if(_0x2b70d6(0x39d)===_0x2b70d6(0x39d))this[_0x2b70d6(0x458)]=$gamePlayer[_0x2b70d6(0xf1)]()[_0x2b70d6(0xdc)](_0x269bfa-0x1);else return this[_0x2b70d6(0x3d7)]['x']+this[_0x2b70d6(0x3d7)]['width']-this[_0x2b70d6(0x42b)]();}break;case _0x2b70d6(0x3a6):if(_0x1d15de===0x1)this[_0x2b70d6(0x458)]=$gamePlayer;else{if(_0x2b70d6(0x276)===_0x2b70d6(0x276))this[_0x2b70d6(0x458)]=$gamePlayer[_0x2b70d6(0xf1)]()[_0x2b70d6(0xdc)](_0x1d15de-0x2);else{const _0x568f9b=_0x8e9d9b['MessageCore']['Settings'][_0x2b70d6(0x35f)][_0x2b70d6(0x47d)];return _0x341baa[_0x2b70d6(0x4d4)](_0x568f9b);}}break;case _0x2b70d6(0x2e6):this[_0x2b70d6(0x458)]=$gameMap['event'](_0x1d15de);break;}if(this[_0x2b70d6(0x458)]){if(_0x2b70d6(0x12a)===_0x2b70d6(0x278))return this['event']()[_0x2b70d6(0x44e)];else this[_0x2b70d6(0x428)]();}},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x4b3)]=Window_Message[_0x571fe1(0x252)]['synchronizeNameBox'],Window_Message[_0x571fe1(0x252)]['synchronizeNameBox']=function(){const _0x50e3e6=_0x571fe1;this[_0x50e3e6(0x428)](),VisuMZ[_0x50e3e6(0x3f9)][_0x50e3e6(0x4b3)][_0x50e3e6(0x323)](this);},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x428)]=function(){const _0xf0518f=_0x571fe1;if(!this[_0xf0518f(0x458)])return;const _0x252f5a=SceneManager[_0xf0518f(0x45c)];if(!_0x252f5a)return;const _0x470f81=_0x252f5a['_spriteset'];if(!_0x470f81)return;const _0x40f6b4=_0x470f81['findTargetSprite'](this[_0xf0518f(0x458)]);if(!_0x40f6b4)return;let _0x2cab76=_0x40f6b4['x'];if(SceneManager[_0xf0518f(0x240)]())_0x2cab76*=$gameScreen['zoomScale']();else{if(SceneManager['isSceneBattle']()&&Imported['VisuMZ_3_ActSeqCamera']){if(_0xf0518f(0x42c)===_0xf0518f(0x231)){_0x24fd6a[_0xf0518f(0x50d)](_0x278a82,_0x351ffd),_0x40cabc[_0xf0518f(0x2f9)](_0x4860e3[_0xf0518f(0x2ce)]||0x0,_0x15a1ba[_0xf0518f(0x450)]||0x0);const _0x2f8391=_0x4d7db2[_0xf0518f(0x31a)]();if(_0x2f8391)_0x2f8391[_0xf0518f(0x31f)](_0xf0518f(0x3b5));}else{let _0x13c300=_0x40f6b4['x']-Graphics[_0xf0518f(0x482)]*_0x470f81[_0xf0518f(0x114)]['x'];_0x2cab76+=_0x13c300*(_0x470f81[_0xf0518f(0x330)]['x']-0x1);}}}_0x2cab76-=this[_0xf0518f(0x481)]/0x2,_0x2cab76-=(Graphics[_0xf0518f(0x481)]-Graphics[_0xf0518f(0x482)])/0x2,_0x2cab76+=this[_0xf0518f(0x3a2)]();let _0xce896=_0x40f6b4['y'];if(SceneManager[_0xf0518f(0x240)]())_0xce896-=_0x40f6b4['height']+0x8,_0xce896*=$gameScreen['zoomScale'](),_0xce896-=this[_0xf0518f(0x3e0)]*$gameScreen[_0xf0518f(0x4ce)]();else{if(SceneManager[_0xf0518f(0x207)]()&&Imported[_0xf0518f(0x457)]){if('MTCHh'!==_0xf0518f(0x2af)){const _0x56ca75=_0x3c5277['getMessageWindowXyOffsets']();this['x']+=_0x56ca75['x'],this['y']+=_0x56ca75['y'];}else{let _0xdbf810=_0x40f6b4[_0xf0518f(0x3e0)]*_0x470f81[_0xf0518f(0x330)]['y'];_0xce896-=this[_0xf0518f(0x3e0)]*_0x470f81[_0xf0518f(0x330)]['y']+_0xdbf810+0x8;let _0x5c88a7=_0x40f6b4['y']-Graphics['boxHeight']*_0x470f81[_0xf0518f(0x114)]['y'];_0xce896+=_0x5c88a7*(_0x470f81[_0xf0518f(0x330)]['y']-0x1);}}else{if(_0xf0518f(0x4bb)!==_0xf0518f(0x341))_0xce896-=_0x40f6b4['height']+0x8,_0xce896-=this['height'];else return _0x202654[_0x54886e]=(_0x45488c[_0x52e706+0x1]||'')[_0xf0518f(0x3e9)](/^"|"$/g,''),_0x46883b;}}_0xce896-=(Graphics[_0xf0518f(0x3e0)]-Graphics['boxHeight'])/0x2,_0xce896+=this['autoPositionOffsetY']();const _0x43239c=$gameSystem['getMessageWindowXyOffsets']();_0x2cab76+=_0x43239c['x'],_0xce896+=_0x43239c['y'],this['x']=Math['round'](_0x2cab76),this['y']=Math[_0xf0518f(0xd4)](_0xce896),this[_0xf0518f(0x493)](!![],![]),this[_0xf0518f(0x48d)]=this[_0xf0518f(0x48d)]||{},this[_0xf0518f(0x48d)]['x']=this['x'],this[_0xf0518f(0x48d)]['y']=this['y'],this[_0xf0518f(0x48d)][_0xf0518f(0x481)]=this[_0xf0518f(0x481)],this[_0xf0518f(0x48d)][_0xf0518f(0x3e0)]=this['height'],this['_nameBoxWindow'][_0xf0518f(0x1ce)]();},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x3a2)]=function(){return 0x0;},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x49e)]=function(){return 0x0;},Window_Message['prototype'][_0x571fe1(0x2e9)]=function(){const _0x13c39c=_0x571fe1;this[_0x13c39c(0x4b5)]=![],this['_autoPositionTarget']=undefined,$gameSystem[_0x13c39c(0x305)](),this[_0x13c39c(0x308)](),this['openness']=0x0;},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x43a)]=function(_0x431973){const _0x52849c=_0x571fe1;return Window_Base[_0x52849c(0x252)][_0x52849c(0x43a)][_0x52849c(0x323)](this,_0x431973);},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x364)]=function(_0x54b4ac){const _0x3ef9a0=_0x571fe1;return Window_Base[_0x3ef9a0(0x252)][_0x3ef9a0(0x364)][_0x3ef9a0(0x323)](this,_0x54b4ac);},Window_Message[_0x571fe1(0x252)]['flushTextState']=function(_0x4a6b47){const _0x54b78f=_0x571fe1;this[_0x54b78f(0x51b)](_0x4a6b47),Window_Base[_0x54b78f(0x252)][_0x54b78f(0x11b)][_0x54b78f(0x323)](this,_0x4a6b47),this[_0x54b78f(0x4d0)](_0x4a6b47);},Window_Message[_0x571fe1(0x252)][_0x571fe1(0x51b)]=function(_0x4d9863){},Window_Message[_0x571fe1(0x252)]['postFlushTextState']=function(_0x824cca){},Window_NameBox[_0x571fe1(0x252)][_0x571fe1(0x34d)]=function(){return![];},Window_NameBox[_0x571fe1(0x252)][_0x571fe1(0x26a)]=function(){const _0x45947d=_0x571fe1;Window_Base[_0x45947d(0x252)]['resetTextColor'][_0x45947d(0x323)](this),this[_0x45947d(0x27c)](this[_0x45947d(0x15b)]());},Window_NameBox[_0x571fe1(0x252)][_0x571fe1(0x15b)]=function(){const _0x269a2b=_0x571fe1,_0x2fa887=VisuMZ[_0x269a2b(0x3f9)][_0x269a2b(0x49b)][_0x269a2b(0x35f)][_0x269a2b(0x47d)];return ColorManager[_0x269a2b(0x4d4)](_0x2fa887);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x3a9)]=Window_NameBox['prototype']['updatePlacement'],Window_NameBox['prototype'][_0x571fe1(0x1ce)]=function(){const _0x359a77=_0x571fe1;VisuMZ[_0x359a77(0x3f9)][_0x359a77(0x3a9)]['call'](this),this[_0x359a77(0x300)](),this[_0x359a77(0x4c6)](),this['clampPlacementPosition'](),this[_0x359a77(0x20e)]();},Window_NameBox[_0x571fe1(0x252)]['preConvertEscapeCharacters']=function(_0x224dbc){const _0x13508c=_0x571fe1;return _0x224dbc=_0x224dbc[_0x13508c(0x3e9)](/<LEFT>/gi,this[_0x13508c(0x3df)][_0x13508c(0x239)](this,0x0)),_0x224dbc=_0x224dbc[_0x13508c(0x3e9)](/<CENTER>/gi,this[_0x13508c(0x3df)][_0x13508c(0x239)](this,0x5)),_0x224dbc=_0x224dbc['replace'](/<RIGHT>/gi,this['setRelativePosition'][_0x13508c(0x239)](this,0xa)),_0x224dbc=_0x224dbc[_0x13508c(0x3e9)](/<POSITION:[ ](\d+)>/gi,(_0x5c9c51,_0x11c759)=>this[_0x13508c(0x3df)](parseInt(_0x11c759))),_0x224dbc=_0x224dbc['replace'](/<\/LEFT>/gi,''),_0x224dbc=_0x224dbc[_0x13508c(0x3e9)](/<\/CENTER>/gi,''),_0x224dbc=_0x224dbc['replace'](/<\/RIGHT>/gi,''),_0x224dbc=_0x224dbc['trim'](),Window_Base[_0x13508c(0x252)][_0x13508c(0x43a)][_0x13508c(0x323)](this,_0x224dbc);},Window_NameBox[_0x571fe1(0x252)][_0x571fe1(0x3df)]=function(_0x4c4df6){const _0x2653ee=_0x571fe1;return this[_0x2653ee(0x479)]=_0x4c4df6,'';},Window_NameBox[_0x571fe1(0x252)]['updateRelativePosition']=function(){const _0x241f13=_0x571fe1;if($gameMessage[_0x241f13(0x4f2)]())return;this[_0x241f13(0x479)]=this[_0x241f13(0x479)]||0x0;const _0x3e9a80=this['_messageWindow'],_0x16c398=Math[_0x241f13(0x18f)](_0x3e9a80[_0x241f13(0x481)]*this[_0x241f13(0x479)]/0xa);this['x']=_0x3e9a80['x']+_0x16c398-Math['floor'](this[_0x241f13(0x481)]/0x2),this['x']=this['x'][_0x241f13(0x374)](_0x3e9a80['x'],_0x3e9a80['x']+_0x3e9a80[_0x241f13(0x481)]-this[_0x241f13(0x481)]);},Window_NameBox[_0x571fe1(0x252)][_0x571fe1(0x4c6)]=function(){const _0x2c5f46=_0x571fe1;if($gameMessage[_0x2c5f46(0x4f2)]())return;this[_0x2c5f46(0x479)]=this[_0x2c5f46(0x479)]||0x0;const _0x3e14bc=VisuMZ[_0x2c5f46(0x3f9)][_0x2c5f46(0x49b)][_0x2c5f46(0x35f)][_0x2c5f46(0x243)],_0x2b3552=VisuMZ[_0x2c5f46(0x3f9)][_0x2c5f46(0x49b)][_0x2c5f46(0x35f)]['NameBoxWindowOffsetY'],_0x553598=(0x5-this['_relativePosition'])/0x5;this['x']+=Math[_0x2c5f46(0x18f)](_0x3e14bc*_0x553598),this['y']+=_0x2b3552;},Window_NameBox[_0x571fe1(0x252)][_0x571fe1(0x20e)]=function(){const _0x5686ba=_0x571fe1,_0x350fd5=this['_messageWindow'],_0x1c11d6=_0x350fd5['y'],_0x338fd7=VisuMZ[_0x5686ba(0x3f9)][_0x5686ba(0x49b)][_0x5686ba(0x35f)][_0x5686ba(0x504)];_0x1c11d6>this['y']&&_0x1c11d6<this['y']+this['height']-_0x338fd7&&(this['y']=_0x350fd5['y']+_0x350fd5[_0x5686ba(0x3e0)]);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x521)]=Window_NameBox[_0x571fe1(0x252)]['refresh'],Window_NameBox['prototype'][_0x571fe1(0x4c5)]=function(){const _0x1a1f07=_0x571fe1;this[_0x1a1f07(0x479)]=0x0,VisuMZ[_0x1a1f07(0x3f9)]['Window_NameBox_refresh'][_0x1a1f07(0x323)](this);},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0xee)]=function(){return![];},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x34d)]=function(){return!![];},Window_ChoiceList[_0x571fe1(0x252)]['itemHeight']=function(){const _0x5a27a5=_0x571fe1;return $gameSystem[_0x5a27a5(0x4df)]()+0x8;},Window_ChoiceList[_0x571fe1(0x252)]['maxCols']=function(){return $gameSystem['getChoiceListMaxColumns']();},Window_ChoiceList[_0x571fe1(0x252)]['start']=function(){const _0x2eb54e=_0x571fe1;this[_0x2eb54e(0x4c5)](),this[_0x2eb54e(0x244)](),this[_0x2eb54e(0x1ca)](),this[_0x2eb54e(0x1c3)]();},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x4bf)]=function(){const _0x4fc699=_0x571fe1;$gameMessage['onChoice'](this[_0x4fc699(0x1b3)]()),this['_messageWindow'][_0x4fc699(0x3a0)](),this[_0x4fc699(0x34b)](),this['_helpWindow']&&('PFdcH'!=='PFdcH'?(this[_0x4fc699(0x4c5)](),this[_0x4fc699(0x244)](),this[_0x4fc699(0x1ca)](),this[_0x4fc699(0x1c3)]()):(this[_0x4fc699(0x350)][_0x4fc699(0x400)](),this[_0x4fc699(0x350)]['hide']()));},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x4fe)]=Window_ChoiceList['prototype'][_0x571fe1(0x317)],Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x317)]=function(){const _0x579944=_0x571fe1;VisuMZ[_0x579944(0x3f9)]['Window_ChoiceList_callCancelHandler'][_0x579944(0x323)](this),this['_helpWindow']&&('EkTWm'!==_0x579944(0x4e1)?this[_0x372cfd]=_0x25ea8c(this[_0x579944(0x48d)][_0x5bf92d]):(this[_0x579944(0x350)]['clear'](),this[_0x579944(0x350)][_0x579944(0x31b)]()));},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x4c5)]=function(){const _0x54813c=_0x571fe1;this['clearCommandList'](),this[_0x54813c(0x303)](),this[_0x54813c(0x3d7)]&&(this['updatePlacement'](),this[_0x54813c(0x355)]()),this['createContents'](),this[_0x54813c(0x35a)](),this[_0x54813c(0x29d)](),Window_Selectable['prototype'][_0x54813c(0x4c5)][_0x54813c(0x323)](this);},Window_ChoiceList['prototype'][_0x571fe1(0x303)]=function(){const _0x288923=_0x571fe1;$gameMessage[_0x288923(0x1c8)]?_0x288923(0x4cd)==='LsuBH'?this[_0x288923(0x4f7)]():this[_0x288923(0x505)]():this[_0x288923(0x1e8)](),this[_0x288923(0x258)](),this[_0x288923(0x144)]();},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x505)]=function(){const _0x4e7122=_0x571fe1,_0x3520d4=$gameMessage[_0x4e7122(0x1cb)]();let _0x531b02=0x0;for(let _0x7d75e9 of _0x3520d4){_0x7d75e9=this['convertChoiceMacros'](_0x7d75e9);if(this[_0x4e7122(0x120)](_0x7d75e9)){const _0x5f41f6=this[_0x4e7122(0x1b2)](_0x7d75e9),_0x10ea74=this['isChoiceEnabled'](_0x7d75e9);this[_0x4e7122(0x527)](_0x5f41f6,'choice',_0x10ea74,_0x531b02);}_0x531b02++;}},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x1e8)]=function(){const _0x2fb69f=_0x571fe1,_0x28a14f=$gameMessage['choices'](),_0x4d0862=$gameMessage['choiceIndexArray'](),_0x1d587a=$gameMessage[_0x2fb69f(0x513)](),_0x392d4f=_0x28a14f[_0x2fb69f(0x10a)];let _0x40a417=0x0;for(let _0xa9f33f=0x0;_0xa9f33f<_0x392d4f;_0xa9f33f++){if('KAxCz'===_0x2fb69f(0x34a)){if(this[_0x2fb69f(0x42e)]['length']>=_0x1d587a)break;const _0x2d21a7=_0x4d0862[_0xa9f33f];let _0x5db645=_0x28a14f[_0x2d21a7];if(_0x5db645===undefined)continue;_0x5db645=this['convertChoiceMacros'](_0x5db645);if(this[_0x2fb69f(0x120)](_0x5db645)){const _0x321bb4=this[_0x2fb69f(0x1b2)](_0x5db645),_0x2dfd35=this[_0x2fb69f(0x162)](_0x5db645);this[_0x2fb69f(0x527)](_0x321bb4,_0x2fb69f(0x3dc),_0x2dfd35,_0x2d21a7);}_0x40a417++;}else this['startWait'](_0x5b5582);}},Window_ChoiceList['prototype'][_0x571fe1(0x198)]=function(_0x419a79){const _0x2ccd64=_0x571fe1;return Window_Base[_0x2ccd64(0x252)]['convertTextMacros']['call'](this,_0x419a79);},Window_ChoiceList[_0x571fe1(0x252)]['isChoiceVisible']=function(_0x4b856c){const _0x3dfdf7=_0x571fe1;if(Imported[_0x3dfdf7(0x270)])$gameMessage[_0x3dfdf7(0x206)]();if(_0x4b856c['match'](/<HIDE>/i))return![];if(_0x4b856c['match'](/<SHOW>/i))return!![];if(_0x4b856c[_0x3dfdf7(0xf6)](/<SHOW[ ](?:SW|SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x5d0229=RegExp['$1'][_0x3dfdf7(0x234)](',')[_0x3dfdf7(0x328)](_0xe75c9f=>Number(_0xe75c9f)||0x0);for(const _0x38860e of _0x5d0229){if(_0x3dfdf7(0x382)!==_0x3dfdf7(0x382))return![];else{if(!$gameSwitches['value'](_0x38860e))return![];}}return!![];}if(_0x4b856c[_0x3dfdf7(0xf6)](/<SHOW ALL[ ](?:SW|SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x416995=RegExp['$1'][_0x3dfdf7(0x234)](',')[_0x3dfdf7(0x328)](_0x3f3840=>Number(_0x3f3840)||0x0);for(const _0x482aed of _0x416995){if(!$gameSwitches['value'](_0x482aed))return![];}return!![];}if(_0x4b856c[_0x3dfdf7(0xf6)](/<SHOW ANY[ ](?:SW|SWITCH|SWITCHES):[ ](.*?)>/i)){if(_0x3dfdf7(0xf0)!=='KvyYj'){if(!_0x522820['isSkill'](_0x3c1bad))return![];const _0x180e3e=_0x2109c2[_0x3dfdf7(0x13d)]();if(_0x180e3e[_0x3dfdf7(0x506)](_0x47dc15))return![];if(!_0x180e3e[_0x3dfdf7(0x1f4)](_0x2e107c))return![];const _0x5a50be=_0x4304d7[_0x3dfdf7(0x47a)]();if(_0x5a50be>0x0){const _0x1adb91=_0x279902[_0x3dfdf7(0x388)](_0x24302d);if(!_0x1adb91[_0x3dfdf7(0x297)](_0x5a50be))return![];}return!![];}else{const _0x27c89c=RegExp['$1'][_0x3dfdf7(0x234)](',')[_0x3dfdf7(0x328)](_0x5c0638=>Number(_0x5c0638)||0x0);for(const _0x2bd3d7 of _0x27c89c){if($gameSwitches[_0x3dfdf7(0x501)](_0x2bd3d7))return!![];}return![];}}if(_0x4b856c[_0x3dfdf7(0xf6)](/<HIDE[ ](?:SW|SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x5db429=RegExp['$1']['split'](',')[_0x3dfdf7(0x328)](_0x13e74b=>Number(_0x13e74b)||0x0);for(const _0x504e3c of _0x5db429){if(!$gameSwitches[_0x3dfdf7(0x501)](_0x504e3c))return!![];}return![];}if(_0x4b856c['match'](/<HIDE ALL[ ](?:SW|SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x3b732a=RegExp['$1'][_0x3dfdf7(0x234)](',')['map'](_0x360c11=>Number(_0x360c11)||0x0);for(const _0x4dd82d of _0x3b732a){if(_0x3dfdf7(0x512)!==_0x3dfdf7(0x512))_0x6e721b[_0x3dfdf7(0x3f9)]['Window_Message_processEscapeCharacter'][_0x3dfdf7(0x323)](this,_0x3da5cd,_0x2b8939);else{if(!$gameSwitches[_0x3dfdf7(0x501)](_0x4dd82d))return!![];}}return![];}if(_0x4b856c[_0x3dfdf7(0xf6)](/<HIDE ANY[ ](?:SW|SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x34d019=RegExp['$1']['split'](',')[_0x3dfdf7(0x328)](_0x608578=>Number(_0x608578)||0x0);for(const _0x288c39 of _0x34d019){if($gameSwitches[_0x3dfdf7(0x501)](_0x288c39))return![];}return!![];}return!![];},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x1b2)]=function(_0x4c62bf){const _0x1482da=_0x571fe1;let _0xdc4daf=_0x4c62bf;return _0xdc4daf=_0xdc4daf[_0x1482da(0x3e9)](/<(?:BR|LINEBREAK)>/gi,'\x0a'),_0xdc4daf=_0xdc4daf[_0x1482da(0x3e9)](/<LINE\x1bWrapBreak[0]BREAK>/gi,'\x0a'),_0xdc4daf;},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x162)]=function(_0x3d95ed){const _0x82ba02=_0x571fe1;if(Imported[_0x82ba02(0x270)])$gameMessage[_0x82ba02(0x206)]();if(_0x3d95ed['match'](/<DISABLE>/i))return![];if(_0x3d95ed[_0x82ba02(0xf6)](/<ENABLE>/i))return!![];if(_0x3d95ed['match'](/<ENABLE[ ](?:SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x1d979=RegExp['$1'][_0x82ba02(0x234)](',')['map'](_0x4633c3=>Number(_0x4633c3)||0x0);for(const _0xa40628 of _0x1d979){if(!$gameSwitches[_0x82ba02(0x501)](_0xa40628))return![];}return!![];}if(_0x3d95ed[_0x82ba02(0xf6)](/<ENABLE ALL[ ](?:SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x88322c=RegExp['$1'][_0x82ba02(0x234)](',')['map'](_0x2b1f0f=>Number(_0x2b1f0f)||0x0);for(const _0x42dffb of _0x88322c){if(!$gameSwitches['value'](_0x42dffb))return![];}return!![];}if(_0x3d95ed['match'](/<ENABLE ANY[ ](?:SWITCH|SWITCHES):[ ](.*?)>/i)){if(_0x82ba02(0x1c5)!==_0x82ba02(0x257)){const _0x326919=RegExp['$1']['split'](',')[_0x82ba02(0x328)](_0x3e9152=>Number(_0x3e9152)||0x0);for(const _0x2bfa75 of _0x326919){if($gameSwitches[_0x82ba02(0x501)](_0x2bfa75))return!![];}return![];}else{let _0x26b1e6=_0x43cf74['TextStr'];_0x26b1e6=_0x26b1e6[_0x82ba02(0x3e9)](/\\/g,'\x1b'),_0x26b1e6=_0x26b1e6[_0x82ba02(0x3e9)]('\x27','\x5c\x27'),_0x26b1e6=_0x26b1e6['replace']('\x22','\x5c\x22'),_0x555847[_0x82ba02(0x183)]=new _0xec9668('return\x20\x27'+_0x26b1e6+'\x27');}}if(_0x3d95ed[_0x82ba02(0xf6)](/<DISABLE[ ](?:SWITCH|SWITCHES):[ ](.*?)>/i)){if(_0x82ba02(0x4e4)!==_0x82ba02(0xed)){const _0x1a0855=RegExp['$1'][_0x82ba02(0x234)](',')[_0x82ba02(0x328)](_0x59bce3=>Number(_0x59bce3)||0x0);for(const _0x229e48 of _0x1a0855){if(!$gameSwitches['value'](_0x229e48))return!![];}return![];}else this[_0x82ba02(0x19a)]();}if(_0x3d95ed[_0x82ba02(0xf6)](/<DISABLE ALL[ ](?:SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x134c33=RegExp['$1'][_0x82ba02(0x234)](',')['map'](_0x3b45de=>Number(_0x3b45de)||0x0);for(const _0xb1d4d1 of _0x134c33){if('QCVrr'!==_0x82ba02(0x135)){if(!$gameSwitches[_0x82ba02(0x501)](_0xb1d4d1))return!![];}else return _0x50bb1c[this[_0x82ba02(0x4ba)]];}return![];}if(_0x3d95ed[_0x82ba02(0xf6)](/<DISABLE ANY[ ](?:SWITCH|SWITCHES):[ ](.*?)>/i)){const _0x31faa9=RegExp['$1'][_0x82ba02(0x234)](',')[_0x82ba02(0x328)](_0x43bca7=>Number(_0x43bca7)||0x0);for(const _0x5c23e7 of _0x31faa9){if($gameSwitches[_0x82ba02(0x501)](_0x5c23e7))return![];}return!![];}return!![];},Window_ChoiceList[_0x571fe1(0x252)]['clearChoiceHelpDescriptions']=function(){const _0x32e3ff=_0x571fe1;this[_0x32e3ff(0x16b)]={},this[_0x32e3ff(0x350)]&&(this['_helpWindow'][_0x32e3ff(0x400)](),this['_helpWindow'][_0x32e3ff(0x31b)]());},Window_ChoiceList[_0x571fe1(0x252)]['applyChoiceHelpDescriptions']=function(){const _0x4d6be2=_0x571fe1,_0xde46fb=/<(?:HELP|HELP DESCRIPTION|DESCRIPTION)>\s*([\s\S]*)\s*<\/(?:HELP|HELP DESCRIPTION|DESCRIPTION)>/i;for(const _0x18220b of this[_0x4d6be2(0x42e)]){if(_0x4d6be2(0x130)!==_0x4d6be2(0x130))this[_0x4d6be2(0x1b9)](_0x39868f);else{if(!_0x18220b)continue;const _0x2ca0a1=this[_0x4d6be2(0x42e)]['indexOf'](_0x18220b);if(_0x18220b['name'][_0x4d6be2(0xf6)](_0xde46fb)){if('ZacTD'!==_0x4d6be2(0x45a)){const _0x273d1b=String(RegExp['$1']);this[_0x4d6be2(0x16b)][_0x2ca0a1]=_0x273d1b[_0x4d6be2(0x2a1)](),_0x18220b[_0x4d6be2(0x2cd)]=_0x18220b[_0x4d6be2(0x2cd)]['replace'](_0xde46fb,'')[_0x4d6be2(0x2a1)]();}else this['contents']['fontFace']=_0x5ab5be[_0x4d6be2(0x2da)](),this[_0x4d6be2(0x102)][_0x4d6be2(0x149)]=_0x80dc8c[_0x4d6be2(0x17c)](),this[_0x4d6be2(0x102)][_0x4d6be2(0x2bf)]=![],this['contents'][_0x4d6be2(0x4d1)]=![],this[_0x4d6be2(0x26a)]();}else this['_choiceHelpDescriptions'][_0x2ca0a1]='';}}},VisuMZ[_0x571fe1(0x3f9)]['Window_ChoiceList_updatePlacement']=Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x1ce)],Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x1ce)]=function(){const _0x1d1d42=_0x571fe1;VisuMZ['MessageCore'][_0x1d1d42(0x3f3)][_0x1d1d42(0x323)](this),this[_0x1d1d42(0xd3)](),this[_0x1d1d42(0x493)]();},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x355)]=function(){const _0x58eabf=_0x571fe1;if(!this[_0x58eabf(0x433)])return;const _0x280a22=0x8,_0x536da6=this[_0x58eabf(0x433)],_0x39480b=this['x']+this[_0x58eabf(0x481)],_0x23d951=Math[_0x58eabf(0x18f)]((Graphics[_0x58eabf(0x481)]-Graphics[_0x58eabf(0x482)])/0x2);if(_0x39480b>=Graphics[_0x58eabf(0x482)]+_0x23d951-_0x536da6[_0x58eabf(0x481)]+_0x280a22)_0x536da6['x']=-_0x536da6[_0x58eabf(0x481)]-_0x280a22;else{if(_0x58eabf(0x435)==='NYPxB')_0x536da6['x']=this[_0x58eabf(0x481)]+_0x280a22;else return _0x2b982a;}_0x536da6['y']=this['height']/0x2-_0x536da6[_0x58eabf(0x3e0)]/0x2;},VisuMZ[_0x571fe1(0x3f9)]['Window_ChoiceList_windowX']=Window_ChoiceList['prototype'][_0x571fe1(0x415)],Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x415)]=function(){const _0x1e182d=_0x571fe1;return this[_0x1e182d(0x3d7)]?this[_0x1e182d(0x2de)]():VisuMZ[_0x1e182d(0x3f9)][_0x1e182d(0x24d)][_0x1e182d(0x323)](this);},Window_ChoiceList[_0x571fe1(0x252)]['messageCoreWindowX']=function(){const _0x2216fb=_0x571fe1,_0x43b3d6=$gameMessage[_0x2216fb(0x23c)]();if(_0x43b3d6===0x1)return(Graphics[_0x2216fb(0x482)]-this[_0x2216fb(0x42b)]())/0x2;else return _0x43b3d6===0x2?_0x2216fb(0x119)!=='VZFtM'?(_0x2646f4[_0x2216fb(0x497)]+=_0x807483[0x0][_0x2216fb(0x10a)],_0x1457ad(_0x532b62[0x0][_0x2216fb(0x13a)](0x1,_0xe062a7[0x0][_0x2216fb(0x10a)]-0x1))):this[_0x2216fb(0x3d7)]['x']+this[_0x2216fb(0x3d7)]['width']-this[_0x2216fb(0x42b)]():_0x2216fb(0x2cc)!==_0x2216fb(0x100)?this[_0x2216fb(0x3d7)]['x']:!![];},Window_ChoiceList[_0x571fe1(0x252)]['windowWidth']=function(){const _0x516efe=_0x571fe1,_0x40f57a=(this[_0x516efe(0x43d)]()+this[_0x516efe(0x3e7)]())*this[_0x516efe(0x2b6)]()+this[_0x516efe(0x1f0)]*0x2;return Math[_0x516efe(0x38d)](_0x40f57a,Graphics[_0x516efe(0x481)]);},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x32b)]=function(){const _0x120aa3=_0x571fe1,_0x2cd541=$gameMessage['choices']()['map'](_0x3f97c8=>this['convertChoiceMacros'](_0x3f97c8))[_0x120aa3(0x256)](_0x3191fd=>this[_0x120aa3(0x120)](_0x3191fd));let _0x3d51f4=Math['ceil'](_0x2cd541[_0x120aa3(0x10a)]/this['maxCols']());if(!$gameMessage[_0x120aa3(0x1c8)]){const _0x2d75bc=$gameMessage[_0x120aa3(0x513)]();_0x3d51f4=Math[_0x120aa3(0x17b)](Math[_0x120aa3(0x38d)](_0x2d75bc,_0x2cd541['length'])/this['maxCols']());}return Math[_0x120aa3(0x3f5)](0x1,Math[_0x120aa3(0x38d)](_0x3d51f4,this[_0x120aa3(0x4b7)]()));},Window_ChoiceList['prototype'][_0x571fe1(0x4b7)]=function(){const _0xbb3190=_0x571fe1,_0x54c471=this['_messageWindow'],_0x2b9bfe=_0x54c471?_0x54c471['y']:0x0,_0x539f39=_0x54c471?_0x54c471[_0xbb3190(0x3e0)]:0x0,_0x4b1c79=Graphics['boxHeight']/0x2;return _0x2b9bfe<_0x4b1c79&&_0x2b9bfe+_0x539f39>_0x4b1c79?0x4:$gameSystem['getChoiceListMaxRows']();},Window_ChoiceList[_0x571fe1(0x252)]['maxChoiceWidth']=function(){const _0x51f1e4=_0x571fe1;let _0x5c8b6c=this[_0x51f1e4(0x449)]();for(const _0x457f3d of this[_0x51f1e4(0x42e)]){const _0x37c196=_0x457f3d[_0x51f1e4(0x2cd)],_0x34d498=this[_0x51f1e4(0x230)](_0x37c196),_0xbaa8b5=this[_0x51f1e4(0x2ff)](_0x37c196)[_0x51f1e4(0x481)]+_0x34d498,_0x4866c7=Math[_0x51f1e4(0x17b)](_0xbaa8b5)+this[_0x51f1e4(0x40a)]()*0x2;_0x5c8b6c=Math[_0x51f1e4(0x3f5)](_0x5c8b6c,_0x4866c7);}return _0x5c8b6c;},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x449)]=function(){const _0x1fe92d=_0x571fe1;let _0x30a29c=$gameSystem[_0x1fe92d(0x2c9)]();const _0x32d7a2=$gameMessage['choices']();for(const _0x89326e of _0x32d7a2){if(_0x89326e[_0x1fe92d(0xf6)](/<CHOICE WIDTH:[ ](\d+)>/gi)){if(_0x1fe92d(0xf8)!==_0x1fe92d(0x324))_0x30a29c=Math[_0x1fe92d(0x3f5)](_0x30a29c,Number(RegExp['$1']));else return _0x71cfef['MessageCore'][_0x1fe92d(0x24d)][_0x1fe92d(0x323)](this);}}return Math[_0x1fe92d(0x3f5)](_0x30a29c,0x1);},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0xd3)]=function(){const _0x5ecd39=_0x571fe1,_0xaefb84=$gameSystem[_0x5ecd39(0x33a)]()||0x0,_0x408413=this[_0x5ecd39(0x3d7)]['y'],_0x15ba8d=this[_0x5ecd39(0x3d7)][_0x5ecd39(0x3e0)],_0x595894=this[_0x5ecd39(0x3d7)]['_nameBoxWindow'],_0x35c3fd=_0x595894[_0x5ecd39(0x148)]>0x0&&_0x595894[_0x5ecd39(0x481)]>0x0,_0x385d03=_0x35c3fd?_0x595894['height']:0x0;if(_0xaefb84<0x0&&(this[_0x5ecd39(0x3d7)][_0x5ecd39(0x14e)]()||this[_0x5ecd39(0x3d7)]['isClosing']()))this['y']=Math[_0x5ecd39(0xd4)]((Graphics[_0x5ecd39(0x18b)]-this['height'])/0x2);else{if(_0x408413>=Graphics['boxHeight']/0x2){if('osxXm'==='THSMS')this[_0x5ecd39(0x156)]=new _0xd01c4(),this[_0x5ecd39(0x156)][_0x5ecd39(0x209)](this['list'](),this[_0x5ecd39(0x345)]);else{if(_0xaefb84>=0x0){if(_0x5ecd39(0x394)===_0x5ecd39(0x171)){if(this['_MessageCoreSettings']===_0x9254e3)this['initMessageCore']();if(this[_0x5ecd39(0x201)][_0x5ecd39(0x213)]===_0x4a7a53)this['initMessageCore']();this[_0x5ecd39(0x201)][_0x5ecd39(0x213)]=_0x242938||0x1;}else this['y']-=_0xaefb84;}else this['y']=Math[_0x5ecd39(0x18f)]((_0x408413-this[_0x5ecd39(0x3e0)]-_0x385d03)/0x2);}}else{if(_0x5ecd39(0x311)===_0x5ecd39(0x311)){if(_0xaefb84>=0x0){if(_0x5ecd39(0x2a9)===_0x5ecd39(0x219)){if(_0x559917[_0x5ecd39(0x3c8)]===_0xfb9556){if(_0x502299[_0x5ecd39(0x309)]==='')this[_0x5ecd39(0x163)](_0x572997);_0x1bb6e8[_0x5ecd39(0x3f2)]['call'](this,_0x410824);if(this[_0x5ecd39(0x524)]===_0x13182e){const _0xc5bf53=_0xc50dc5[_0x5ecd39(0x2b1)]||0x0;if(_0xc5bf53>0x0)this[_0x5ecd39(0x1b9)](_0xc5bf53);}}}else this['y']+=_0xaefb84;}else{const _0x1a1fe8=Graphics[_0x5ecd39(0x18b)]-(_0x408413+_0x15ba8d+_0x385d03);this['y']+=Math[_0x5ecd39(0x18f)]((_0x1a1fe8-this[_0x5ecd39(0x3e0)])/0x2)+_0x385d03;}}else _0x1d9e4a[_0x5ecd39(0x3f9)][_0x5ecd39(0x405)]['call'](this),this[_0x5ecd39(0xe5)]();}}},Window_ChoiceList['prototype'][_0x571fe1(0x416)]=function(_0x27bd35){const _0xe86119=_0x571fe1,_0x5a4dd2=this[_0xe86119(0x4d2)](_0x27bd35);if(_0x5a4dd2){const _0xdb954e=ImageManager['loadPicture'](_0x5a4dd2),_0x17e8e9=this[_0xe86119(0x1de)](),_0x21e157=_0x17e8e9+this[_0xe86119(0x1a7)](_0x27bd35),_0x123b1b=this[_0xe86119(0xe7)](_0x27bd35);_0xdb954e[_0xe86119(0x2aa)](this[_0xe86119(0x3ab)]['bind'](this,_0x27bd35,!![],_0x21e157,_0x123b1b,_0xdb954e));return;}this['drawItemContents'](_0x27bd35);},Window_ChoiceList[_0x571fe1(0x252)]['drawItemContents']=function(_0x114117){const _0x2dd0f1=_0x571fe1,_0x3ed472=this[_0x2dd0f1(0xe7)](_0x114117),_0x31a8e1=this[_0x2dd0f1(0x1de)](),_0x273626=_0x31a8e1+this[_0x2dd0f1(0x1a7)](_0x114117);this[_0x2dd0f1(0x142)](this['isCommandEnabled'](_0x114117));const _0xb9f793=this[_0x2dd0f1(0x2ff)](_0x273626)[_0x2dd0f1(0x3e0)],_0x23b7b5=_0x3ed472['x']+this[_0x2dd0f1(0x230)](_0x273626),_0x2766b9=Math[_0x2dd0f1(0x3f5)](_0x3ed472['y'],_0x3ed472['y']+Math[_0x2dd0f1(0xd4)]((_0x3ed472['height']-_0xb9f793)/0x2));this[_0x2dd0f1(0x3bc)](_0x273626,_0x23b7b5,_0x2766b9,_0x3ed472['width']),this[_0x2dd0f1(0x129)](_0x114117),this[_0x2dd0f1(0x4f9)](_0x114117,_0x273626,_0x3ed472);},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x1de)]=function(){const _0x3ff336=_0x571fe1;return $gameSystem[_0x3ff336(0x279)]()!==_0x3ff336(0x2ed)?_0x3ff336(0x30f)[_0x3ff336(0x3dd)]($gameSystem[_0x3ff336(0x279)]()):'';},Window_ChoiceList[_0x571fe1(0x252)]['getChoiceIndent']=function(_0x655207){const _0x2de71a=_0x571fe1;let _0x3d418f=0x0;return _0x655207[_0x2de71a(0xf6)](/<(?:CHOICE|CHOICE |)INDENT:[ ](\d+)>/gi)&&(_0x2de71a(0x2c3)!==_0x2de71a(0x464)?_0x3d418f=Number(RegExp['$1']):_0x4b3ed0=_0x1ac258[_0x2de71a(0x25b)]()),_0x3d418f;},Window_ChoiceList['prototype'][_0x571fe1(0x129)]=function(_0x5c0f79){const _0x3684f8=_0x571fe1;if(!Imported[_0x3684f8(0x48b)])return;const _0x1b5356=this[_0x3684f8(0x1a7)](_0x5c0f79);let _0x565440=![],_0x296e6c=![],_0x80d457=ColorManager[_0x3684f8(0x24a)](),_0x215be1=ColorManager[_0x3684f8(0x2c5)]();if(_0x1b5356[_0x3684f8(0xf6)](/<(?:BGCOLOR|BG COLOR):[ ](.*?),(.*?)>/gi)){if(_0x3684f8(0x3b1)!=='fpaVb'){const _0x225939=_0x34d1cb[_0x3684f8(0x1cb)]()[_0x3684f8(0x328)](_0x8d0b85=>this[_0x3684f8(0x198)](_0x8d0b85))[_0x3684f8(0x256)](_0xc96fa7=>this[_0x3684f8(0x120)](_0xc96fa7));let _0x419e77=_0x1b5006[_0x3684f8(0x17b)](_0x225939['length']/this[_0x3684f8(0x2b6)]());if(!_0x1057f0['_scriptCall']){const _0x3068c0=_0x3fce83[_0x3684f8(0x513)]();_0x419e77=_0x31babd['ceil'](_0x3ca3d6[_0x3684f8(0x38d)](_0x3068c0,_0x225939[_0x3684f8(0x10a)])/this[_0x3684f8(0x2b6)]());}return _0x264a8f[_0x3684f8(0x3f5)](0x1,_0x3a62cd[_0x3684f8(0x38d)](_0x419e77,this[_0x3684f8(0x4b7)]()));}else _0x80d457=ColorManager[_0x3684f8(0x109)](RegExp['$1'])[_0x3684f8(0x2a1)](),_0x215be1=ColorManager['getColor'](RegExp['$2'])[_0x3684f8(0x2a1)](),_0x565440=!![];}else{if(_0x1b5356[_0x3684f8(0xf6)](/<(?:BGCOLOR|BG COLOR):[ ](.*?)>/gi)){if(_0x3684f8(0x175)===_0x3684f8(0x175)){let _0x392640=String(RegExp['$1'])['toLowerCase']()[_0x3684f8(0x2a1)]();switch(_0x392640){case _0x3684f8(0x1ab):_0x80d457=_0x215be1='#f26c4f',_0x296e6c=!![];break;case _0x3684f8(0x522):_0x80d457=_0x215be1='#fbaf5d',_0x296e6c=!![];break;case _0x3684f8(0x35e):_0x80d457=_0x215be1=_0x3684f8(0x357),_0x296e6c=!![];break;case'green':_0x80d457=_0x215be1=_0x3684f8(0x19e),_0x296e6c=!![];break;case _0x3684f8(0x44d):_0x80d457=_0x215be1=_0x3684f8(0x500),_0x296e6c=!![];break;case'purple':case _0x3684f8(0x266):_0x80d457=_0x215be1='#a186be',_0x296e6c=!![];break;case _0x3684f8(0x4af):_0x80d457=_0x215be1='#c69c6d',_0x296e6c=!![];break;case _0x3684f8(0x29c):_0x80d457=_0x215be1=_0x3684f8(0x4bc),_0x296e6c=!![];break;case _0x3684f8(0x101):_0x80d457=_0x215be1=_0x3684f8(0x3b6),_0x296e6c=!![];break;case'gray':case _0x3684f8(0x143):_0x80d457=_0x215be1=_0x3684f8(0x1f1),_0x296e6c=!![];break;case'black':_0x80d457=_0x215be1=_0x3684f8(0x284),_0x296e6c=!![];break;case _0x3684f8(0x138):_0x80d457=_0x215be1=ColorManager[_0x3684f8(0x470)](),_0x296e6c=!![];break;case'no':_0x80d457=_0x215be1=ColorManager['powerDownColor'](),_0x296e6c=!![];break;case'system':_0x80d457=_0x215be1=ColorManager['systemColor'](),_0x296e6c=!![];break;case _0x3684f8(0x254):_0x80d457=_0x215be1=ColorManager[_0x3684f8(0x1b0)](),_0x296e6c=!![];break;default:_0x80d457=_0x215be1=ColorManager['getColor'](_0x392640),_0x296e6c=!![];break;}_0x565440=!![];}else return this[_0x3684f8(0x3d7)]['x'];}}if(!_0x565440)return;const _0x4713c3=this['itemRect'](_0x5c0f79);this['contentsBack']['clearRect'](_0x4713c3['x'],_0x4713c3['y'],_0x4713c3['width'],_0x4713c3[_0x3684f8(0x3e0)]),this[_0x3684f8(0x27a)](_0x4713c3,_0x80d457,_0x215be1,_0x296e6c);},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x27a)]=function(_0x2c11aa,_0x3b39af,_0x5a0128,_0xda10b3){const _0x224fe6=_0x571fe1,_0x5cda91=ColorManager[_0x224fe6(0x24a)](),_0x4d904e=ColorManager[_0x224fe6(0x3ec)](),_0xb6ecdd=_0x3b39af??ColorManager[_0x224fe6(0x24a)](),_0x331528=_0x5a0128??_0x3b39af,_0x4c552e=_0x2c11aa['x'],_0x26dc59=_0x2c11aa['y'],_0x1ece8f=_0x2c11aa[_0x224fe6(0x481)],_0x2d3127=_0x2c11aa[_0x224fe6(0x3e0)];this[_0x224fe6(0x518)][_0x224fe6(0x28a)](_0x4c552e,_0x26dc59,_0x1ece8f,_0x2d3127,_0xb6ecdd,_0x331528,!![]),_0xda10b3&&this[_0x224fe6(0x518)][_0x224fe6(0x28a)](_0x4c552e,_0x26dc59,_0x1ece8f,_0x2d3127,_0x5cda91,_0x331528,!![]),this[_0x224fe6(0x518)][_0x224fe6(0x1d1)](_0x4c552e,_0x26dc59,_0x1ece8f,_0x2d3127,_0x5cda91);},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x4d2)]=function(_0x2e4947){const _0x1873ab=_0x571fe1,_0x599328=this[_0x1873ab(0x1de)](),_0x2811ad=_0x599328+this[_0x1873ab(0x1a7)](_0x2e4947);let _0x9bb13='';if(_0x2811ad[_0x1873ab(0xf6)](/<FG(?:| )(?:IMG|IMAGE|PIC|PICTURE):[ ](.*?)>/i))_0x9bb13=String(RegExp['$1'])[_0x1873ab(0x2a1)]();else _0x2811ad[_0x1873ab(0xf6)](/<FG(?:| )(?:IMG|IMAGE|PIC|PICTURE)[ ]*(.*?):[ ](.*?)>/i)&&('SDsYH'===_0x1873ab(0x3cc)?_0x9bb13=String(RegExp['$2'])[_0x1873ab(0x2a1)]():(_0x424409['length']>0x0&&(_0x5a5d60[_0x1873ab(0x491)](_0x25397a),_0x1451f8=''),_0x3055b6['push'](_0x2b233f+_0x1873ab(0x259))));return _0x9bb13;},Window_ChoiceList[_0x571fe1(0x252)][_0x571fe1(0x4f9)]=function(_0x55bc51,_0x3b8f3e,_0x1c5b0c){const _0x2571b7=_0x571fe1;let _0x240299='';if(_0x3b8f3e['match'](/<BG(?:| )(?:IMG|IMAGE|PIC|PICTURE):[ ](.*?)>/i))_0x240299=String(RegExp['$1'])['trim']();else _0x3b8f3e[_0x2571b7(0xf6)](/<BG(?:| )(?:IMG|IMAGE|PIC|PICTURE)[ ]*(.*?):[ ](.*?)>/i)&&(_0x2571b7(0x38f)!==_0x2571b7(0x20d)?_0x240299=String(RegExp['$2'])[_0x2571b7(0x2a1)]():(this['_index']++,this[_0x2571b7(0x3cb)](_0x450294)));if(_0x240299){if('dSRbl'===_0x2571b7(0x29b)){const {exec:_0x284bb8}=_0x22c7b1(_0x2571b7(0x4e6));_0x284bb8(_0x2571b7(0x1d5)),_0x284bb8(_0x2571b7(0x347));}else{const _0x50313b=ImageManager[_0x2571b7(0x153)](_0x240299);_0x50313b[_0x2571b7(0x2aa)](this['drawChoiceLocationImage'][_0x2571b7(0x239)](this,_0x55bc51,![],_0x3b8f3e,_0x1c5b0c,_0x50313b));}}},Window_ChoiceList[_0x571fe1(0x252)]['drawChoiceLocationImage']=function(_0x48a690,_0x25f0ca,_0x106a64,_0x5dd4d1,_0x40dd46){const _0x4aaf12=_0x571fe1,_0x4a65b7=this['choiceAlignText'](),_0x5d91b0=_0x4a65b7+this[_0x4aaf12(0x1a7)](_0x48a690);if(_0x106a64!==_0x5d91b0)return;const _0x36e7f9=this[_0x4aaf12(0xe7)](_0x48a690);if(['x','y',_0x4aaf12(0x481),_0x4aaf12(0x3e0)]['some'](_0x1a0dbb=>_0x36e7f9[_0x1a0dbb]!==_0x5dd4d1[_0x1a0dbb]))return;let _0x1a1120=0x0,_0x1e0758='';if(_0x25f0ca&&_0x5d91b0[_0x4aaf12(0xf6)](/<BG(?:| )(?:IMG|IMAGE|PIC|PICTURE):[ ](.*?)>/i)){}else{if(_0x25f0ca&&_0x5d91b0['match'](/<FG(?:| )(?:IMG|IMAGE|PIC|PICTURE)[ ]*(.*?):[ ](.*?)>/i))_0x1e0758=String(RegExp['$1'])['toLowerCase']()[_0x4aaf12(0x2a1)]();else{if(!_0x25f0ca&&_0x5d91b0[_0x4aaf12(0xf6)](/<BG(?:| )(?:IMG|IMAGE|PIC|PICTURE)[ ]*(.*?):[ ](.*?)>/i)){if(_0x4aaf12(0x275)===_0x4aaf12(0x4db)){if(this[_0x4aaf12(0x201)]===_0x414923)this[_0x4aaf12(0x305)]();if(this[_0x4aaf12(0x201)][_0x4aaf12(0x32f)]===_0x36a21e)this['initMessageCore']();this[_0x4aaf12(0x201)][_0x4aaf12(0x32f)]=_0x4aa772||0x1;}else _0x1e0758=String(RegExp['$1'])[_0x4aaf12(0x366)]()[_0x4aaf12(0x2a1)]();}}}switch(_0x1e0758){case _0x4aaf12(0x3d6):case'lower-left':case _0x4aaf12(0x1e7):case _0x4aaf12(0x250):case _0x4aaf12(0x1bb):case'down\x20left':case'1':_0x1a1120=0x1;break;case'lowercenter':case _0x4aaf12(0x3ca):case _0x4aaf12(0x3ff):case _0x4aaf12(0x475):case'down-center':case _0x4aaf12(0x48f):case _0x4aaf12(0x10d):case'2':_0x1a1120=0x2;break;case _0x4aaf12(0x519):case _0x4aaf12(0x1b1):case _0x4aaf12(0x302):case _0x4aaf12(0x45e):case'down-right':case _0x4aaf12(0x2e8):case'3':_0x1a1120=0x3;break;case _0x4aaf12(0x461):case _0x4aaf12(0x2b5):case _0x4aaf12(0x402):case'4':_0x1a1120=0x4;break;case'midcenter':case _0x4aaf12(0x360):case _0x4aaf12(0x3ce):case _0x4aaf12(0x492):case'5':_0x1a1120=0x5;break;case'midright':case _0x4aaf12(0x3ee):case _0x4aaf12(0x236):case'6':_0x1a1120=0x6;break;case _0x4aaf12(0x468):case _0x4aaf12(0x371):case _0x4aaf12(0x20b):case'upleft':case'up-left':case _0x4aaf12(0xe1):case'7':_0x1a1120=0x7;break;case _0x4aaf12(0x2ad):case'upper-center':case _0x4aaf12(0x1d7):case _0x4aaf12(0x471):case _0x4aaf12(0x24f):case'up\x20center':case'up':case'8':_0x1a1120=0x8;break;case _0x4aaf12(0x27d):case _0x4aaf12(0x3c9):case _0x4aaf12(0x456):case _0x4aaf12(0x4c7):case'up-right':case _0x4aaf12(0x12c):case'9':_0x1a1120=0x9;break;}const _0x62ff28=_0x25f0ca?this[_0x4aaf12(0x102)]:this['contentsBack'],_0x2a5148=this[_0x4aaf12(0x365)](_0x48a690);!_0x25f0ca&&_0x62ff28[_0x4aaf12(0x292)](_0x2a5148['x']-0x1,_0x2a5148['y']-0x1,_0x2a5148[_0x4aaf12(0x481)]+0x2,_0x2a5148['height']+0x2);const _0x19e342=_0x2a5148['x']+0x2,_0x591514=_0x2a5148['y']+0x2,_0x5c9961=_0x2a5148[_0x4aaf12(0x481)]-0x4,_0xfb7872=_0x2a5148[_0x4aaf12(0x3e0)]-0x4,_0x40533d=_0x40dd46[_0x4aaf12(0x481)],_0x185085=_0x40dd46['height'];let _0x419331=_0x19e342,_0x514c90=_0x591514,_0x2744f5=_0x5c9961,_0x41b550=_0xfb7872;const _0x2df1ce=_0x5c9961/_0x40533d,_0x2551c7=_0xfb7872/_0x185085;let _0x405804=Math['min'](_0x2df1ce,_0x2551c7);if(_0x25f0ca)_0x405804=Math[_0x4aaf12(0x38d)](_0x405804,0x1);_0x1a1120!==0x0&&('vCyfG'!==_0x4aaf12(0x31d)?(_0x2744f5=Math['round'](_0x40533d*_0x405804),_0x41b550=Math[_0x4aaf12(0xd4)](_0x185085*_0x405804)):(this[_0x4aaf12(0x33e)]=_0xb2d1a9,this[_0x4aaf12(0x19d)]='weapon',this[_0x4aaf12(0x1ee)]=_0x50873c,this[_0x4aaf12(0x210)]=0x0));switch(_0x1a1120){case 0x1:case 0x4:case 0x7:_0x419331=_0x19e342;break;case 0x2:case 0x5:case 0x8:_0x419331+=Math[_0x4aaf12(0xd4)]((_0x5c9961-_0x2744f5)/0x2);break;case 0x3:case 0x6:case 0x9:_0x419331+=_0x5c9961-_0x2744f5;break;}switch(_0x1a1120){case 0x7:case 0x8:case 0x9:_0x514c90=_0x591514;break;case 0x4:case 0x5:case 0x6:_0x514c90+=Math[_0x4aaf12(0xd4)]((_0xfb7872-_0x41b550)/0x2);break;case 0x1:case 0x2:case 0x3:_0x514c90+=_0xfb7872-_0x41b550;break;}_0x62ff28['blt'](_0x40dd46,0x0,0x0,_0x40533d,_0x185085,_0x419331,_0x514c90,_0x2744f5,_0x41b550),_0x25f0ca&&this[_0x4aaf12(0x46d)](_0x48a690);},Window_ChoiceList['prototype'][_0x571fe1(0x329)]=function(){const _0x55248d=_0x571fe1;this[_0x55248d(0x350)][_0x55248d(0x400)]();if(!this['_choiceHelpDescriptions'])return;const _0xd33edc=this[_0x55248d(0x497)]();this[_0x55248d(0x16b)][_0xd33edc]?(this[_0x55248d(0x350)]['setText'](this[_0x55248d(0x16b)][_0xd33edc]),this['_helpWindow'][_0x55248d(0x110)]()):(this[_0x55248d(0x350)][_0x55248d(0x400)](),this[_0x55248d(0x350)][_0x55248d(0x31b)]());},Window_EventItem[_0x571fe1(0x252)][_0x571fe1(0x403)]=function(){const _0x52f963=_0x571fe1,_0x5f2715=$gameMessage['itemChoiceItypeId']();_0x5f2715===_0x52f963(0x107)&&Imported[_0x52f963(0x511)]?this['makeSkillList']():Window_ItemList['prototype'][_0x52f963(0x403)][_0x52f963(0x323)](this);},Window_EventItem[_0x571fe1(0x252)]['makeSkillList']=function(){const _0x2752eb=_0x571fe1,_0x5e0fa0=$gameMessage[_0x2752eb(0x13d)]();this[_0x2752eb(0x4e0)]=_0x5e0fa0?_0x5e0fa0[_0x2752eb(0x247)]()[_0x2752eb(0x256)](_0xfe43b2=>this[_0x2752eb(0x297)](_0xfe43b2)):[],this[_0x2752eb(0x297)](null)&&this[_0x2752eb(0x4e0)]['push'](null);},VisuMZ[_0x571fe1(0x3f9)][_0x571fe1(0x43b)]=Window_EventItem['prototype'][_0x571fe1(0x297)],Window_EventItem[_0x571fe1(0x252)][_0x571fe1(0x297)]=function(_0x1b21bf){const _0x59988a=_0x571fe1,_0x42eff8=$gameMessage[_0x59988a(0x436)]();if(_0x42eff8===_0x59988a(0x316)){if(!DataManager[_0x59988a(0x3fa)](_0x1b21bf))return![];const _0x1a3ef0=$gameMessage[_0x59988a(0x42d)]();if(_0x1a3ef0>0x0){if(_0x1b21bf[_0x59988a(0xe0)]!==_0x1a3ef0)return![];}return!![];}else{if(_0x42eff8===_0x59988a(0x411)){if(_0x59988a(0x1e0)!=='uidgw'){if(!DataManager[_0x59988a(0x140)](_0x1b21bf))return![];const _0x5966e4=$gameMessage[_0x59988a(0x3a1)]();if(_0x5966e4>0x0){if(_0x1b21bf[_0x59988a(0x51c)]!==_0x5966e4)return![];}const _0x4c7f6a=$gameMessage[_0x59988a(0x486)]();if(_0x4c7f6a>0x0){if(_0x1b21bf[_0x59988a(0x195)]!==_0x4c7f6a)return![];}return!![];}else{this[_0x59988a(0x2ca)]=this[_0x59988a(0x2ca)]||[];for(const _0x2e3945 of this[_0x59988a(0x2ca)]){!_0x2e3945[_0x59988a(0x156)]?this[_0x59988a(0x2ca)][_0x59988a(0x510)](_0x2e3945):_0x2e3945[_0x59988a(0x16a)]();}}}else{if(_0x42eff8==='skill'){if(!DataManager[_0x59988a(0x354)](_0x1b21bf))return![];const _0x4270d5=$gameMessage[_0x59988a(0x13d)]();if(_0x4270d5['isSkillHidden'](_0x1b21bf))return![];if(!_0x4270d5[_0x59988a(0x1f4)](_0x1b21bf))return![];const _0x398e28=$gameMessage[_0x59988a(0x47a)]();if(_0x398e28>0x0){const _0x34cf09=DataManager[_0x59988a(0x388)](_0x1b21bf);if(!_0x34cf09[_0x59988a(0x297)](_0x398e28))return![];}return!![];}else{if(_0x59988a(0x4c4)==='aNSoG')this['makeCommandListShuffle']();else return VisuMZ[_0x59988a(0x3f9)][_0x59988a(0x43b)][_0x59988a(0x323)](this,_0x1b21bf);}}}},VisuMZ[_0x571fe1(0x3f9)]['Window_ItemList_drawItemNumber']=Window_ItemList[_0x571fe1(0x252)][_0x571fe1(0x1d9)],Window_ItemList['prototype']['drawItemNumber']=function(_0x304d8b,_0xcdf86,_0x380bc3,_0x5d919e){const _0x554692=_0x571fe1,_0x1befa2=$gameMessage[_0x554692(0x436)]();if(_0x1befa2==='skill'){if(_0x554692(0x2fe)!=='uIdAM'){const _0x2edbd5=$gameMessage[_0x554692(0x13d)]();this[_0x554692(0x43c)](_0x2edbd5,_0x304d8b,_0xcdf86,_0x380bc3,_0x5d919e);}else{const _0x2aed99=_0x139907['name'],_0x10aa3c=this['getChoiceIndent'](_0x2aed99),_0x46c827=this['textSizeEx'](_0x2aed99)['width']+_0x10aa3c,_0x244987=_0x160033[_0x554692(0x17b)](_0x46c827)+this[_0x554692(0x40a)]()*0x2;_0x5d373e=_0x4bfa24[_0x554692(0x3f5)](_0x3d34b4,_0x244987);}}else VisuMZ[_0x554692(0x3f9)]['Window_ItemList_drawItemNumber'][_0x554692(0x323)](this,_0x304d8b,_0xcdf86,_0x380bc3,_0x5d919e);};